/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.datagen.custom;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.westerosblocks.WesterosBlocks;
import com.westerosblocks.block.custom.WCCuboidNEBlock;
import com.westerosblocks.data.BlockDefinitionV2;
import com.westerosblocks.data.BlockStateRecordV2;
import com.westerosblocks.datagen.custom.CuboidBlockExporter;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4917;

public class CuboidNEBlockExporter
extends CuboidBlockExporter {
    public static void registerCustomCuboidNEBlock(class_4910 generator, class_2248 block, BlockDefinitionV2 definition) {
        if (!(block instanceof WCCuboidNEBlock)) {
            throw new IllegalArgumentException("Block must be a WCCuboidNEBlock instance");
        }
        WCCuboidNEBlock cuboidBlock = (WCCuboidNEBlock)block;
        List<BlockDefinitionV2.StateVariantV2> states = definition.getStates();
        if (states == null || states.isEmpty()) {
            throw new IllegalStateException("Block definition states should never be null/empty after doInit() for block: " + CuboidNEBlockExporter.getBlockName(block));
        }
        boolean hasMultipleStates = definition.getStateCount() > 1;
        CuboidNEBlockExporter exporter = new CuboidNEBlockExporter();
        Map<String, List<class_2960>> stateModelMap = exporter.generateModelsReturnMap(generator, block, definition);
        if (stateModelMap.isEmpty()) {
            WesterosBlocks.LOGGER.warn("No models generated for NE cuboid block: {}", (Object)CuboidNEBlockExporter.getBlockName(block));
            return;
        }
        generator.field_22830.accept(CuboidNEBlockExporter.generateNEBlockState(block, stateModelMap, states, hasMultipleStates));
        class_2960 firstModel = stateModelMap.values().iterator().next().get(0);
        CuboidNEBlockExporter.registerParentedItemModel(generator, block, firstModel);
    }

    private static class_4917 generateNEBlockState(final class_2248 block, final Map<String, List<class_2960>> stateModelMap, final List<BlockDefinitionV2.StateVariantV2> states, final boolean hasMultipleStates) {
        return new class_4917(){

            public class_2248 method_25743() {
                return block;
            }

            public JsonElement get() {
                JsonObject json = new JsonObject();
                JsonObject variants = new JsonObject();
                for (BlockDefinitionV2.StateVariantV2 state : states) {
                    String stateId = state.getStateID() != null ? state.getStateID() : "base";
                    List modelIds = (List)stateModelMap.get(stateId);
                    if (modelIds == null || modelIds.isEmpty()) continue;
                    Object eastKey = hasMultipleStates ? "facing=east,state=" + stateId : "facing=east";
                    Object northKey = hasMultipleStates ? "facing=north,state=" + stateId : "facing=north";
                    List randomTextures = state.randomTextures;
                    if (randomTextures != null && !randomTextures.isEmpty() && modelIds.size() > 1) {
                        JsonArray eastVariants = new JsonArray();
                        JsonArray northVariants = new JsonArray();
                        for (int i = 0; i < modelIds.size() && i < randomTextures.size(); ++i) {
                            JsonObject variant;
                            int w;
                            int weight = ((BlockStateRecordV2.RandomTextureSet)randomTextures.get(i)).getWeight();
                            for (w = 0; w < weight; ++w) {
                                variant = new JsonObject();
                                variant.addProperty("model", ((class_2960)modelIds.get(i)).toString());
                                eastVariants.add((JsonElement)variant);
                            }
                            for (w = 0; w < weight; ++w) {
                                variant = new JsonObject();
                                variant.addProperty("model", ((class_2960)modelIds.get(i)).toString());
                                variant.addProperty("y", (Number)90);
                                northVariants.add((JsonElement)variant);
                            }
                        }
                        variants.add((String)eastKey, (JsonElement)eastVariants);
                        variants.add((String)northKey, (JsonElement)northVariants);
                        continue;
                    }
                    class_2960 modelId = (class_2960)modelIds.get(0);
                    JsonObject eastVariant = new JsonObject();
                    eastVariant.addProperty("model", modelId.toString());
                    variants.add((String)eastKey, (JsonElement)eastVariant);
                    JsonObject northVariant = new JsonObject();
                    northVariant.addProperty("model", modelId.toString());
                    northVariant.addProperty("y", (Number)90);
                    variants.add((String)northKey, (JsonElement)northVariant);
                }
                json.add("variants", (JsonElement)variants);
                return json;
            }
        };
    }
}

