/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.datagen.custom;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.westerosblocks.WesterosBlocks;
import com.westerosblocks.data.BlockDefinitionV2;
import com.westerosblocks.data.BlockStateRecordV2;
import com.westerosblocks.datagen.custom.CuboidBlockExporter;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4917;

public class CuboidNSEWBlockExporter
extends CuboidBlockExporter {
    public static void registerCustomCuboidNSEWBlock(class_4910 generator, class_2248 block, BlockDefinitionV2 definition) {
        List<BlockDefinitionV2.StateVariantV2> states = definition.getStates();
        if (states == null || states.isEmpty()) {
            throw new IllegalStateException("Block definition states should never be null/empty after doInit() for block: " + CuboidNSEWBlockExporter.getBlockName(block));
        }
        boolean hasMultipleStates = definition.getStateCount() > 1;
        CuboidNSEWBlockExporter exporter = new CuboidNSEWBlockExporter();
        Map<String, List<class_2960>> stateModelMap = exporter.generateModelsReturnMap(generator, block, definition);
        if (stateModelMap.isEmpty()) {
            WesterosBlocks.LOGGER.warn("No models generated for NSEW cuboid block: {}", (Object)CuboidNSEWBlockExporter.getBlockName(block));
            return;
        }
        generator.field_22830.accept(CuboidNSEWBlockExporter.generateNSEWBlockState(block, stateModelMap, states, hasMultipleStates));
        class_2960 firstModel = stateModelMap.values().iterator().next().get(0);
        CuboidNSEWBlockExporter.registerParentedItemModel(generator, block, firstModel);
    }

    private static class_4917 generateNSEWBlockState(final class_2248 block, final Map<String, List<class_2960>> stateModelMap, final List<BlockDefinitionV2.StateVariantV2> states, final boolean hasMultipleStates) {
        return new class_4917(){

            public class_2248 method_25743() {
                return block;
            }

            public JsonElement get() {
                JsonObject json = new JsonObject();
                JsonObject variants = new JsonObject();
                for (BlockDefinitionV2.StateVariantV2 state : states) {
                    String stateId = state.getStateID() != null ? state.getStateID() : "base";
                    List modelIds = (List)stateModelMap.get(stateId);
                    if (modelIds == null || modelIds.isEmpty()) continue;
                    int rotYOffset = 0;
                    if (state.rotYOffset != 0) {
                        rotYOffset = state.rotYOffset;
                    }
                    Object northKey = hasMultipleStates ? "facing=north,state=" + stateId : "facing=north";
                    Object eastKey = hasMultipleStates ? "facing=east,state=" + stateId : "facing=east";
                    Object southKey = hasMultipleStates ? "facing=south,state=" + stateId : "facing=south";
                    Object westKey = hasMultipleStates ? "facing=west,state=" + stateId : "facing=west";
                    List randomTextures = state.randomTextures;
                    if (randomTextures != null && !randomTextures.isEmpty() && modelIds.size() > 1) {
                        JsonArray northVariants = new JsonArray();
                        JsonArray eastVariants = new JsonArray();
                        JsonArray southVariants = new JsonArray();
                        JsonArray westVariants = new JsonArray();
                        for (int i = 0; i < modelIds.size() && i < randomTextures.size(); ++i) {
                            int rot;
                            JsonObject variant;
                            int w;
                            int weight = ((BlockStateRecordV2.RandomTextureSet)randomTextures.get(i)).getWeight();
                            for (w = 0; w < weight; ++w) {
                                variant = new JsonObject();
                                variant.addProperty("model", ((class_2960)modelIds.get(i)).toString());
                                rot = (270 + rotYOffset) % 360;
                                if (rot > 0) {
                                    variant.addProperty("y", (Number)rot);
                                }
                                northVariants.add((JsonElement)variant);
                            }
                            for (w = 0; w < weight; ++w) {
                                variant = new JsonObject();
                                variant.addProperty("model", ((class_2960)modelIds.get(i)).toString());
                                rot = rotYOffset % 360;
                                if (rot > 0) {
                                    variant.addProperty("y", (Number)rot);
                                }
                                eastVariants.add((JsonElement)variant);
                            }
                            for (w = 0; w < weight; ++w) {
                                variant = new JsonObject();
                                variant.addProperty("model", ((class_2960)modelIds.get(i)).toString());
                                rot = (90 + rotYOffset) % 360;
                                if (rot > 0) {
                                    variant.addProperty("y", (Number)rot);
                                }
                                southVariants.add((JsonElement)variant);
                            }
                            for (w = 0; w < weight; ++w) {
                                variant = new JsonObject();
                                variant.addProperty("model", ((class_2960)modelIds.get(i)).toString());
                                rot = (180 + rotYOffset) % 360;
                                if (rot > 0) {
                                    variant.addProperty("y", (Number)rot);
                                }
                                westVariants.add((JsonElement)variant);
                            }
                        }
                        variants.add((String)northKey, (JsonElement)northVariants);
                        variants.add((String)eastKey, (JsonElement)eastVariants);
                        variants.add((String)southKey, (JsonElement)southVariants);
                        variants.add((String)westKey, (JsonElement)westVariants);
                        continue;
                    }
                    class_2960 modelId = (class_2960)modelIds.get(0);
                    JsonObject northVariant = new JsonObject();
                    northVariant.addProperty("model", modelId.toString());
                    int northRot = (270 + rotYOffset) % 360;
                    if (northRot > 0) {
                        northVariant.addProperty("y", (Number)northRot);
                    }
                    variants.add((String)northKey, (JsonElement)northVariant);
                    JsonObject eastVariant = new JsonObject();
                    eastVariant.addProperty("model", modelId.toString());
                    int eastRot = rotYOffset % 360;
                    if (eastRot > 0) {
                        eastVariant.addProperty("y", (Number)eastRot);
                    }
                    variants.add((String)eastKey, (JsonElement)eastVariant);
                    JsonObject southVariant = new JsonObject();
                    southVariant.addProperty("model", modelId.toString());
                    int southRot = (90 + rotYOffset) % 360;
                    if (southRot > 0) {
                        southVariant.addProperty("y", (Number)southRot);
                    }
                    variants.add((String)southKey, (JsonElement)southVariant);
                    JsonObject westVariant = new JsonObject();
                    westVariant.addProperty("model", modelId.toString());
                    int westRot = (180 + rotYOffset) % 360;
                    if (westRot > 0) {
                        westVariant.addProperty("y", (Number)westRot);
                    }
                    variants.add((String)westKey, (JsonElement)westVariant);
                }
                json.add("variants", (JsonElement)variants);
                return json;
            }
        };
    }
}

