/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.datagen.custom;

import com.westerosblocks.WesterosBlocks;
import com.westerosblocks.block.custom.WCFanBlock;
import com.westerosblocks.block.custom.WCWallFanBlock;
import com.westerosblocks.data.BlockDefinitionV2;
import com.westerosblocks.datagen.ModModels;
import com.westerosblocks.datagen.ModTextureKey;
import com.westerosblocks.datagen.custom.BaseBlockExporter;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4941;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_7923;

public class FanBlockExporter
extends BaseBlockExporter {
    public static void registerFanBlock(class_4910 generator, class_2248 standingFan, String texturePath) {
        class_2248 wallFan = (class_2248)class_7923.field_41175.method_10223(WesterosBlocks.id("wall_" + standingFan.method_9539().replace("block.westerosblocks.", "")));
        FanBlockExporter.generateStandingFanBlockState(generator, standingFan, texturePath);
        if (wallFan != null) {
            FanBlockExporter.generateWallFanBlockState(generator, wallFan, texturePath);
        }
        FanBlockExporter.generateStandingFanItemModel(generator, standingFan, texturePath);
    }

    private static void generateStandingFanBlockState(class_4910 generator, class_2248 block, String texturePath) {
        class_2960 standingModelId = FanBlockExporter.createStandingFanModel(generator, block, texturePath);
        class_4926.class_4927 variants = class_4926.method_25783((class_2769)WCFanBlock.WATERLOGGED).method_25793((Comparable)Boolean.valueOf(false), FanBlockExporter.createVariant(standingModelId)).method_25793((Comparable)Boolean.valueOf(true), FanBlockExporter.createVariant(standingModelId));
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775((class_4926)variants));
    }

    private static void generateWallFanBlockState(class_4910 generator, class_2248 block, String texturePath) {
        class_2960 wallModelId = FanBlockExporter.createWallFanModel(generator, block, texturePath);
        class_4926.class_4928 variants = class_4926.method_25784((class_2769)WCWallFanBlock.FACING, (class_2769)WCWallFanBlock.WATERLOGGED).method_25797((Comparable)class_2350.field_11043, (Comparable)Boolean.valueOf(false), FanBlockExporter.createVariant(wallModelId)).method_25797((Comparable)class_2350.field_11043, (Comparable)Boolean.valueOf(true), FanBlockExporter.createVariant(wallModelId)).method_25797((Comparable)class_2350.field_11034, (Comparable)Boolean.valueOf(false), FanBlockExporter.createVariant(wallModelId, 90)).method_25797((Comparable)class_2350.field_11034, (Comparable)Boolean.valueOf(true), FanBlockExporter.createVariant(wallModelId, 90)).method_25797((Comparable)class_2350.field_11035, (Comparable)Boolean.valueOf(false), FanBlockExporter.createVariant(wallModelId, 180)).method_25797((Comparable)class_2350.field_11035, (Comparable)Boolean.valueOf(true), FanBlockExporter.createVariant(wallModelId, 180)).method_25797((Comparable)class_2350.field_11039, (Comparable)Boolean.valueOf(false), FanBlockExporter.createVariant(wallModelId, 270)).method_25797((Comparable)class_2350.field_11039, (Comparable)Boolean.valueOf(true), FanBlockExporter.createVariant(wallModelId, 270));
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775((class_4926)variants));
    }

    private static class_2960 createStandingFanModel(class_4910 generator, class_2248 block, String texturePath) {
        class_4944 textureMap = new class_4944().method_25868(ModTextureKey.FAN, FanBlockExporter.createBlockIdentifier(texturePath));
        class_2960 modelId = FanBlockExporter.createModelId(block);
        ModModels.FAN.method_25852(modelId, textureMap, generator.field_22831);
        return modelId;
    }

    private static class_2960 createWallFanModel(class_4910 generator, class_2248 block, String texturePath) {
        class_4944 textureMap = new class_4944().method_25868(ModTextureKey.FAN, FanBlockExporter.createBlockIdentifier(texturePath));
        class_2960 modelId = FanBlockExporter.createModelId(block);
        ModModels.WALL_FAN.method_25852(modelId, textureMap, generator.field_22831);
        return modelId;
    }

    public static void generateItemModels(class_4915 generator, class_2248 standingFan) {
        FanBlockExporter.generateItemModel(generator, standingFan);
    }

    private static void generateStandingFanItemModel(class_4910 generator, class_2248 block, String texturePath) {
        class_4944 textureMap = class_4944.method_25895((class_2960)FanBlockExporter.createBlockIdentifier(texturePath));
        class_2960 itemModelId = class_4941.method_25840((class_1792)block.method_8389());
        class_4943.field_22938.method_25852(itemModelId, textureMap, generator.field_22831);
    }

    private static void generateItemModel(class_4915 generator, class_2248 block) {
        String texturePath = FanBlockExporter.getTexturePath(block);
        class_4944 textureMap = class_4944.method_25895((class_2960)FanBlockExporter.createBlockIdentifier(texturePath));
        class_4943.field_22938.method_25852(class_4941.method_25840((class_1792)block.method_8389()), textureMap, generator.field_22844);
    }

    private static String getTexturePath(class_2248 block) {
        String blockName = block.method_9539().replace("block.westerosblocks.", "");
        return "fan/" + blockName.replace("_fan", "").replace("wall_", "");
    }

    public static void registerFanBlockFromDefinition(class_4910 generator, class_2248 standingFan, BlockDefinitionV2 definition) {
        if (definition.hasRandomTextures()) {
            FanBlockExporter.registerFanBlockWithRandomTextures(generator, standingFan, definition);
        } else {
            String texturePath = FanBlockExporter.getTextureFromDefinition(definition);
            FanBlockExporter.registerFanBlock(generator, standingFan, texturePath);
        }
    }

    private static void registerFanBlockWithRandomTextures(class_4910 generator, class_2248 standingFan, BlockDefinitionV2 definition) {
        String[] randomTexturePaths = (String[])definition.getRandomTextures().stream().map(variant -> variant.getTextures().get(0)).toArray(String[]::new);
        String primaryTexture = randomTexturePaths.length > 0 ? randomTexturePaths[0] : FanBlockExporter.getTextureFromDefinition(definition);
        FanBlockExporter.registerFanBlock(generator, standingFan, primaryTexture);
    }

    private static String getTextureFromDefinition(BlockDefinitionV2 definition) {
        if (definition.getTextures() != null && !definition.getTextures().isEmpty()) {
            return definition.getTextures().get(0);
        }
        return "fan/" + definition.getBlockName().replace("_fan", "");
    }
}

