/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.datagen.custom;

import com.westerosblocks.WesterosBlocks;
import com.westerosblocks.data.BlockDefinitionV2;
import com.westerosblocks.data.BlockStateRecordV2;
import com.westerosblocks.datagen.ModTextureKey;
import com.westerosblocks.datagen.custom.BaseBlockExporter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4918;
import net.minecraft.class_4922;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4942;
import net.minecraft.class_4944;
import net.minecraft.class_4945;

public class FenceBlockExporter
extends BaseBlockExporter {
    private static class_4942 createFencePostModel(boolean tinted, boolean overlay) {
        String tintPath = tinted ? "block/tinted/" : "block/untinted/";
        String overlayPath = overlay ? "fence_post_overlay" : "fence_post";
        String path = tintPath + overlayPath;
        if (overlay) {
            return new class_4942(Optional.of(WesterosBlocks.id(path)), Optional.empty(), new class_4945[]{class_4945.field_23014, class_4945.field_23015, class_4945.field_23018, ModTextureKey.BOTTOM_OVERLAY, ModTextureKey.TOP_OVERLAY, ModTextureKey.SIDE_OVERLAY, class_4945.field_23012});
        }
        return new class_4942(Optional.of(WesterosBlocks.id(path)), Optional.empty(), new class_4945[]{class_4945.field_23014, class_4945.field_23015, class_4945.field_23018, class_4945.field_23012});
    }

    private static class_4942 createFenceSideModel(boolean tinted, boolean overlay) {
        String tintPath = tinted ? "block/tinted/" : "block/untinted/";
        String overlayPath = overlay ? "fence_side_overlay" : "fence_side";
        String path = tintPath + overlayPath;
        if (overlay) {
            return new class_4942(Optional.of(WesterosBlocks.id(path)), Optional.empty(), new class_4945[]{class_4945.field_23014, class_4945.field_23015, class_4945.field_23018, ModTextureKey.BOTTOM_OVERLAY, ModTextureKey.TOP_OVERLAY, ModTextureKey.SIDE_OVERLAY, class_4945.field_23012});
        }
        return new class_4942(Optional.of(WesterosBlocks.id(path)), Optional.empty(), new class_4945[]{class_4945.field_23014, class_4945.field_23015, class_4945.field_23018, class_4945.field_23012});
    }

    private static class_4942 createFenceInventoryModel(boolean tinted, boolean overlay) {
        String tintPath = tinted ? "block/tinted/" : "block/untinted/";
        String overlayPath = overlay ? "fence_inventory_overlay" : "fence_inventory";
        String path = tintPath + overlayPath;
        if (overlay) {
            return new class_4942(Optional.of(WesterosBlocks.id(path)), Optional.empty(), new class_4945[]{class_4945.field_23014, class_4945.field_23015, class_4945.field_23018, ModTextureKey.BOTTOM_OVERLAY, ModTextureKey.TOP_OVERLAY, ModTextureKey.SIDE_OVERLAY, class_4945.field_23012});
        }
        return new class_4942(Optional.of(WesterosBlocks.id(path)), Optional.empty(), new class_4945[]{class_4945.field_23014, class_4945.field_23015, class_4945.field_23018, class_4945.field_23012});
    }

    private static class_4944 createFenceTextureMap(String[] textures, String[] overlayTextures) {
        class_4944 textureMap = new class_4944().method_25868(class_4945.field_23014, FenceBlockExporter.createBlockIdentifier(textures[0])).method_25868(class_4945.field_23015, FenceBlockExporter.createBlockIdentifier(textures[1])).method_25868(class_4945.field_23018, FenceBlockExporter.createBlockIdentifier(textures[2])).method_25868(class_4945.field_23012, FenceBlockExporter.createBlockIdentifier(textures[2]));
        if (overlayTextures != null) {
            textureMap.method_25868(ModTextureKey.BOTTOM_OVERLAY, FenceBlockExporter.createBlockIdentifier(overlayTextures[0]));
            textureMap.method_25868(ModTextureKey.TOP_OVERLAY, FenceBlockExporter.createBlockIdentifier(overlayTextures[1]));
            textureMap.method_25868(ModTextureKey.SIDE_OVERLAY, FenceBlockExporter.createBlockIdentifier(overlayTextures[2]));
        }
        return textureMap;
    }

    private static class_4922 createFenceVariants(class_2248 block, List<class_2960> postModelIds, List<class_2960> sideModelIds, List<Integer> weights) {
        class_4922 supplier = class_4922.method_25758((class_2248)block);
        for (int i = 0; i < postModelIds.size(); ++i) {
            class_4935 postVariant = class_4935.method_25824().method_25828(class_4936.field_22887, (Object)postModelIds.get(i));
            if (weights.get(i) > 1) {
                postVariant = postVariant.method_25828(class_4936.field_22889, (Object)weights.get(i));
            }
            supplier.method_25763(postVariant);
            FenceBlockExporter.addSideVariant(supplier, sideModelIds.get(i), weights.get(i), class_2350.field_11043);
            FenceBlockExporter.addSideVariant(supplier, sideModelIds.get(i), weights.get(i), class_2350.field_11034);
            FenceBlockExporter.addSideVariant(supplier, sideModelIds.get(i), weights.get(i), class_2350.field_11035);
            FenceBlockExporter.addSideVariant(supplier, sideModelIds.get(i), weights.get(i), class_2350.field_11039);
        }
        return supplier;
    }

    private static void addSideVariant(class_4922 supplier, class_2960 sideModelId, int weight, class_2350 direction) {
        class_4935 sideVariant = class_4935.method_25824().method_25828(class_4936.field_22887, (Object)sideModelId).method_25828(class_4936.field_22888, (Object)true);
        switch (direction) {
            case field_11034: {
                sideVariant = sideVariant.method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891);
                break;
            }
            case field_11035: {
                sideVariant = sideVariant.method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892);
                break;
            }
            case field_11039: {
                sideVariant = sideVariant.method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893);
            }
        }
        if (weight > 1) {
            sideVariant = sideVariant.method_25828(class_4936.field_22889, (Object)weight);
        }
        class_4918.class_4921 condition = switch (direction) {
            case class_2350.field_11043 -> class_4918.method_25744().method_25751((class_2769)class_2741.field_12489, (Comparable)Boolean.valueOf(true));
            case class_2350.field_11034 -> class_4918.method_25744().method_25751((class_2769)class_2741.field_12487, (Comparable)Boolean.valueOf(true));
            case class_2350.field_11035 -> class_4918.method_25744().method_25751((class_2769)class_2741.field_12540, (Comparable)Boolean.valueOf(true));
            case class_2350.field_11039 -> class_4918.method_25744().method_25751((class_2769)class_2741.field_12527, (Comparable)Boolean.valueOf(true));
            default -> null;
        };
        supplier.method_25760((class_4918)condition, sideVariant);
    }

    public static void registerFenceBlock(class_4910 generator, class_2248 block, boolean tinted, boolean overlay, String[] textures, String[] overlayTextures) {
        String[] expandedTextures = FenceBlockExporter.expandTextureArray(textures);
        String[] expandedOverlays = overlay && overlayTextures != null ? FenceBlockExporter.expandTextureArray(overlayTextures) : null;
        class_4944 textureMap = FenceBlockExporter.createFenceTextureMap(expandedTextures, expandedOverlays);
        class_2960 postModelId = FenceBlockExporter.createFencePostModel(tinted, overlay).method_25852(FenceBlockExporter.createNestedModelId(block, "post"), textureMap, generator.field_22831);
        class_2960 sideModelId = FenceBlockExporter.createFenceSideModel(tinted, overlay).method_25852(FenceBlockExporter.createNestedModelId(block, "side"), textureMap, generator.field_22831);
        class_4922 blockstate = FenceBlockExporter.createFenceVariants(block, List.of(postModelId), List.of(sideModelId), List.of(Integer.valueOf(1)));
        generator.field_22830.accept(blockstate);
        class_2960 itemModelId = class_2960.method_60655((String)"westerosblocks", (String)("item/" + FenceBlockExporter.getBlockName(block)));
        FenceBlockExporter.createFenceInventoryModel(tinted, overlay).method_25852(itemModelId, textureMap, generator.field_22831);
    }

    public static void registerFenceBlockWithRandomTextures(class_4910 generator, class_2248 block, boolean tinted, boolean overlay, List<BlockStateRecordV2.RandomTextureSet> textureSets, String[] overlayTextures) {
        String[] expandedOverlays;
        String[] expandedTextures;
        ArrayList<class_2960> postModelIds = new ArrayList<class_2960>();
        ArrayList<class_2960> sideModelIds = new ArrayList<class_2960>();
        ArrayList<Integer> weights = new ArrayList<Integer>();
        for (int i = 0; i < textureSets.size(); ++i) {
            BlockStateRecordV2.RandomTextureSet set = textureSets.get(i);
            expandedTextures = FenceBlockExporter.expandTextureArray(set.getTexturesAsArray());
            expandedOverlays = overlay && overlayTextures != null ? FenceBlockExporter.expandTextureArray(overlayTextures) : null;
            class_4944 textureMap = FenceBlockExporter.createFenceTextureMap(expandedTextures, expandedOverlays);
            class_2960 postModelId = FenceBlockExporter.createFencePostModel(tinted, overlay).method_25852(FenceBlockExporter.createNestedModelId(block, "post_v" + (i + 1)), textureMap, generator.field_22831);
            class_2960 sideModelId = FenceBlockExporter.createFenceSideModel(tinted, overlay).method_25852(FenceBlockExporter.createNestedModelId(block, "side_v" + (i + 1)), textureMap, generator.field_22831);
            postModelIds.add(postModelId);
            sideModelIds.add(sideModelId);
            weights.add(set.getWeight());
        }
        class_4922 blockstate = FenceBlockExporter.createFenceVariants(block, postModelIds, sideModelIds, weights);
        generator.field_22830.accept(blockstate);
        BlockStateRecordV2.RandomTextureSet firstSet = textureSets.get(0);
        expandedTextures = FenceBlockExporter.expandTextureArray(firstSet.getTexturesAsArray());
        expandedOverlays = overlay && overlayTextures != null ? FenceBlockExporter.expandTextureArray(overlayTextures) : null;
        class_4944 itemTextureMap = FenceBlockExporter.createFenceTextureMap(expandedTextures, expandedOverlays);
        class_2960 itemModelId = class_2960.method_60655((String)"westerosblocks", (String)("item/" + FenceBlockExporter.getBlockName(block)));
        FenceBlockExporter.createFenceInventoryModel(tinted, overlay).method_25852(itemModelId, itemTextureMap, generator.field_22831);
    }

    public static void registerCustomFenceBlock(class_4910 generator, class_2248 block, BlockDefinitionV2 definition) {
        boolean tinted = definition.isTinted() || definition.hasColorMult();
        List<BlockDefinitionV2.StateVariantV2> states = definition.getStates();
        if (states == null || states.isEmpty()) {
            throw new IllegalStateException("Block definition states should never be null/empty after doInit() for block: " + FenceBlockExporter.getBlockName(block));
        }
        BlockDefinitionV2.StateVariantV2 state = states.get(0);
        boolean overlay = state.hasOverlayTextures();
        int textureSetCount = state.getRandomTextureSetCount();
        if (textureSetCount > 0) {
            ArrayList<BlockStateRecordV2.RandomTextureSet> textureSets = new ArrayList<BlockStateRecordV2.RandomTextureSet>();
            for (int setIdx = 0; setIdx < textureSetCount; ++setIdx) {
                BlockStateRecordV2.RandomTextureSet set = state.getRandomTextureSet(setIdx);
                if (set == null) continue;
                textureSets.add(set);
            }
            String[] overlayArray = null;
            if (overlay && state.overlayTextures != null && !state.overlayTextures.isEmpty()) {
                overlayArray = state.overlayTextures.toArray(new String[0]);
            }
            FenceBlockExporter.registerFenceBlockWithRandomTextures(generator, block, tinted, overlay, textureSets, overlayArray);
        } else {
            FenceBlockExporter.registerFenceBlock(generator, block, tinted, overlay, new String[]{"missingno"}, null);
        }
    }

    private static String[] expandTextureArray(String[] textures) {
        if (textures.length == 1) {
            return new String[]{textures[0], textures[0], textures[0]};
        }
        if (textures.length == 3) {
            return textures;
        }
        throw new IllegalArgumentException("Fence blocks require 1 or 3 textures, got " + textures.length);
    }
}

