/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.datagen.custom;

import com.westerosblocks.WesterosBlocks;
import com.westerosblocks.data.BlockDefinitionV2;
import com.westerosblocks.data.BlockStateRecordV2;
import com.westerosblocks.datagen.ModTextureKey;
import com.westerosblocks.datagen.custom.BaseBlockExporter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4925;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4942;
import net.minecraft.class_4944;
import net.minecraft.class_4945;

public class FlowerPotBlockExporter
extends BaseBlockExporter {
    private static class_4942 createFlowerPotModel(boolean isEmpty, boolean tinted) {
        String tintPath = tinted ? "block/tinted/" : "block/untinted/";
        String potType = isEmpty ? "flower_pot" : "flower_pot_cross";
        String path = tintPath + potType;
        if (isEmpty) {
            return new class_4942(Optional.of(WesterosBlocks.id(path)), Optional.empty(), new class_4945[]{ModTextureKey.DIRT, ModTextureKey.FLOWERPOT, class_4945.field_23012});
        }
        return new class_4942(Optional.of(WesterosBlocks.id(path)), Optional.empty(), new class_4945[]{ModTextureKey.DIRT, ModTextureKey.FLOWERPOT, ModTextureKey.PLANT, class_4945.field_23012});
    }

    private static class_4944 createFlowerPotTextureMap(String[] textures, boolean isEmpty) {
        class_4944 textureMap = new class_4944();
        if (isEmpty) {
            textureMap.method_25868(ModTextureKey.DIRT, FlowerPotBlockExporter.createBlockIdentifier(textures[0]));
            textureMap.method_25868(ModTextureKey.FLOWERPOT, FlowerPotBlockExporter.createBlockIdentifier(textures[1]));
            textureMap.method_25868(class_4945.field_23012, FlowerPotBlockExporter.createBlockIdentifier(textures[1]));
        } else {
            textureMap.method_25868(ModTextureKey.DIRT, FlowerPotBlockExporter.createBlockIdentifier(textures[0]));
            textureMap.method_25868(ModTextureKey.FLOWERPOT, FlowerPotBlockExporter.createBlockIdentifier(textures[1]));
            textureMap.method_25868(ModTextureKey.PLANT, FlowerPotBlockExporter.createBlockIdentifier(textures[2]));
            textureMap.method_25868(class_4945.field_23012, FlowerPotBlockExporter.createBlockIdentifier(textures[1]));
        }
        return textureMap;
    }

    private static class_4925 createFlowerPotBlockstate(class_2248 block, List<class_2960> modelIds, boolean rotateRandom, List<Integer> weights) {
        ArrayList<class_4935> variants = new ArrayList<class_4935>();
        int rotationCount = rotateRandom ? 4 : 1;
        for (int i = 0; i < modelIds.size(); ++i) {
            for (int rotation = 0; rotation < rotationCount; ++rotation) {
                class_4935 variant = class_4935.method_25824().method_25828(class_4936.field_22887, (Object)modelIds.get(i));
                if (weights != null && weights.get(i) > 1) {
                    variant = variant.method_25828(class_4936.field_22889, (Object)weights.get(i));
                }
                if (rotation > 0) {
                    variant = variant.method_25828(class_4936.field_22886, (Object)class_4936.class_4937.valueOf((String)("R" + 90 * rotation)));
                }
                variants.add(variant);
            }
        }
        if (variants.size() == 1) {
            return class_4925.method_25770((class_2248)block, (class_4935)((class_4935)variants.get(0)));
        }
        return class_4925.method_25771((class_2248)block, (class_4935[])variants.toArray(new class_4935[0]));
    }

    public static void registerFlowerPotBlock(class_4910 generator, class_2248 block, boolean tinted, boolean rotateRandom, String[] textures) {
        boolean isEmpty = textures.length == 2;
        class_4944 textureMap = FlowerPotBlockExporter.createFlowerPotTextureMap(textures, isEmpty);
        class_2960 modelId = FlowerPotBlockExporter.createFlowerPotModel(isEmpty, tinted).method_25852(FlowerPotBlockExporter.createNestedModelId(block, "base"), textureMap, generator.field_22831);
        class_4925 blockstate = FlowerPotBlockExporter.createFlowerPotBlockstate(block, List.of(modelId), rotateRandom, List.of(Integer.valueOf(1)));
        generator.field_22830.accept(blockstate);
        generator.method_25623(block, modelId);
    }

    public static void registerFlowerPotBlockWithRandomTextures(class_4910 generator, class_2248 block, boolean tinted, boolean rotateRandom, List<BlockStateRecordV2.RandomTextureSet> textureSets) {
        ArrayList<class_2960> modelIds = new ArrayList<class_2960>();
        ArrayList<Integer> weights = new ArrayList<Integer>();
        for (int i = 0; i < textureSets.size(); ++i) {
            BlockStateRecordV2.RandomTextureSet set = textureSets.get(i);
            String[] textures = set.getTexturesAsArray();
            boolean isEmpty = textures.length == 2;
            class_4944 textureMap = FlowerPotBlockExporter.createFlowerPotTextureMap(textures, isEmpty);
            class_2960 modelId = FlowerPotBlockExporter.createFlowerPotModel(isEmpty, tinted).method_25852(FlowerPotBlockExporter.createNestedModelId(block, "base_v" + (i + 1)), textureMap, generator.field_22831);
            modelIds.add(modelId);
            weights.add(set.getWeight());
        }
        class_4925 blockstate = FlowerPotBlockExporter.createFlowerPotBlockstate(block, modelIds, rotateRandom, weights);
        generator.field_22830.accept(blockstate);
        generator.method_25623(block, (class_2960)modelIds.get(0));
    }

    public static void registerCustomFlowerPotBlock(class_4910 generator, class_2248 block, BlockDefinitionV2 definition) {
        ArrayList<BlockStateRecordV2.RandomTextureSet> textureSets;
        boolean tinted = definition.isTinted() || definition.hasColorMult();
        boolean rotateRandom = true;
        List<BlockDefinitionV2.StateVariantV2> states = definition.getStates();
        if (states == null || states.isEmpty()) {
            throw new IllegalStateException("Block definition states should never be null/empty after doInit() for block: " + FlowerPotBlockExporter.getBlockName(block));
        }
        BlockDefinitionV2.StateVariantV2 state = states.get(0);
        int textureSetCount = state.getRandomTextureSetCount();
        if (textureSetCount > 0) {
            textureSets = new ArrayList<BlockStateRecordV2.RandomTextureSet>();
            for (int setIdx = 0; setIdx < textureSetCount; ++setIdx) {
                BlockStateRecordV2.RandomTextureSet set = state.getRandomTextureSet(setIdx);
                if (set == null) continue;
                textureSets.add(set);
            }
        } else {
            throw new IllegalArgumentException("Flower pot blocks require textures: " + definition.getBlockName());
        }
        FlowerPotBlockExporter.registerFlowerPotBlockWithRandomTextures(generator, block, tinted, rotateRandom, textureSets);
    }
}

