/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.datagen.custom;

import com.westerosblocks.WesterosBlocks;
import com.westerosblocks.block.custom.WCHalfDoorBlock;
import com.westerosblocks.data.BlockDefinitionV2;
import com.westerosblocks.datagen.ModModels;
import com.westerosblocks.datagen.custom.BaseBlockExporter;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2750;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4942;
import net.minecraft.class_4944;
import net.minecraft.class_4945;

public class HalfDoorBlockExporter
extends BaseBlockExporter {
    public static void registerHalfDoorBlock(class_4910 generator, class_2248 block, String texturePath) {
        class_2960 leftModelId = HalfDoorBlockExporter.createHalfDoorModel(generator, block, texturePath, "left", ModModels.HALF_DOOR_LEFT);
        class_2960 rightModelId = HalfDoorBlockExporter.createHalfDoorModel(generator, block, texturePath, "right", ModModels.HALF_DOOR_RIGHT);
        class_2960 leftOpenModelId = HalfDoorBlockExporter.createHalfDoorModel(generator, block, texturePath, "left_open", ModModels.HALF_DOOR_LEFT_OPEN);
        class_2960 rightOpenModelId = HalfDoorBlockExporter.createHalfDoorModel(generator, block, texturePath, "right_open", ModModels.HALF_DOOR_RIGHT_OPEN);
        class_4926 variants = HalfDoorBlockExporter.createHalfDoorVariants(leftModelId, rightModelId, leftOpenModelId, rightOpenModelId);
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775(variants));
        HalfDoorBlockExporter.registerSimpleItemModel(generator, block, HalfDoorBlockExporter.createBlockIdentifier(texturePath));
    }

    public static void registerCustomHalfDoorBlock(class_4910 generator, class_2248 block, BlockDefinitionV2 definition) {
        List<String> textureList = definition.getTextures();
        if (textureList != null && !textureList.isEmpty()) {
            String texturePath = textureList.get(0);
            HalfDoorBlockExporter.registerHalfDoorBlock(generator, block, texturePath);
        } else {
            HalfDoorBlockExporter.registerHalfDoorBlock(generator, block, "missingno");
        }
    }

    private static class_4944 createHalfDoorTextureMap(String texturePath) {
        return new class_4944().method_25868(class_4945.field_23014, HalfDoorBlockExporter.createBlockIdentifier(texturePath));
    }

    private static class_4926 createHalfDoorVariants(class_2960 leftModelId, class_2960 rightModelId, class_2960 leftOpenModelId, class_2960 rightOpenModelId) {
        return class_4926.method_25785((class_2769)WCHalfDoorBlock.FACING, WCHalfDoorBlock.HINGE, (class_2769)WCHalfDoorBlock.OPEN).method_25806((Comparable)class_2350.field_11034, (Comparable)class_2750.field_12588, (Comparable)Boolean.valueOf(false), HalfDoorBlockExporter.createVariant(leftModelId)).method_25806((Comparable)class_2350.field_11034, (Comparable)class_2750.field_12588, (Comparable)Boolean.valueOf(true), HalfDoorBlockExporter.createVariant(leftOpenModelId, 90)).method_25806((Comparable)class_2350.field_11034, (Comparable)class_2750.field_12586, (Comparable)Boolean.valueOf(false), HalfDoorBlockExporter.createVariant(rightModelId)).method_25806((Comparable)class_2350.field_11034, (Comparable)class_2750.field_12586, (Comparable)Boolean.valueOf(true), HalfDoorBlockExporter.createVariant(rightOpenModelId, 270)).method_25806((Comparable)class_2350.field_11035, (Comparable)class_2750.field_12588, (Comparable)Boolean.valueOf(false), HalfDoorBlockExporter.createVariant(leftModelId, 90)).method_25806((Comparable)class_2350.field_11035, (Comparable)class_2750.field_12588, (Comparable)Boolean.valueOf(true), HalfDoorBlockExporter.createVariant(leftOpenModelId, 180)).method_25806((Comparable)class_2350.field_11035, (Comparable)class_2750.field_12586, (Comparable)Boolean.valueOf(false), HalfDoorBlockExporter.createVariant(rightModelId, 90)).method_25806((Comparable)class_2350.field_11035, (Comparable)class_2750.field_12586, (Comparable)Boolean.valueOf(true), HalfDoorBlockExporter.createVariant(rightOpenModelId, 0)).method_25806((Comparable)class_2350.field_11039, (Comparable)class_2750.field_12588, (Comparable)Boolean.valueOf(false), HalfDoorBlockExporter.createVariant(leftModelId, 180)).method_25806((Comparable)class_2350.field_11039, (Comparable)class_2750.field_12588, (Comparable)Boolean.valueOf(true), HalfDoorBlockExporter.createVariant(leftOpenModelId, 270)).method_25806((Comparable)class_2350.field_11039, (Comparable)class_2750.field_12586, (Comparable)Boolean.valueOf(false), HalfDoorBlockExporter.createVariant(rightModelId, 180)).method_25806((Comparable)class_2350.field_11039, (Comparable)class_2750.field_12586, (Comparable)Boolean.valueOf(true), HalfDoorBlockExporter.createVariant(rightOpenModelId, 90)).method_25806((Comparable)class_2350.field_11043, (Comparable)class_2750.field_12588, (Comparable)Boolean.valueOf(false), HalfDoorBlockExporter.createVariant(leftModelId, 270)).method_25806((Comparable)class_2350.field_11043, (Comparable)class_2750.field_12588, (Comparable)Boolean.valueOf(true), HalfDoorBlockExporter.createVariant(leftOpenModelId, 0)).method_25806((Comparable)class_2350.field_11043, (Comparable)class_2750.field_12586, (Comparable)Boolean.valueOf(false), HalfDoorBlockExporter.createVariant(rightModelId, 270)).method_25806((Comparable)class_2350.field_11043, (Comparable)class_2750.field_12586, (Comparable)Boolean.valueOf(true), HalfDoorBlockExporter.createVariant(rightOpenModelId, 180));
    }

    private static class_2960 createHalfDoorModel(class_4910 generator, class_2248 block, String texturePath, String variant, class_4942 model) {
        String blockName = HalfDoorBlockExporter.getBlockName(block);
        class_2960 modelId = WesterosBlocks.id("block/" + blockName + "/" + blockName + "_" + variant);
        class_4944 textureMap = HalfDoorBlockExporter.createHalfDoorTextureMap(texturePath);
        String parentModelPath = "block/untinted/" + HalfDoorBlockExporter.getParentModelName(variant);
        class_4942 doorModel = new class_4942(Optional.of(WesterosBlocks.id(parentModelPath)), Optional.empty(), new class_4945[]{class_4945.field_23014});
        doorModel.method_25852(modelId, textureMap, generator.field_22831);
        return modelId;
    }

    private static String getParentModelName(String variant) {
        return switch (variant) {
            case "left" -> "half_door_left";
            case "right" -> "half_door_right";
            case "left_open" -> "half_door_left_open";
            case "right_open" -> "half_door_right_open";
            default -> throw new IllegalArgumentException("Unknown half door variant: " + variant);
        };
    }
}

