/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.datagen.custom;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.westerosblocks.WesterosBlocks;
import com.westerosblocks.block.custom.WCLayerBlock;
import com.westerosblocks.data.BlockDefinitionV2;
import com.westerosblocks.data.BlockStateRecordV2;
import com.westerosblocks.datagen.custom.BaseBlockExporter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4917;

public class LayerBlockExporter
extends BaseBlockExporter {
    public static void registerCustomLayerBlock(class_4910 generator, class_2248 block, BlockDefinitionV2 definition) {
        if (!(block instanceof WCLayerBlock)) {
            throw new IllegalArgumentException("Block must be a WCLayerBlock instance");
        }
        WCLayerBlock layerBlock = (WCLayerBlock)block;
        List<BlockDefinitionV2.StateVariantV2> states = definition.getStates();
        if (states == null || states.isEmpty()) {
            throw new IllegalStateException("Block definition states should never be null/empty after doInit() for block: " + LayerBlockExporter.getBlockName(block));
        }
        BlockDefinitionV2.StateVariantV2 state = states.getFirst();
        LayerBlockExporter.generateBlockState(generator, block, definition, state, layerBlock);
        if (!definition.hasCustomModel()) {
            for (int layer = 1; layer <= layerBlock.layerCount; ++layer) {
                for (int setIdx = 0; setIdx < state.getRandomTextureSetCount(); ++setIdx) {
                    LayerBlockExporter.generateLayerModel(generator, block, definition, state, layer, setIdx, layerBlock);
                }
            }
        }
        String firstName = "layer1";
        class_2960 itemModelId = definition.hasCustomModel() ? LayerBlockExporter.createCustomModelId(block, firstName + "_v1") : LayerBlockExporter.createGeneratedModelId(block, LayerBlockExporter.getModelName(firstName, 0));
        LayerBlockExporter.registerParentedItemModel(generator, block, itemModelId);
    }

    private static void generateBlockState(class_4910 generator, final class_2248 block, BlockDefinitionV2 definition, final BlockDefinitionV2.StateVariantV2 state, final WCLayerBlock layerBlock) {
        final boolean isCustomModel = definition.hasCustomModel();
        generator.field_22830.accept(new class_4917(){

            public class_2248 method_25743() {
                return block;
            }

            public JsonElement get() {
                JsonObject json = new JsonObject();
                JsonObject variants = new JsonObject();
                for (int layer = 1; layer <= layerBlock.layerCount; ++layer) {
                    String variantKey = "layers=" + layer;
                    if (isCustomModel) {
                        class_2960 modelId = LayerBlockExporter.createCustomModelId(block, "layer" + layer + "_v1");
                        JsonObject variant = new JsonObject();
                        variant.addProperty("model", modelId.toString());
                        variants.add(variantKey, (JsonElement)variant);
                        continue;
                    }
                    ArrayList<JsonObject> layerVariants = new ArrayList<JsonObject>();
                    for (int setIdx = 0; setIdx < state.getRandomTextureSetCount(); ++setIdx) {
                        BlockStateRecordV2.RandomTextureSet set = state.getRandomTextureSet(setIdx);
                        if (set == null || set.getTextureCount() == 0) continue;
                        class_2960 modelId = LayerBlockExporter.createGeneratedModelId(block, LayerBlockExporter.getModelName("layer" + layer, setIdx));
                        JsonObject variant = new JsonObject();
                        variant.addProperty("model", modelId.toString());
                        if (set.getWeight() > 1) {
                            variant.addProperty("weight", (Number)set.getWeight());
                        }
                        layerVariants.add(variant);
                    }
                    if (layerVariants.size() == 1) {
                        variants.add(variantKey, (JsonElement)layerVariants.getFirst());
                        continue;
                    }
                    if (layerVariants.size() <= 1) continue;
                    JsonArray variantArray = new JsonArray();
                    for (JsonObject v : layerVariants) {
                        variantArray.add((JsonElement)v);
                    }
                    variants.add(variantKey, (JsonElement)variantArray);
                }
                json.add("variants", (JsonElement)variants);
                return json;
            }
        });
    }

    private static void generateLayerModel(class_4910 generator, class_2248 block, BlockDefinitionV2 definition, BlockDefinitionV2.StateVariantV2 state, int layer, int setIdx, WCLayerBlock layerBlock) {
        BlockStateRecordV2.RandomTextureSet set = state.getRandomTextureSet(setIdx);
        if (set == null || set.getTextureCount() == 0) {
            return;
        }
        String variantName = LayerBlockExporter.getModelName("layer" + layer, setIdx);
        class_2960 modelId = LayerBlockExporter.createGeneratedModelId(block, variantName);
        boolean isTinted = definition.isTinted();
        JsonObject modelJson = new JsonObject();
        modelJson.addProperty("parent", "minecraft:block/thin_block");
        JsonObject texturesJson = new JsonObject();
        int cnt = Math.max(6, set.getTextureCount());
        for (int j = 0; j < cnt; ++j) {
            String texture = j < set.getTextureCount() ? set.getTextureByIndex(j) : set.getTextureByIndex(set.getTextureCount() - 1);
            texturesJson.addProperty("txt" + j, "westerosblocks:block/" + texture);
        }
        texturesJson.addProperty("particle", "westerosblocks:block/" + set.getTextureByIndex(0));
        modelJson.add("textures", (JsonElement)texturesJson);
        float ymax = 16.0f / (float)layerBlock.layerCount * (float)layer;
        JsonArray elements = new JsonArray();
        JsonObject element = new JsonObject();
        JsonArray from = new JsonArray();
        from.add((Number)0);
        from.add((Number)0);
        from.add((Number)0);
        element.add("from", (JsonElement)from);
        JsonArray to = new JsonArray();
        to.add((Number)16);
        to.add((Number)Float.valueOf(ymax));
        to.add((Number)16);
        element.add("to", (JsonElement)to);
        JsonObject faces = new JsonObject();
        LayerBlockExporter.addLayerFace(faces, "down", 0.0f, 0.0f, 16.0f, 16.0f, "#txt0", "down", isTinted);
        String upCullface = layer >= layerBlock.layerCount ? "up" : null;
        LayerBlockExporter.addLayerFace(faces, "up", 0.0f, 0.0f, 16.0f, 16.0f, "#txt1", upCullface, isTinted);
        LayerBlockExporter.addLayerFace(faces, "north", 0.0f, 16.0f - ymax, 16.0f, 16.0f, "#txt2", "north", isTinted);
        LayerBlockExporter.addLayerFace(faces, "south", 0.0f, 16.0f - ymax, 16.0f, 16.0f, "#txt3", "south", isTinted);
        LayerBlockExporter.addLayerFace(faces, "west", 0.0f, 16.0f - ymax, 16.0f, 16.0f, "#txt4", "west", isTinted);
        LayerBlockExporter.addLayerFace(faces, "east", 0.0f, 16.0f - ymax, 16.0f, 16.0f, "#txt5", "east", isTinted);
        element.add("faces", (JsonElement)faces);
        elements.add((JsonElement)element);
        modelJson.add("elements", (JsonElement)elements);
        generator.field_22831.accept(modelId, () -> modelJson);
    }

    private static void addLayerFace(JsonObject faces, String direction, float u0, float v0, float u1, float v1, String texture, String cullface, boolean tinted) {
        JsonObject face = new JsonObject();
        JsonArray uv = new JsonArray();
        uv.add((Number)Float.valueOf(u0));
        uv.add((Number)Float.valueOf(v0));
        uv.add((Number)Float.valueOf(u1));
        uv.add((Number)Float.valueOf(v1));
        face.add("uv", (JsonElement)uv);
        face.addProperty("texture", texture);
        if (cullface != null) {
            face.addProperty("cullface", cullface);
        }
        if (tinted) {
            face.addProperty("tintindex", (Number)0);
        }
        faces.add(direction, (JsonElement)face);
    }

    private static class_2960 createCustomModelId(class_2248 block, String variant) {
        String blockName = LayerBlockExporter.getBlockName(block);
        return WesterosBlocks.id("block/custom/" + blockName + "/" + variant);
    }

    private static class_2960 createGeneratedModelId(class_2248 block, String variant) {
        String blockName = LayerBlockExporter.getBlockName(block);
        return WesterosBlocks.id("block/" + blockName + "/" + variant);
    }

    private static String getModelName(String baseName, int setIdx) {
        return baseName + "_v" + (setIdx + 1);
    }
}

