/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.datagen.custom;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.westerosblocks.WesterosBlocks;
import com.westerosblocks.data.BlockDefinitionV2;
import com.westerosblocks.data.BlockStateRecordV2;
import com.westerosblocks.datagen.custom.BaseBlockExporter;
import java.util.List;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4917;

public class LogBlockExporter
extends BaseBlockExporter {
    public static void registerCustomLogBlock(class_4910 generator, class_2248 block, BlockDefinitionV2 definition) {
        boolean tinted = definition.isTinted() || definition.hasColorMult();
        List<BlockDefinitionV2.StateVariantV2> states = definition.getStates();
        if (states == null || states.isEmpty()) {
            throw new IllegalStateException("Log block definition states should never be null/empty for block: " + LogBlockExporter.getBlockName(block));
        }
        BlockDefinitionV2.StateVariantV2 state = states.get(0);
        LogBlockExporter.generateBlockState(generator, block, state);
        for (int setIdx = 0; setIdx < state.getRandomTextureSetCount(); ++setIdx) {
            LogBlockExporter.generateLogModels(generator, block, state, setIdx, tinted);
        }
        class_2960 itemModelId = LogBlockExporter.createGeneratedModelId(block, LogBlockExporter.getModelName("y", 0));
        LogBlockExporter.registerParentedItemModel(generator, block, itemModelId);
    }

    private static void generateBlockState(class_4910 generator, final class_2248 block, final BlockDefinitionV2.StateVariantV2 state) {
        final String[] axisStates = new String[]{"axis=x", "axis=y", "axis=z"};
        final int[] xRotations = new int[]{90, 0, 90};
        final int[] yRotations = new int[]{90, 0, 0};
        final String[] modelNames = new String[]{"x", "y", "z"};
        generator.field_22830.accept(new class_4917(){

            public class_2248 method_25743() {
                return block;
            }

            public JsonElement get() {
                JsonObject json = new JsonObject();
                JsonObject variants = new JsonObject();
                for (int i = 0; i < axisStates.length; ++i) {
                    String axisState = axisStates[i];
                    String modelName = modelNames[i];
                    int xRot = xRotations[i];
                    int yRot = yRotations[i];
                    for (int setIdx = 0; setIdx < state.getRandomTextureSetCount(); ++setIdx) {
                        BlockStateRecordV2.RandomTextureSet set = state.getRandomTextureSet(setIdx);
                        if (set == null || set.getTextureCount() == 0) continue;
                        class_2960 modelId = LogBlockExporter.createGeneratedModelId(block, LogBlockExporter.getModelName(modelName, setIdx));
                        JsonObject variant = new JsonObject();
                        variant.addProperty("model", modelId.toString());
                        if (xRot > 0) {
                            variant.addProperty("x", (Number)xRot);
                        }
                        if (yRot > 0) {
                            variant.addProperty("y", (Number)yRot);
                        }
                        if (set.getWeight() > 1) {
                            variant.addProperty("weight", (Number)set.getWeight());
                        }
                        LogBlockExporter.addVariantToKey(variants, axisState, variant);
                    }
                }
                json.add("variants", (JsonElement)variants);
                return json;
            }
        });
    }

    private static void generateLogModels(class_4910 generator, class_2248 block, BlockDefinitionV2.StateVariantV2 state, int setIdx, boolean tinted) {
        BlockStateRecordV2.RandomTextureSet set = state.getRandomTextureSet(setIdx);
        if (set == null || set.getTextureCount() == 0) {
            return;
        }
        String down = set.getTextureByIndex(0);
        String up = set.getTextureByIndex(1);
        String north = set.getTextureByIndex(2);
        String south = set.getTextureByIndex(3);
        String west = set.getTextureByIndex(4);
        String east = set.getTextureByIndex(5);
        String particle = north;
        String parentVertical = tinted ? "westerosblocks:block/tinted/cube_log" : "westerosblocks:block/untinted/cube_log";
        String parentHorizontal = tinted ? "westerosblocks:block/tinted/cube_log_horizontal" : "westerosblocks:block/untinted/cube_log_horizontal";
        LogBlockExporter.generateLogModel(generator, block, "y", setIdx, parentVertical, down, up, north, south, west, east, particle);
        LogBlockExporter.generateLogModel(generator, block, "x", setIdx, parentHorizontal, down, up, north, south, west, east, particle);
        LogBlockExporter.generateLogModel(generator, block, "z", setIdx, parentHorizontal, down, up, north, south, west, east, particle);
    }

    private static void generateLogModel(class_4910 generator, class_2248 block, String axis, int setIdx, String parent, String down, String up, String north, String south, String west, String east, String particle) {
        String modelName = LogBlockExporter.getModelName(axis, setIdx);
        class_2960 modelId = LogBlockExporter.createGeneratedModelId(block, modelName);
        JsonObject modelJson = new JsonObject();
        modelJson.addProperty("parent", parent);
        JsonObject texturesJson = new JsonObject();
        texturesJson.addProperty("down", "westerosblocks:block/" + down);
        texturesJson.addProperty("up", "westerosblocks:block/" + up);
        texturesJson.addProperty("north", "westerosblocks:block/" + north);
        texturesJson.addProperty("south", "westerosblocks:block/" + south);
        texturesJson.addProperty("west", "westerosblocks:block/" + west);
        texturesJson.addProperty("east", "westerosblocks:block/" + east);
        texturesJson.addProperty("particle", "westerosblocks:block/" + particle);
        modelJson.add("textures", (JsonElement)texturesJson);
        generator.field_22831.accept(modelId, () -> modelJson);
    }

    private static void addVariantToKey(JsonObject variants, String key, JsonObject variant) {
        if (variants.has(key)) {
            JsonElement existing = variants.get(key);
            if (existing.isJsonArray()) {
                existing.getAsJsonArray().add((JsonElement)variant);
            } else {
                JsonArray array = new JsonArray();
                array.add(existing);
                array.add((JsonElement)variant);
                variants.add(key, (JsonElement)array);
            }
        } else {
            variants.add(key, (JsonElement)variant);
        }
    }

    private static class_2960 createGeneratedModelId(class_2248 block, String variant) {
        String blockName = LogBlockExporter.getBlockName(block);
        return WesterosBlocks.id("block/" + blockName + "/" + variant);
    }

    private static String getModelName(String axis, int setIdx) {
        return axis + "_v" + (setIdx + 1);
    }
}

