/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.datagen.custom;

import com.westerosblocks.WesterosBlocks;
import com.westerosblocks.block.custom.WCPaneBlock;
import com.westerosblocks.data.BlockDefinitionV2;
import com.westerosblocks.data.BlockStateRecordV2;
import com.westerosblocks.datagen.ModModels;
import com.westerosblocks.datagen.ModTextureKey;
import com.westerosblocks.datagen.custom.BaseBlockExporter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4918;
import net.minecraft.class_4922;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4942;
import net.minecraft.class_4944;
import net.minecraft.class_4945;

public class PaneBlockExporter
extends BaseBlockExporter {
    private static class_4942 createPaneSideModel(boolean isBars) {
        String path = isBars ? "block/untinted/bars_side" : "block/untinted/ctm_pane_side";
        return new class_4942(Optional.of(WesterosBlocks.id(path)), Optional.empty(), new class_4945[]{class_4945.field_23018, ModTextureKey.CAP});
    }

    public static void registerPaneBlockWithVariants(class_4910 generator, class_2248 block, List<String[]> textureVariants, List<Integer> weights) {
        WCPaneBlock paneBlock = (WCPaneBlock)block;
        boolean isBars = paneBlock.isBarsModel();
        ArrayList<class_2960> postModelIds = new ArrayList<class_2960>();
        ArrayList<class_2960> sideModelIds = new ArrayList<class_2960>();
        ArrayList<class_2960> nosideModelIds = new ArrayList<class_2960>();
        for (int i = 0; i < textureVariants.size(); ++i) {
            String[] textures = textureVariants.get(i);
            String sideTexture = textures[0];
            String capTexture = textures.length > 1 ? textures[1] : textures[0];
            class_4944 paneTextureMap = new class_4944().method_25868(class_4945.field_23018, PaneBlockExporter.createBlockIdentifier(sideTexture)).method_25868(ModTextureKey.CAP, PaneBlockExporter.createBlockIdentifier(capTexture));
            String suffix = "_v" + (i + 1);
            if (!isBars) {
                class_2960 postModelId = ModModels.PANE_POST.method_25852(PaneBlockExporter.createNestedModelId(block, "post" + suffix), paneTextureMap, generator.field_22831);
                postModelIds.add(postModelId);
                class_2960 nosideModelId = ModModels.PANE_NOSIDE.method_25852(PaneBlockExporter.createNestedModelId(block, "noside" + suffix), paneTextureMap, generator.field_22831);
                nosideModelIds.add(nosideModelId);
            }
            class_2960 sideModelId = PaneBlockExporter.createPaneSideModel(isBars).method_25852(PaneBlockExporter.createNestedModelId(block, "side" + suffix), paneTextureMap, generator.field_22831);
            sideModelIds.add(sideModelId);
        }
        class_4922 supplier = PaneBlockExporter.createPaneBlockState(block, paneBlock, postModelIds, sideModelIds, nosideModelIds, weights);
        generator.field_22830.accept(supplier);
        String[] firstTextures = textureVariants.get(0);
        PaneBlockExporter.registerSimpleItemModel(generator, block, PaneBlockExporter.createBlockIdentifier(firstTextures[0]));
    }

    private static class_4922 createPaneBlockState(class_2248 block, WCPaneBlock paneBlock, List<class_2960> postModelIds, List<class_2960> sideModelIds, List<class_2960> nosideModelIds, List<Integer> weights) {
        class_4922 supplier = class_4922.method_25758((class_2248)block);
        boolean isBars = paneBlock.isBarsModel();
        for (int i = 0; i < sideModelIds.size(); ++i) {
            int weight = weights.get(i);
            if (!isBars) {
                class_4935 postVariant = class_4935.method_25824().method_25828(class_4936.field_22887, (Object)postModelIds.get(i));
                if (weight > 1) {
                    postVariant = postVariant.method_25828(class_4936.field_22889, (Object)weight);
                }
                supplier = supplier.method_25763(postVariant);
            }
            PaneBlockExporter.addPaneSideVariant(supplier, sideModelIds.get(i), weight, class_2350.field_11043, isBars);
            PaneBlockExporter.addPaneSideVariant(supplier, sideModelIds.get(i), weight, class_2350.field_11034, isBars);
            PaneBlockExporter.addPaneSideVariant(supplier, sideModelIds.get(i), weight, class_2350.field_11035, isBars);
            PaneBlockExporter.addPaneSideVariant(supplier, sideModelIds.get(i), weight, class_2350.field_11039, isBars);
            if (isBars) continue;
            PaneBlockExporter.addPaneNosideVariant(supplier, nosideModelIds.get(i), weight, class_2350.field_11043);
            PaneBlockExporter.addPaneNosideVariant(supplier, nosideModelIds.get(i), weight, class_2350.field_11034);
            PaneBlockExporter.addPaneNosideVariant(supplier, nosideModelIds.get(i), weight, class_2350.field_11035);
            PaneBlockExporter.addPaneNosideVariant(supplier, nosideModelIds.get(i), weight, class_2350.field_11039);
        }
        return supplier;
    }

    private static void addPaneSideVariant(class_4922 supplier, class_2960 sideModelId, int weight, class_2350 direction, boolean isBars) {
        class_4918.class_4921 condition;
        class_4935 sideVariant = class_4935.method_25824().method_25828(class_4936.field_22887, (Object)sideModelId).method_25828(class_4936.field_22888, (Object)true);
        switch (direction) {
            case field_11034: {
                sideVariant = sideVariant.method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891);
                break;
            }
            case field_11035: {
                sideVariant = sideVariant.method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892);
                break;
            }
            case field_11039: {
                sideVariant = sideVariant.method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893);
            }
        }
        if (weight > 1) {
            sideVariant = sideVariant.method_25828(class_4936.field_22889, (Object)weight);
        }
        if (isBars) {
            class_4918.class_4921 directionTrue = switch (direction) {
                case class_2350.field_11043 -> class_4918.method_25744().method_25751((class_2769)class_2741.field_12489, (Comparable)Boolean.valueOf(true));
                case class_2350.field_11034 -> class_4918.method_25744().method_25751((class_2769)class_2741.field_12487, (Comparable)Boolean.valueOf(true));
                case class_2350.field_11035 -> class_4918.method_25744().method_25751((class_2769)class_2741.field_12540, (Comparable)Boolean.valueOf(true));
                case class_2350.field_11039 -> class_4918.method_25744().method_25751((class_2769)class_2741.field_12527, (Comparable)Boolean.valueOf(true));
                default -> throw new IllegalArgumentException("Invalid direction: " + String.valueOf(direction));
            };
            class_4918.class_4921 allFalse = class_4918.method_25744().method_25751((class_2769)class_2741.field_12489, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)class_2741.field_12487, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)class_2741.field_12540, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)class_2741.field_12527, (Comparable)Boolean.valueOf(false));
            condition = class_4918.method_25746((class_4918[])new class_4918[]{directionTrue, allFalse});
        } else {
            condition = switch (direction) {
                case class_2350.field_11043 -> class_4918.method_25744().method_25751((class_2769)class_2741.field_12489, (Comparable)Boolean.valueOf(true));
                case class_2350.field_11034 -> class_4918.method_25744().method_25751((class_2769)class_2741.field_12487, (Comparable)Boolean.valueOf(true));
                case class_2350.field_11035 -> class_4918.method_25744().method_25751((class_2769)class_2741.field_12540, (Comparable)Boolean.valueOf(true));
                case class_2350.field_11039 -> class_4918.method_25744().method_25751((class_2769)class_2741.field_12527, (Comparable)Boolean.valueOf(true));
                default -> throw new IllegalArgumentException("Invalid direction: " + String.valueOf(direction));
            };
        }
        supplier.method_25760((class_4918)condition, sideVariant);
    }

    private static void addPaneNosideVariant(class_4922 supplier, class_2960 nosideModelId, int weight, class_2350 direction) {
        class_4935 nosideVariant = class_4935.method_25824().method_25828(class_4936.field_22887, (Object)nosideModelId).method_25828(class_4936.field_22888, (Object)true);
        switch (direction) {
            case field_11034: {
                nosideVariant = nosideVariant.method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891);
                break;
            }
            case field_11035: {
                nosideVariant = nosideVariant.method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892);
                break;
            }
            case field_11039: {
                nosideVariant = nosideVariant.method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893);
            }
        }
        if (weight > 1) {
            nosideVariant = nosideVariant.method_25828(class_4936.field_22889, (Object)weight);
        }
        class_4918.class_4921 condition = switch (direction) {
            case class_2350.field_11043 -> class_4918.method_25744().method_25751((class_2769)class_2741.field_12489, (Comparable)Boolean.valueOf(false));
            case class_2350.field_11034 -> class_4918.method_25744().method_25751((class_2769)class_2741.field_12487, (Comparable)Boolean.valueOf(false));
            case class_2350.field_11035 -> class_4918.method_25744().method_25751((class_2769)class_2741.field_12540, (Comparable)Boolean.valueOf(false));
            case class_2350.field_11039 -> class_4918.method_25744().method_25751((class_2769)class_2741.field_12527, (Comparable)Boolean.valueOf(false));
            default -> throw new IllegalArgumentException("Invalid direction: " + String.valueOf(direction));
        };
        supplier.method_25760((class_4918)condition, nosideVariant);
    }

    public static void registerCustomPaneBlock(class_4910 generator, class_2248 block, BlockDefinitionV2 definition) {
        List<BlockDefinitionV2.StateVariantV2> states = definition.getStates();
        if (states == null || states.isEmpty()) {
            throw new IllegalStateException("Block definition states should never be null/empty after doInit() for block: " + PaneBlockExporter.getBlockName(block));
        }
        BlockDefinitionV2.StateVariantV2 state = states.get(0);
        ArrayList<String[]> textureVariants = new ArrayList<String[]>();
        ArrayList<Integer> weights = new ArrayList<Integer>();
        int textureSetCount = state.getRandomTextureSetCount();
        if (textureSetCount > 0) {
            for (int i = 0; i < textureSetCount; ++i) {
                BlockStateRecordV2.RandomTextureSet set = state.getRandomTextureSet(i);
                if (set != null && set.getTextureCount() > 0) {
                    String[] textures;
                    textures = new String[]{set.getTextureByIndex(0), set.getTextureCount() > 1 ? set.getTextureByIndex(1) : textures[0]};
                    textureVariants.add(textures);
                    weights.add(set.getWeight());
                    continue;
                }
                textureVariants.add(new String[]{"missingno", "missingno"});
                weights.add(1);
            }
        } else {
            textureVariants.add(new String[]{"missingno", "missingno"});
            weights.add(1);
        }
        PaneBlockExporter.registerPaneBlockWithVariants(generator, block, textureVariants, weights);
    }
}

