/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.datagen.custom;

import com.westerosblocks.WesterosBlocks;
import com.westerosblocks.data.BlockDefinitionV2;
import com.westerosblocks.data.BlockStateRecordV2;
import com.westerosblocks.datagen.ModModels;
import com.westerosblocks.datagen.custom.BaseBlockExporter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2443;
import net.minecraft.class_2768;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4941;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;

public class RailBlockExporter
extends BaseBlockExporter {
    private static final String[] SHAPES = new String[]{"shape=north_south", "shape=east_west", "shape=ascending_east", "shape=ascending_west", "shape=ascending_north", "shape=ascending_south", "shape=south_east", "shape=south_west", "shape=north_west", "shape=north_east"};
    private static final String[] MODEL_TYPES = new String[]{"flat", "flat", "raised_ne", "raised_sw", "raised_ne", "raised_sw", "curved", "curved", "curved", "curved"};
    private static final int[] ROTATIONS = new int[]{0, 90, 90, 90, 0, 0, 0, 90, 180, 270};

    public static void registerRailBlock(class_4910 generator, class_2248 block, String texturePath) {
        RailBlockExporter.registerRailBlock(generator, block, new String[]{texturePath});
    }

    public static void registerRailBlock(class_4910 generator, class_2248 block, String[] texturePaths) {
        RailBlockExporter.validateTexturePaths(texturePaths, 1);
        String flatTexture = texturePaths[0];
        String curvedTexture = texturePaths.length > 1 ? texturePaths[1] : texturePaths[0];
        RailBlockExporter.generateRailBlockState(generator, block, flatTexture, curvedTexture);
        RailBlockExporter.generateRailModels(generator, block, flatTexture, curvedTexture);
        class_2960 textureId = RailBlockExporter.createBlockIdentifier(flatTexture);
        class_4943.field_22938.method_25852(class_4941.method_25840((class_1792)block.method_8389()), class_4944.method_25895((class_2960)textureId), generator.field_22831);
    }

    public static void registerRailBlockWithRandomTextures(class_4910 generator, class_2248 block, String[][] textureArrays) {
        if (textureArrays.length == 0) {
            throw new IllegalArgumentException("At least one texture array is required");
        }
        RailBlockExporter.generateRailBlockStateWithRandomTextures(generator, block, textureArrays);
        RailBlockExporter.generateRailModelsWithRandomTextures(generator, block, textureArrays);
        class_2960 textureId = RailBlockExporter.createBlockIdentifier(textureArrays[0][0]);
        class_4943.field_22938.method_25852(class_4941.method_25840((class_1792)block.method_8389()), class_4944.method_25895((class_2960)textureId), generator.field_22831);
    }

    private static void generateRailBlockState(class_4910 generator, class_2248 block, String flatTexture, String curvedTexture) {
        String blockName = RailBlockExporter.getBlockName(block);
        HashMap<String, class_4935> variantMap = new HashMap<String, class_4935>();
        for (int i = 0; i < SHAPES.length; ++i) {
            String modelType = MODEL_TYPES[i];
            int rotation = ROTATIONS[i];
            class_2960 modelId = WesterosBlocks.id("block/" + blockName + "/" + modelType);
            class_4935 variant = class_4935.method_25824().method_25828(class_4936.field_22887, (Object)modelId);
            if (rotation != 0) {
                variant = variant.method_25828(class_4936.field_22886, (Object)class_4936.class_4937.valueOf((String)("R" + rotation)));
            }
            variantMap.put(SHAPES[i], variant);
        }
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775((class_4926)class_4926.method_25783((class_2769)class_2443.field_11369).method_25793((Comparable)class_2768.field_12665, (class_4935)variantMap.get("shape=north_south")).method_25793((Comparable)class_2768.field_12674, (class_4935)variantMap.get("shape=east_west")).method_25793((Comparable)class_2768.field_12667, (class_4935)variantMap.get("shape=ascending_east")).method_25793((Comparable)class_2768.field_12666, (class_4935)variantMap.get("shape=ascending_west")).method_25793((Comparable)class_2768.field_12670, (class_4935)variantMap.get("shape=ascending_north")).method_25793((Comparable)class_2768.field_12668, (class_4935)variantMap.get("shape=ascending_south")).method_25793((Comparable)class_2768.field_12664, (class_4935)variantMap.get("shape=south_east")).method_25793((Comparable)class_2768.field_12671, (class_4935)variantMap.get("shape=south_west")).method_25793((Comparable)class_2768.field_12672, (class_4935)variantMap.get("shape=north_west")).method_25793((Comparable)class_2768.field_12663, (class_4935)variantMap.get("shape=north_east"))));
    }

    private static void generateRailBlockStateWithRandomTextures(class_4910 generator, class_2248 block, String[][] textureArrays) {
        String blockName = RailBlockExporter.getBlockName(block);
        ArrayList<class_4935> variants = new ArrayList<class_4935>();
        for (int setIdx = 0; setIdx < textureArrays.length; ++setIdx) {
            class_2960 modelId = WesterosBlocks.id("block/" + blockName + "/flat_v" + (setIdx + 1));
            variants.add(class_4935.method_25824().method_25828(class_4936.field_22887, (Object)modelId));
        }
        generator.field_22830.accept(class_4925.method_25771((class_2248)block, (class_4935[])variants.toArray(new class_4935[0])));
    }

    private static void generateRailModels(class_4910 generator, class_2248 block, String flatTexture, String curvedTexture) {
        String blockName = RailBlockExporter.getBlockName(block);
        HashSet<String> generatedModels = new HashSet<String>();
        for (String modelType : MODEL_TYPES) {
            if (!generatedModels.add(modelType)) continue;
            String texture = modelType.equals("curved") ? curvedTexture : flatTexture;
            RailBlockExporter.generateRailModel(generator, blockName, modelType, texture, "");
        }
    }

    private static void generateRailModelsWithRandomTextures(class_4910 generator, class_2248 block, String[][] textureArrays) {
        String blockName = RailBlockExporter.getBlockName(block);
        for (int setIdx = 0; setIdx < textureArrays.length; ++setIdx) {
            String[] texturePaths = textureArrays[setIdx];
            String flatTexture = texturePaths[0];
            String curvedTexture = texturePaths.length > 1 ? texturePaths[1] : texturePaths[0];
            String variantSuffix = "_v" + (setIdx + 1);
            HashSet<String> generatedModels = new HashSet<String>();
            for (String modelType : MODEL_TYPES) {
                if (!generatedModels.add(modelType)) continue;
                String texture = modelType.equals("curved") ? curvedTexture : flatTexture;
                RailBlockExporter.generateRailModel(generator, blockName, modelType, texture, variantSuffix);
            }
        }
    }

    private static void generateRailModel(class_4910 generator, String blockName, String modelType, String texture, String variantSuffix) {
        class_4944 textureMap = new class_4944().method_25868(class_4945.field_23028, RailBlockExporter.createBlockIdentifier(texture));
        class_4942 model = switch (modelType) {
            case "flat" -> ModModels.RAIL_FLAT;
            case "curved" -> ModModels.RAIL_CURVED;
            case "raised_ne" -> ModModels.TEMPLATE_RAIL_RAISED_NE;
            case "raised_sw" -> ModModels.TEMPLATE_RAIL_RAISED_SW;
            default -> ModModels.RAIL_FLAT;
        };
        class_2960 modelId = WesterosBlocks.id("block/" + blockName + "/" + modelType + variantSuffix);
        model.method_25852(modelId, textureMap, generator.field_22831);
    }

    public static void registerRailBlockFromDefinition(class_4910 generator, class_2248 block, BlockDefinitionV2 definition) {
        List<BlockDefinitionV2.StateVariantV2> states = definition.getStates();
        if (states == null || states.isEmpty()) {
            throw new IllegalStateException("Block definition states should never be null/empty after doInit() for block: " + RailBlockExporter.getBlockName(block));
        }
        BlockDefinitionV2.StateVariantV2 state = states.get(0);
        int textureSetCount = state.getRandomTextureSetCount();
        if (textureSetCount == 0) {
            RailBlockExporter.registerRailBlock(generator, block, "missing");
            return;
        }
        if (textureSetCount == 1) {
            String curvedTexture;
            BlockStateRecordV2.RandomTextureSet set = state.getRandomTextureSet(0);
            if (set == null || set.getTextureCount() == 0) {
                RailBlockExporter.registerRailBlock(generator, block, "missing");
                return;
            }
            String flatTexture = set.getTextureByIndex(0);
            String string = curvedTexture = set.getTextureCount() > 1 ? set.getTextureByIndex(1) : flatTexture;
            if (flatTexture == null) {
                RailBlockExporter.registerRailBlock(generator, block, "missing");
                return;
            }
            RailBlockExporter.registerRailBlock(generator, block, new String[]{flatTexture, curvedTexture});
        } else {
            String[][] textureArrays = new String[textureSetCount][];
            for (int setIdx = 0; setIdx < textureSetCount; ++setIdx) {
                BlockStateRecordV2.RandomTextureSet set = state.getRandomTextureSet(setIdx);
                if (set != null && set.getTextureCount() > 0) {
                    String[] textures = new String[Math.min(set.getTextureCount(), 2)];
                    textures[0] = set.getTextureByIndex(0);
                    textures[1] = set.getTextureCount() > 1 ? set.getTextureByIndex(1) : textures[0];
                    textureArrays[setIdx] = textures;
                    continue;
                }
                textureArrays[setIdx] = new String[]{"missing", "missing"};
            }
            RailBlockExporter.registerRailBlockWithRandomTextures(generator, block, textureArrays);
        }
    }
}

