/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.datagen.custom;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.westerosblocks.data.BlockDefinitionV2;
import com.westerosblocks.data.BlockStateRecordV2;
import com.westerosblocks.datagen.ModModels;
import com.westerosblocks.datagen.ModTextureMap;
import com.westerosblocks.datagen.custom.BaseBlockExporter;
import java.util.List;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4917;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;

public class SlabBlockExporter
extends BaseBlockExporter {
    public static void registerCustomSlabBlock(class_4910 generator, class_2248 block, BlockDefinitionV2 definition) {
        List<BlockDefinitionV2.StateVariantV2> states = definition.getStates();
        if (states == null || states.isEmpty()) {
            throw new IllegalStateException("Block definition states should never be null/empty after doInit() for block: " + SlabBlockExporter.getBlockName(block));
        }
        SlabBlockExporter.generateBlockState(generator, block, states);
        for (int stateIdx = 0; stateIdx < states.size(); ++stateIdx) {
            BlockDefinitionV2.StateVariantV2 state = states.get(stateIdx);
            String stateID = state.getStateID();
            String fname = stateID == null ? "base" : stateID;
            for (int setIdx = 0; setIdx < state.getRandomTextureSetCount(); ++setIdx) {
                if (definition.hasCustomModel() || state.isCustomModel()) continue;
                SlabBlockExporter.generateSlabModels(generator, block, fname, setIdx, state, definition);
            }
        }
        BlockDefinitionV2.StateVariantV2 firstState = states.get(0);
        String firstName = firstState.getStateID() == null ? "base" : firstState.getStateID();
        class_2960 itemModelId = SlabBlockExporter.createNestedModelId(block, SlabBlockExporter.getModelName(firstName, 0, "bottom"));
        SlabBlockExporter.registerParentedItemModel(generator, block, itemModelId);
    }

    private static void generateBlockState(class_4910 generator, final class_2248 block, List<BlockDefinitionV2.StateVariantV2> states) {
        final JsonObject root = new JsonObject();
        JsonObject variants = new JsonObject();
        for (BlockDefinitionV2.StateVariantV2 state : states) {
            String stateID = state.getStateID();
            String fname = stateID == null ? "base" : stateID;
            for (int setIdx = 0; setIdx < state.getRandomTextureSetCount(); ++setIdx) {
                BlockStateRecordV2.RandomTextureSet set = state.getRandomTextureSet(setIdx);
                if (set == null) continue;
                int weight = set.getWeight();
                class_2960 bottomModel = SlabBlockExporter.createNestedModelId(block, SlabBlockExporter.getModelName(fname, setIdx, "bottom"));
                class_2960 topModel = SlabBlockExporter.createNestedModelId(block, SlabBlockExporter.getModelName(fname, setIdx, "top"));
                class_2960 doubleModel = SlabBlockExporter.createNestedModelId(block, SlabBlockExporter.getModelName(fname, setIdx, "double"));
                SlabBlockExporter.addSlabVariant(variants, "type=bottom", bottomModel, weight);
                SlabBlockExporter.addSlabVariant(variants, "type=top", topModel, weight);
                SlabBlockExporter.addSlabVariant(variants, "type=double", doubleModel, weight);
            }
        }
        root.add("variants", (JsonElement)variants);
        generator.field_22830.accept(new class_4917(){

            public class_2248 method_25743() {
                return block;
            }

            public JsonElement get() {
                return root;
            }
        });
    }

    private static void addSlabVariant(JsonObject variants, String variantKey, class_2960 modelId, int weight) {
        JsonObject variantData = new JsonObject();
        variantData.addProperty("model", modelId.toString());
        if (weight > 1) {
            variantData.addProperty("weight", (Number)weight);
        }
        if (variants.has(variantKey)) {
            JsonElement existing = variants.get(variantKey);
            if (existing.isJsonObject()) {
                JsonArray array = new JsonArray();
                array.add(existing);
                array.add((JsonElement)variantData);
                variants.add(variantKey, (JsonElement)array);
            } else if (existing.isJsonArray()) {
                existing.getAsJsonArray().add((JsonElement)variantData);
            }
        } else {
            variants.add(variantKey, (JsonElement)variantData);
        }
    }

    private static void generateSlabModels(class_4910 generator, class_2248 block, String fname, int setIdx, BlockDefinitionV2.StateVariantV2 state, BlockDefinitionV2 definition) {
        BlockStateRecordV2.RandomTextureSet set = state.getRandomTextureSet(setIdx);
        if (set == null || set.getTextureCount() == 0) {
            SlabBlockExporter.generateSlabModelsWithTextures(generator, block, fname, setIdx, new String[]{"missing"}, false, false);
            return;
        }
        String[] textures = new String[set.getTextureCount()];
        for (int i = 0; i < set.getTextureCount(); ++i) {
            textures[i] = set.getTextureByIndex(i);
        }
        boolean isTinted = definition.isTinted() || state.hasOverlayTextures();
        boolean isOverlay = state.hasOverlayTextures();
        SlabBlockExporter.generateSlabModelsWithTextures(generator, block, fname, setIdx, textures, isTinted, isOverlay);
    }

    private static void generateSlabModelsWithTextures(class_4910 generator, class_2248 block, String fname, int setIdx, String[] textures, boolean isTinted, boolean isOverlay) {
        String[] filledTextures = SlabBlockExporter.fillTextureArray(textures);
        class_4944 textureMap = ModTextureMap.customAllSides(filledTextures);
        class_4942 bottomModel = ModModels.SLAB_BOTTOM;
        class_4942 topModel = ModModels.SLAB_TOP;
        class_4942 doubleModel = class_4943.field_22942;
        class_2960 bottomModelId = SlabBlockExporter.createNestedModelId(block, SlabBlockExporter.getModelName(fname, setIdx, "bottom"));
        bottomModel.method_25852(bottomModelId, textureMap, generator.field_22831);
        class_2960 topModelId = SlabBlockExporter.createNestedModelId(block, SlabBlockExporter.getModelName(fname, setIdx, "top"));
        topModel.method_25852(topModelId, textureMap, generator.field_22831);
        class_2960 doubleModelId = SlabBlockExporter.createNestedModelId(block, SlabBlockExporter.getModelName(fname, setIdx, "double"));
        doubleModel.method_25852(doubleModelId, textureMap, generator.field_22831);
    }

    private static String getModelName(String fname, int setIdx, String variant) {
        if (setIdx == 0 && fname.equals("base")) {
            return variant;
        }
        return fname + "_v" + (setIdx + 1) + "_" + variant;
    }
}

