/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.datagen.custom;

import com.westerosblocks.WesterosBlocks;
import com.westerosblocks.block.custom.WCSolidBlock;
import com.westerosblocks.data.BlockDefinitionV2;
import com.westerosblocks.data.BlockStateRecordV2;
import com.westerosblocks.datagen.ModTextureKey;
import com.westerosblocks.datagen.ModTextureMap;
import com.westerosblocks.datagen.custom.BaseBlockExporter;
import com.westerosblocks.utils.ModProperties;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2248;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;

public class SolidBlockExporter
extends BaseBlockExporter {
    private static boolean isSymmetrical(class_2248 block) {
        return block instanceof WCSolidBlock && ((WCSolidBlock)block).symmetrical;
    }

    public static void registerCustomSolidBlock(class_4910 generator, class_2248 block, BlockDefinitionV2 definition) {
        List<BlockDefinitionV2.StateVariantV2> states = definition.getStates();
        if (states == null || states.isEmpty()) {
            return;
        }
        boolean hasSymmetrical = SolidBlockExporter.isSymmetrical(block);
        boolean hasRotateRandom = definition.hasRotateRandom();
        SolidBlockExporter.generateBlockState(generator, block, states, hasSymmetrical, hasRotateRandom);
        for (int stateIdx = 0; stateIdx < states.size(); ++stateIdx) {
            BlockDefinitionV2.StateVariantV2 state = states.get(stateIdx);
            String stateID = state.stateID;
            String fname = stateID == null ? "base" : stateID;
            boolean isTinted = definition.isTinted();
            boolean isOverlay = state.hasOverlayTextures();
            for (int setIdx = 0; setIdx < state.getRandomTextureSetCount(); ++setIdx) {
                if (hasSymmetrical) {
                    SolidBlockExporter.generateSolidModel(generator, block, SolidBlockExporter.getModelName(fname, setIdx, true), state, setIdx, isTinted, isOverlay, true);
                    SolidBlockExporter.generateSolidModel(generator, block, SolidBlockExporter.getModelName(fname, setIdx, false), state, setIdx, isTinted, isOverlay, false);
                    continue;
                }
                SolidBlockExporter.generateSolidModel(generator, block, SolidBlockExporter.getModelName(fname, setIdx), state, setIdx, isTinted, isOverlay, false);
            }
        }
        String firstName = states.get((int)0).stateID;
        firstName = firstName == null ? "base" : firstName;
        class_2960 itemModelId = hasSymmetrical ? SolidBlockExporter.createNestedModelId(block, SolidBlockExporter.getModelName(firstName, 0, true)) : SolidBlockExporter.createNestedModelId(block, SolidBlockExporter.getModelName(firstName, 0));
        SolidBlockExporter.registerParentedItemModel(generator, block, itemModelId);
    }

    private static String getModelName(String fname, int setIdx) {
        return fname + "_v" + (setIdx + 1);
    }

    private static String getModelName(String fname, int setIdx, boolean symmetrical) {
        String dir = symmetrical ? "symmetrical" : "asymmetrical";
        return dir + "/" + fname + "_v" + (setIdx + 1);
    }

    private static void generateBlockState(class_4910 generator, class_2248 block, List<BlockDefinitionV2.StateVariantV2> states, boolean hasSymmetrical, boolean hasRotateRandom) {
        ModProperties.StateProperty blockStateProperty = null;
        for (class_2769 property : block.method_9595().method_11659()) {
            if (!(property instanceof ModProperties.StateProperty)) continue;
            ModProperties.StateProperty stateProperty = (ModProperties.StateProperty)property;
            if (!"state".equals(property.method_11899())) continue;
            blockStateProperty = stateProperty;
            break;
        }
        boolean hasMultipleStates = blockStateProperty != null && states.size() > 1;
        BaseBlockExporter.BlockStateBuilder builder = new BaseBlockExporter.BlockStateBuilder(block, blockStateProperty);
        for (BlockDefinitionV2.StateVariantV2 state : states) {
            String stateID = state.stateID;
            String fname = stateID == null ? "base" : stateID;
            String builderStateID = hasMultipleStates ? stateID : null;
            for (int setIdx = 0; setIdx < state.getRandomTextureSetCount(); ++setIdx) {
                BlockStateRecordV2.RandomTextureSet set = state.getRandomTextureSet(setIdx);
                if (set == null) continue;
                int cnt = hasRotateRandom ? 4 : 1;
                for (int i = 0; i < cnt; ++i) {
                    int rotation = i * 90;
                    int weight = set.getWeight();
                    if (hasSymmetrical) {
                        class_2960 symModel = SolidBlockExporter.createNestedModelId(block, SolidBlockExporter.getModelName(fname, setIdx, true));
                        builder.addVariant("symmetrical=true", SolidBlockExporter.createWeightedVariant(symModel, rotation, weight), builderStateID);
                        class_2960 asymModel = SolidBlockExporter.createNestedModelId(block, SolidBlockExporter.getModelName(fname, setIdx, false));
                        builder.addVariant("symmetrical=false", SolidBlockExporter.createWeightedVariant(asymModel, rotation, weight), builderStateID);
                        continue;
                    }
                    class_2960 modelId = SolidBlockExporter.createNestedModelId(block, SolidBlockExporter.getModelName(fname, setIdx));
                    builder.addVariant("", SolidBlockExporter.createWeightedVariant(modelId, rotation, weight), builderStateID);
                }
            }
        }
        builder.register(generator);
    }

    private static void generateSolidModel(class_4910 generator, class_2248 block, String modelName, BlockDefinitionV2.StateVariantV2 state, int setIdx, boolean isTinted, boolean isOverlay, boolean isSymmetrical) {
        BlockStateRecordV2.RandomTextureSet set = state.getRandomTextureSet(setIdx);
        if (set == null) {
            return;
        }
        class_2960 modelId = SolidBlockExporter.createNestedModelId(block, modelName);
        if (isOverlay) {
            SolidBlockExporter.generateOverlayModel(generator, modelId, set, state.overlayTextures, isTinted, isSymmetrical);
        } else if (set.getTextureCount() > 1 || isTinted) {
            SolidBlockExporter.generateCubeModel(generator, modelId, set, isTinted, isSymmetrical);
        } else {
            SolidBlockExporter.generateCubeAllModel(generator, modelId, set);
        }
    }

    private static void generateCubeAllModel(class_4910 generator, class_2960 modelId, BlockStateRecordV2.RandomTextureSet set) {
        class_4944 textureMap = new class_4944().method_25868(class_4945.field_23010, SolidBlockExporter.createBlockIdentifier(set.getTextureByIndex(0)));
        class_4943.field_22972.method_25852(modelId, textureMap, generator.field_22831);
    }

    private static void generateCubeModel(class_4910 generator, class_2960 modelId, BlockStateRecordV2.RandomTextureSet set, boolean isTinted, boolean isSymmetrical) {
        String down = set.getTextureByIndex(0);
        String up = set.getTextureByIndex(1);
        String north = set.getTextureByIndex(2);
        String south = set.getTextureByIndex(3);
        String west = isSymmetrical ? set.getTextureByIndex(4) : set.getTextureByIndex(6);
        String east = isSymmetrical ? set.getTextureByIndex(5) : set.getTextureByIndex(7);
        String[] textures = SolidBlockExporter.fillTextureArray(new String[]{down, up, north, south, west, east});
        class_4944 textureMap = ModTextureMap.customAllSides(textures);
        if (isTinted) {
            class_4942 tintedModel = new class_4942(Optional.of(WesterosBlocks.id("block/tinted/cube")), Optional.empty(), new class_4945[]{class_4945.field_23024, class_4945.field_23023, class_4945.field_23019, class_4945.field_23020, class_4945.field_23021, class_4945.field_23022});
            tintedModel.method_25852(modelId, textureMap, generator.field_22831);
        } else {
            class_4943.field_22942.method_25852(modelId, textureMap, generator.field_22831);
        }
    }

    private static String getOverlayTextureByIndex(List<String> overlayTextures, int index) {
        if (overlayTextures == null || overlayTextures.isEmpty()) {
            return null;
        }
        if (index >= overlayTextures.size()) {
            index = overlayTextures.size() - 1;
        }
        return overlayTextures.get(index);
    }

    private static void generateOverlayModel(class_4910 generator, class_2960 modelId, BlockStateRecordV2.RandomTextureSet set, List<String> overlayTextures, boolean isTinted, boolean isSymmetrical) {
        String down = set.getTextureByIndex(0);
        String up = set.getTextureByIndex(1);
        String north = set.getTextureByIndex(2);
        String south = set.getTextureByIndex(3);
        String west = isSymmetrical ? set.getTextureByIndex(4) : set.getTextureByIndex(6);
        String east = isSymmetrical ? set.getTextureByIndex(5) : set.getTextureByIndex(7);
        String[] textures = SolidBlockExporter.fillTextureArray(new String[]{down, up, north, south, west, east});
        class_4944 textureMap = ModTextureMap.customAllSides(textures);
        if (overlayTextures != null && !overlayTextures.isEmpty()) {
            textureMap.method_25868(ModTextureKey.DOWN_OVERLAY, SolidBlockExporter.createBlockIdentifier(SolidBlockExporter.getOverlayTextureByIndex(overlayTextures, 0)));
            textureMap.method_25868(ModTextureKey.UP_OVERLAY, SolidBlockExporter.createBlockIdentifier(SolidBlockExporter.getOverlayTextureByIndex(overlayTextures, 1)));
            textureMap.method_25868(ModTextureKey.NORTH_OVERLAY, SolidBlockExporter.createBlockIdentifier(SolidBlockExporter.getOverlayTextureByIndex(overlayTextures, 2)));
            textureMap.method_25868(ModTextureKey.SOUTH_OVERLAY, SolidBlockExporter.createBlockIdentifier(SolidBlockExporter.getOverlayTextureByIndex(overlayTextures, 3)));
            int westIdx = isSymmetrical ? 4 : 6;
            int eastIdx = isSymmetrical ? 5 : 7;
            textureMap.method_25868(ModTextureKey.WEST_OVERLAY, SolidBlockExporter.createBlockIdentifier(SolidBlockExporter.getOverlayTextureByIndex(overlayTextures, westIdx)));
            textureMap.method_25868(ModTextureKey.EAST_OVERLAY, SolidBlockExporter.createBlockIdentifier(SolidBlockExporter.getOverlayTextureByIndex(overlayTextures, eastIdx)));
        }
        String modelPath = isTinted ? "block/tinted/cube_overlay" : "block/untinted/cube_overlay";
        class_4942 overlayModel = new class_4942(Optional.of(WesterosBlocks.id(modelPath)), Optional.empty(), new class_4945[]{class_4945.field_23024, class_4945.field_23023, class_4945.field_23019, class_4945.field_23020, class_4945.field_23021, class_4945.field_23022, ModTextureKey.DOWN_OVERLAY, ModTextureKey.UP_OVERLAY, ModTextureKey.NORTH_OVERLAY, ModTextureKey.SOUTH_OVERLAY, ModTextureKey.EAST_OVERLAY, ModTextureKey.WEST_OVERLAY});
        overlayModel.method_25852(modelId, textureMap, generator.field_22831);
    }
}

