/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.datagen.custom;

import com.westerosblocks.WesterosBlocks;
import com.westerosblocks.data.BlockDefinitionV2;
import com.westerosblocks.datagen.ModModels;
import com.westerosblocks.datagen.custom.BaseBlockExporter;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_7923;

public class TorchBlockExporter
extends BaseBlockExporter {
    public static void registerTorchBlockFromDefinition(class_4910 generator, class_2248 standingTorch, BlockDefinitionV2 definition) {
        String texturePath = TorchBlockExporter.getTextureFromDefinition(definition);
        class_2248 wallTorch = (class_2248)class_7923.field_41175.method_10223(WesterosBlocks.id("wall_" + definition.getBlockName()));
        if (wallTorch == null) {
            WesterosBlocks.LOGGER.warn("Could not find wall torch for: {}", (Object)definition.getBlockName());
            return;
        }
        ModelPair models = TorchBlockExporter.generateTorchModels(generator, standingTorch, texturePath);
        TorchBlockExporter.generateStandingTorchBlockState(generator, standingTorch, models.standingModel);
        TorchBlockExporter.generateWallTorchBlockState(generator, wallTorch, models.wallModel);
        TorchBlockExporter.generateTorchItemModel(generator, standingTorch, texturePath);
    }

    private static ModelPair generateTorchModels(class_4910 generator, class_2248 standingTorch, String texturePath) {
        class_4944 textureMap = TorchBlockExporter.createTorchTextureMap(texturePath);
        class_2960 standingModelId = ModModels.TORCH.method_25852(TorchBlockExporter.createNestedModelId(standingTorch, "base"), textureMap, generator.field_22831);
        class_2960 wallModelId = ModModels.TORCH_WALL.method_25852(TorchBlockExporter.createNestedModelId(standingTorch, "wall"), textureMap, generator.field_22831);
        return new ModelPair(standingModelId, wallModelId);
    }

    private static void generateStandingTorchBlockState(class_4910 generator, class_2248 standingTorch, class_2960 modelId) {
        generator.field_22830.accept(TorchBlockExporter.createSimpleBlockState(standingTorch, modelId));
    }

    private static void generateWallTorchBlockState(class_4910 generator, class_2248 wallTorch, class_2960 modelId) {
        class_4926 variants = TorchBlockExporter.createWallTorchVariants(modelId);
        generator.field_22830.accept(class_4925.method_25769((class_2248)wallTorch).method_25775(variants));
    }

    private static void generateTorchItemModel(class_4910 generator, class_2248 standingTorch, String texturePath) {
        TorchBlockExporter.registerSimpleItemModel(generator, standingTorch, TorchBlockExporter.createBlockIdentifier(texturePath));
    }

    private static class_4926 createWallTorchVariants(class_2960 modelId) {
        return class_4926.method_25783((class_2769)class_2741.field_12481).method_25793((Comparable)class_2350.field_11034, TorchBlockExporter.createVariant(modelId)).method_25793((Comparable)class_2350.field_11035, TorchBlockExporter.createVariant(modelId, 90)).method_25793((Comparable)class_2350.field_11039, TorchBlockExporter.createVariant(modelId, 180)).method_25793((Comparable)class_2350.field_11043, TorchBlockExporter.createVariant(modelId, 270));
    }

    private static class_4944 createTorchTextureMap(String texturePath) {
        return new class_4944().method_25868(class_4945.field_23005, TorchBlockExporter.createBlockIdentifier(texturePath));
    }

    private static String getTextureFromDefinition(BlockDefinitionV2 definition) {
        if (definition.getTextures() != null && !definition.getTextures().isEmpty()) {
            return definition.getTextures().get(0);
        }
        return "lighting/" + definition.getBlockName();
    }

    private record ModelPair(class_2960 standingModel, class_2960 wallModel) {
    }
}

