/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.datagen.custom;

import com.westerosblocks.WesterosBlocks;
import com.westerosblocks.block.custom.WCVinesBlock;
import com.westerosblocks.data.BlockDefinitionV2;
import com.westerosblocks.data.BlockStateRecordV2;
import com.westerosblocks.datagen.ModTextureKey;
import com.westerosblocks.datagen.custom.BaseBlockExporter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2248;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4918;
import net.minecraft.class_4922;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;

public class VinesBlockExporter
extends BaseBlockExporter {
    private static class_4942 createVineModel(String vineType, boolean tinted) {
        String tintPath = tinted ? "block/tinted/" : "block/untinted/";
        String path = tintPath + "vine_" + vineType;
        return new class_4942(Optional.of(WesterosBlocks.id(path)), Optional.empty(), new class_4945[]{ModTextureKey.VINES});
    }

    private static class_4944 createVinesTextureMap(String texture) {
        return new class_4944().method_25868(ModTextureKey.VINES, VinesBlockExporter.createBlockIdentifier(texture));
    }

    private static class_4922 createVinesBlockstate(class_2248 block, List<class_2960> sideModelIds, List<class_2960> topModelIds, List<Integer> weights) {
        class_4922 supplier = class_4922.method_25758((class_2248)block);
        for (int i = 0; i < sideModelIds.size(); ++i) {
            class_2960 sideModelId = sideModelIds.get(i);
            class_2960 topModelId = topModelIds.get(i);
            int weight = weights.get(i);
            VinesBlockExporter.addDirectionalVariants(supplier, sideModelId, topModelId, weight);
        }
        return supplier;
    }

    private static void addDirectionalVariants(class_4922 supplier, class_2960 sideModelId, class_2960 topModelId, int weight) {
        supplier.method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12540, (Comparable)Boolean.valueOf(true)), VinesBlockExporter.createWeightedVariant(sideModelId, 0, weight));
        supplier.method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12527, (Comparable)Boolean.valueOf(true)), VinesBlockExporter.createWeightedVariant(sideModelId, 90, weight));
        supplier.method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12489, (Comparable)Boolean.valueOf(true)), VinesBlockExporter.createWeightedVariant(sideModelId, 180, weight));
        supplier.method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12487, (Comparable)Boolean.valueOf(true)), VinesBlockExporter.createWeightedVariant(sideModelId, 270, weight));
        supplier.method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12519, (Comparable)Boolean.valueOf(true)), VinesBlockExporter.createWeightedVariant(topModelId, 0, weight));
        supplier.method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)WCVinesBlock.DOWN, (Comparable)Boolean.valueOf(true)), VinesBlockExporter.createWeightedVariantX(topModelId, weight));
    }

    private static class_4935 createWeightedVariantX(class_2960 modelId, int weight) {
        class_4935 variant = class_4935.method_25824().method_25828(class_4936.field_22887, (Object)modelId).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22892);
        if (weight > 1) {
            variant = variant.method_25828(class_4936.field_22889, (Object)weight);
        }
        return variant;
    }

    public static void registerVinesBlock(class_4910 generator, class_2248 block, boolean tinted, String sideTexture, String topTexture) {
        class_4944 sideTextureMap = VinesBlockExporter.createVinesTextureMap(sideTexture);
        class_4944 topTextureMap = VinesBlockExporter.createVinesTextureMap(topTexture);
        class_2960 sideModelId = VinesBlockExporter.createVineModel("1", tinted).method_25852(VinesBlockExporter.createNestedModelId(block, "base"), sideTextureMap, generator.field_22831);
        class_2960 topModelId = VinesBlockExporter.createVineModel("u", tinted).method_25852(VinesBlockExporter.createNestedModelId(block, "top"), topTextureMap, generator.field_22831);
        class_4922 blockstate = VinesBlockExporter.createVinesBlockstate(block, List.of(sideModelId), List.of(topModelId), List.of(Integer.valueOf(1)));
        generator.field_22830.accept(blockstate);
        class_4944 itemTextureMap = new class_4944().method_25868(class_4945.field_23006, VinesBlockExporter.createBlockIdentifier(sideTexture));
        class_4943.field_22938.method_25852(class_2960.method_60655((String)"westerosblocks", (String)("item/" + VinesBlockExporter.getBlockName(block))), itemTextureMap, generator.field_22831);
    }

    public static void registerVinesBlockWithRandomTextures(class_4910 generator, class_2248 block, boolean tinted, List<BlockStateRecordV2.RandomTextureSet> textureSets) {
        ArrayList<class_2960> sideModelIds = new ArrayList<class_2960>();
        ArrayList<class_2960> topModelIds = new ArrayList<class_2960>();
        ArrayList<Integer> weights = new ArrayList<Integer>();
        for (int i = 0; i < textureSets.size(); ++i) {
            BlockStateRecordV2.RandomTextureSet set = textureSets.get(i);
            String[] textures = set.getTexturesAsArray();
            class_4944 sideTextureMap = VinesBlockExporter.createVinesTextureMap(textures[0]);
            class_4944 topTextureMap = VinesBlockExporter.createVinesTextureMap(textures.length > 1 ? textures[1] : textures[0]);
            class_2960 sideModelId = VinesBlockExporter.createVineModel("1", tinted).method_25852(VinesBlockExporter.createNestedModelId(block, "base_v" + (i + 1)), sideTextureMap, generator.field_22831);
            class_2960 topModelId = VinesBlockExporter.createVineModel("u", tinted).method_25852(VinesBlockExporter.createNestedModelId(block, "top_v" + (i + 1)), topTextureMap, generator.field_22831);
            sideModelIds.add(sideModelId);
            topModelIds.add(topModelId);
            weights.add(set.getWeight());
        }
        class_4922 blockstate = VinesBlockExporter.createVinesBlockstate(block, sideModelIds, topModelIds, weights);
        generator.field_22830.accept(blockstate);
        String[] firstTextures = textureSets.get(0).getTexturesAsArray();
        class_4944 itemTextureMap = new class_4944().method_25868(class_4945.field_23006, VinesBlockExporter.createBlockIdentifier(firstTextures[0]));
        class_4943.field_22938.method_25852(class_2960.method_60655((String)"westerosblocks", (String)("item/" + VinesBlockExporter.getBlockName(block))), itemTextureMap, generator.field_22831);
    }

    public static void registerCustomVinesBlock(class_4910 generator, class_2248 block, BlockDefinitionV2 definition) {
        boolean tinted = definition.isTinted() || definition.hasColorMult();
        List<BlockDefinitionV2.StateVariantV2> states = definition.getStates();
        if (states == null || states.isEmpty()) {
            throw new IllegalStateException("Block definition states should never be null/empty after doInit() for block: " + VinesBlockExporter.getBlockName(block));
        }
        BlockDefinitionV2.StateVariantV2 state = states.get(0);
        int textureSetCount = state.getRandomTextureSetCount();
        if (textureSetCount > 0) {
            ArrayList<BlockStateRecordV2.RandomTextureSet> textureSets = new ArrayList<BlockStateRecordV2.RandomTextureSet>();
            for (int setIdx = 0; setIdx < textureSetCount; ++setIdx) {
                BlockStateRecordV2.RandomTextureSet set = state.getRandomTextureSet(setIdx);
                if (set == null) continue;
                textureSets.add(set);
            }
            VinesBlockExporter.registerVinesBlockWithRandomTextures(generator, block, tinted, textureSets);
        } else {
            VinesBlockExporter.registerVinesBlock(generator, block, tinted, "missingno", "missingno");
        }
    }
}

