/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.datagen.custom;

import com.westerosblocks.WesterosBlocks;
import com.westerosblocks.data.BlockDefinitionV2;
import com.westerosblocks.data.BlockStateRecordV2;
import com.westerosblocks.datagen.ModTextureKey;
import com.westerosblocks.datagen.custom.BaseBlockExporter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4778;
import net.minecraft.class_4910;
import net.minecraft.class_4918;
import net.minecraft.class_4922;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4941;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;

public class WallBlockExporter
extends BaseBlockExporter {
    private static class_4942 createWallPostModel(boolean tinted, boolean overlay) {
        String tintPath = tinted ? "block/tinted/" : "block/untinted/";
        String overlayPath = overlay ? "_overlay" : "";
        String path = tintPath + "template_wall_post" + overlayPath;
        if (overlay) {
            return new class_4942(Optional.of(WesterosBlocks.id(path)), Optional.empty(), new class_4945[]{class_4945.field_23014, class_4945.field_23015, class_4945.field_23018, ModTextureKey.BOTTOM_OVERLAY, ModTextureKey.TOP_OVERLAY, ModTextureKey.SIDE_OVERLAY, class_4945.field_23012});
        }
        return new class_4942(Optional.of(WesterosBlocks.id(path)), Optional.empty(), new class_4945[]{class_4945.field_23014, class_4945.field_23015, class_4945.field_23018, class_4945.field_23012});
    }

    private static class_4942 createWallSideModel(boolean tinted, boolean overlay, boolean isShort) {
        String tintPath = tinted ? "block/tinted/" : "block/untinted/";
        String overlayPath = overlay ? "_overlay" : "";
        String shortPath = isShort ? "_2" : "";
        String path = tintPath + "template_wall_side" + shortPath + overlayPath;
        if (overlay) {
            return new class_4942(Optional.of(WesterosBlocks.id(path)), Optional.empty(), new class_4945[]{class_4945.field_23014, class_4945.field_23015, class_4945.field_23018, ModTextureKey.BOTTOM_OVERLAY, ModTextureKey.TOP_OVERLAY, ModTextureKey.SIDE_OVERLAY, class_4945.field_23012});
        }
        return new class_4942(Optional.of(WesterosBlocks.id(path)), Optional.empty(), new class_4945[]{class_4945.field_23014, class_4945.field_23015, class_4945.field_23018, class_4945.field_23012});
    }

    private static class_4942 createWallSideTallModel(boolean tinted, boolean overlay) {
        String tintPath = tinted ? "block/tinted/" : "block/untinted/";
        String overlayPath = overlay ? "_overlay" : "";
        String path = tintPath + "template_wall_side_tall" + overlayPath;
        if (overlay) {
            return new class_4942(Optional.of(WesterosBlocks.id(path)), Optional.empty(), new class_4945[]{class_4945.field_23014, class_4945.field_23015, class_4945.field_23018, ModTextureKey.BOTTOM_OVERLAY, ModTextureKey.TOP_OVERLAY, ModTextureKey.SIDE_OVERLAY, class_4945.field_23012});
        }
        return new class_4942(Optional.of(WesterosBlocks.id(path)), Optional.empty(), new class_4945[]{class_4945.field_23014, class_4945.field_23015, class_4945.field_23018, class_4945.field_23012});
    }

    private static class_4944 createWallTextureMap(String[] textures, String[] overlayTextures) {
        class_4944 textureMap = new class_4944().method_25868(class_4945.field_23014, WallBlockExporter.createBlockIdentifier(textures[0])).method_25868(class_4945.field_23015, WallBlockExporter.createBlockIdentifier(textures[1])).method_25868(class_4945.field_23018, WallBlockExporter.createBlockIdentifier(textures[2])).method_25868(class_4945.field_23012, WallBlockExporter.createBlockIdentifier(textures[2]));
        if (overlayTextures != null) {
            textureMap.method_25868(ModTextureKey.BOTTOM_OVERLAY, WallBlockExporter.createBlockIdentifier(overlayTextures[0]));
            textureMap.method_25868(ModTextureKey.TOP_OVERLAY, WallBlockExporter.createBlockIdentifier(overlayTextures[1]));
            textureMap.method_25868(ModTextureKey.SIDE_OVERLAY, WallBlockExporter.createBlockIdentifier(overlayTextures[2]));
        }
        return textureMap;
    }

    private static class_4922 createWallVariants(class_2248 block, List<class_2960> postModelIds, List<class_2960> sideModelIds, List<class_2960> tallModelIds, List<Integer> weights) {
        class_4922 supplier = class_4922.method_25758((class_2248)block);
        for (int i = 0; i < postModelIds.size(); ++i) {
            WallBlockExporter.addPostVariant(supplier, postModelIds.get(i), weights.get(i));
            WallBlockExporter.addSideVariant(supplier, sideModelIds.get(i), weights.get(i), "north", class_4778.field_22179);
            WallBlockExporter.addSideVariant(supplier, tallModelIds.get(i), weights.get(i), "north", class_4778.field_22180);
            WallBlockExporter.addSideVariant(supplier, sideModelIds.get(i), weights.get(i), "east", class_4778.field_22179);
            WallBlockExporter.addSideVariant(supplier, tallModelIds.get(i), weights.get(i), "east", class_4778.field_22180);
            WallBlockExporter.addSideVariant(supplier, sideModelIds.get(i), weights.get(i), "south", class_4778.field_22179);
            WallBlockExporter.addSideVariant(supplier, tallModelIds.get(i), weights.get(i), "south", class_4778.field_22180);
            WallBlockExporter.addSideVariant(supplier, sideModelIds.get(i), weights.get(i), "west", class_4778.field_22179);
            WallBlockExporter.addSideVariant(supplier, tallModelIds.get(i), weights.get(i), "west", class_4778.field_22180);
        }
        return supplier;
    }

    private static void addPostVariant(class_4922 supplier, class_2960 postModelId, int weight) {
        class_4935 postVariant = class_4935.method_25824().method_25828(class_4936.field_22887, (Object)postModelId);
        if (weight > 1) {
            postVariant = postVariant.method_25828(class_4936.field_22889, (Object)weight);
        }
        supplier.method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12519, (Comparable)Boolean.valueOf(true)), postVariant);
    }

    private static void addSideVariant(class_4922 supplier, class_2960 sideModelId, int weight, String direction, class_4778 shape) {
        class_4935 sideVariant = class_4935.method_25824().method_25828(class_4936.field_22887, (Object)sideModelId).method_25828(class_4936.field_22888, (Object)true);
        switch (direction) {
            case "east": {
                sideVariant = sideVariant.method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891);
                break;
            }
            case "south": {
                sideVariant = sideVariant.method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892);
                break;
            }
            case "west": {
                sideVariant = sideVariant.method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893);
            }
        }
        if (weight > 1) {
            sideVariant = sideVariant.method_25828(class_4936.field_22889, (Object)weight);
        }
        class_4918.class_4921 condition = switch (direction) {
            case "north" -> class_4918.method_25744().method_25751((class_2769)class_2741.field_22175, (Comparable)shape);
            case "east" -> class_4918.method_25744().method_25751((class_2769)class_2741.field_22174, (Comparable)shape);
            case "south" -> class_4918.method_25744().method_25751((class_2769)class_2741.field_22176, (Comparable)shape);
            case "west" -> class_4918.method_25744().method_25751((class_2769)class_2741.field_22177, (Comparable)shape);
            default -> throw new IllegalArgumentException("Unknown direction: " + direction);
        };
        supplier.method_25760((class_4918)condition, sideVariant);
    }

    public static void registerWallBlock(class_4910 generator, class_2248 block, boolean tinted, boolean overlay, boolean isShort, String[] textures, String[] overlayTextures) {
        String[] expandedTextures = WallBlockExporter.expandTextureArray(textures);
        String[] expandedOverlays = overlay && overlayTextures != null ? WallBlockExporter.expandTextureArray(overlayTextures) : null;
        class_4944 textureMap = WallBlockExporter.createWallTextureMap(expandedTextures, expandedOverlays);
        class_2960 postModelId = WallBlockExporter.createWallPostModel(tinted, overlay).method_25852(WallBlockExporter.createNestedModelId(block, "post"), textureMap, generator.field_22831);
        class_2960 sideModelId = WallBlockExporter.createWallSideModel(tinted, overlay, isShort).method_25852(WallBlockExporter.createNestedModelId(block, "side"), textureMap, generator.field_22831);
        class_2960 tallModelId = WallBlockExporter.createWallSideTallModel(tinted, overlay).method_25852(WallBlockExporter.createNestedModelId(block, "side_tall"), textureMap, generator.field_22831);
        class_4922 blockstate = WallBlockExporter.createWallVariants(block, List.of(postModelId), List.of(sideModelId), List.of(tallModelId), List.of(Integer.valueOf(1)));
        generator.field_22830.accept(blockstate);
        class_4944 itemTextureMap = new class_4944().method_25868(class_4945.field_23027, WallBlockExporter.createBlockIdentifier(expandedTextures[2]));
        class_2960 itemModelId = class_4941.method_25840((class_1792)block.method_8389());
        class_4943.field_22994.method_25852(itemModelId, itemTextureMap, generator.field_22831);
    }

    public static void registerWallBlockWithRandomTextures(class_4910 generator, class_2248 block, boolean tinted, boolean overlay, boolean isShort, List<BlockStateRecordV2.RandomTextureSet> textureSets, String[] overlayTextures) {
        String[] expandedTextures;
        ArrayList<class_2960> postModelIds = new ArrayList<class_2960>();
        ArrayList<class_2960> sideModelIds = new ArrayList<class_2960>();
        ArrayList<class_2960> tallModelIds = new ArrayList<class_2960>();
        ArrayList<Integer> weights = new ArrayList<Integer>();
        for (int i = 0; i < textureSets.size(); ++i) {
            BlockStateRecordV2.RandomTextureSet set = textureSets.get(i);
            expandedTextures = WallBlockExporter.expandTextureArray(set.getTexturesAsArray());
            String[] expandedOverlays = overlay && overlayTextures != null ? WallBlockExporter.expandTextureArray(overlayTextures) : null;
            class_4944 textureMap = WallBlockExporter.createWallTextureMap(expandedTextures, expandedOverlays);
            class_2960 postModelId = WallBlockExporter.createWallPostModel(tinted, overlay).method_25852(WallBlockExporter.createNestedModelId(block, "post_v" + (i + 1)), textureMap, generator.field_22831);
            class_2960 sideModelId = WallBlockExporter.createWallSideModel(tinted, overlay, isShort).method_25852(WallBlockExporter.createNestedModelId(block, "side_v" + (i + 1)), textureMap, generator.field_22831);
            class_2960 tallModelId = WallBlockExporter.createWallSideTallModel(tinted, overlay).method_25852(WallBlockExporter.createNestedModelId(block, "side_tall_v" + (i + 1)), textureMap, generator.field_22831);
            postModelIds.add(postModelId);
            sideModelIds.add(sideModelId);
            tallModelIds.add(tallModelId);
            weights.add(set.getWeight());
        }
        class_4922 blockstate = WallBlockExporter.createWallVariants(block, postModelIds, sideModelIds, tallModelIds, weights);
        generator.field_22830.accept(blockstate);
        BlockStateRecordV2.RandomTextureSet firstSet = textureSets.get(0);
        expandedTextures = WallBlockExporter.expandTextureArray(firstSet.getTexturesAsArray());
        class_4944 itemTextureMap = new class_4944().method_25868(class_4945.field_23027, WallBlockExporter.createBlockIdentifier(expandedTextures[2]));
        class_2960 itemModelId = class_4941.method_25840((class_1792)block.method_8389());
        class_4943.field_22994.method_25852(itemModelId, itemTextureMap, generator.field_22831);
    }

    public static void registerCustomWallBlock(class_4910 generator, class_2248 block, BlockDefinitionV2 definition) {
        boolean tinted = definition.isTinted() || definition.hasColorMult();
        boolean isShort = "short".equals(definition.getWallSize());
        List<BlockDefinitionV2.StateVariantV2> states = definition.getStates();
        if (states == null || states.isEmpty()) {
            throw new IllegalStateException("Block definition states should never be null/empty after doInit() for block: " + WallBlockExporter.getBlockName(block));
        }
        BlockDefinitionV2.StateVariantV2 state = states.get(0);
        boolean overlay = state.hasOverlayTextures();
        int textureSetCount = state.getRandomTextureSetCount();
        if (textureSetCount > 0) {
            ArrayList<BlockStateRecordV2.RandomTextureSet> textureSets = new ArrayList<BlockStateRecordV2.RandomTextureSet>();
            for (int setIdx = 0; setIdx < textureSetCount; ++setIdx) {
                BlockStateRecordV2.RandomTextureSet set = state.getRandomTextureSet(setIdx);
                if (set == null) continue;
                textureSets.add(set);
            }
            String[] overlayArray = null;
            if (overlay && state.overlayTextures != null && !state.overlayTextures.isEmpty()) {
                overlayArray = state.overlayTextures.toArray(new String[0]);
            }
            WallBlockExporter.registerWallBlockWithRandomTextures(generator, block, tinted, overlay, isShort, textureSets, overlayArray);
        } else {
            WallBlockExporter.registerWallBlock(generator, block, tinted, overlay, isShort, new String[]{"missingno"}, null);
        }
    }

    private static String[] expandTextureArray(String[] textures) {
        if (textures.length == 1) {
            return new String[]{textures[0], textures[0], textures[0]};
        }
        if (textures.length == 3) {
            return textures;
        }
        throw new IllegalArgumentException("Wall blocks require 1 or 3 textures, got " + textures.length);
    }
}

