/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.datagen.providers;

import com.westerosblocks.WesterosBlocks;
import com.westerosblocks.block.ModBlocks;
import com.westerosblocks.data.BlockDefinitionRegistry;
import com.westerosblocks.data.BlockDefinitionV2;
import com.westerosblocks.data.BlockTagEntry;
import com.westerosblocks.data.BlockTagsDefinition;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class ModBlockTagProvider
extends FabricTagProvider<class_2248> {
    public ModBlockTagProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
        super(output, class_7924.field_41254, registriesFuture);
    }

    private boolean isTestBlock(BlockDefinitionV2 definition) {
        return "westeros_test_tab".equals(definition.getCreativeTab());
    }

    protected void method_10514(class_7225.class_7874 wrapperLookup) {
        BlockDefinitionRegistry registry = BlockDefinitionRegistry.getInstance();
        FabricTagProvider.FabricTagBuilder doorTagBuilder = this.getOrCreateTagBuilder(class_3481.field_15495);
        FabricTagProvider.FabricTagBuilder logTagBuilder = this.getOrCreateTagBuilder(class_3481.field_15475);
        FabricTagProvider.FabricTagBuilder slabTagBuilder = this.getOrCreateTagBuilder(class_3481.field_15469);
        FabricTagProvider.FabricTagBuilder flowerPotTagBuilder = this.getOrCreateTagBuilder(class_3481.field_15470);
        FabricTagProvider.FabricTagBuilder stairTagBuilder = this.getOrCreateTagBuilder(class_3481.field_15459);
        FabricTagProvider.FabricTagBuilder ladderTagBuilder = this.getOrCreateTagBuilder(class_3481.field_22414);
        FabricTagProvider.FabricTagBuilder fenceTagBuilder = this.getOrCreateTagBuilder(class_3481.field_16584);
        FabricTagProvider.FabricTagBuilder woodenFenceTagBuilder = this.getOrCreateTagBuilder(class_3481.field_17619);
        FabricTagProvider.FabricTagBuilder fenceGateTagBuilder = this.getOrCreateTagBuilder(class_3481.field_25147);
        FabricTagProvider.FabricTagBuilder leavesTagBuilder = this.getOrCreateTagBuilder(class_3481.field_15503);
        FabricTagProvider.FabricTagBuilder bedTagBuilder = this.getOrCreateTagBuilder(class_3481.field_16443);
        FabricTagProvider.FabricTagBuilder cropTagBuilder = this.getOrCreateTagBuilder(class_3481.field_20341);
        FabricTagProvider.FabricTagBuilder trapdoorTagBuilder = this.getOrCreateTagBuilder(class_3481.field_15487);
        FabricTagProvider.FabricTagBuilder fireTagBuilder = this.getOrCreateTagBuilder(class_3481.field_21952);
        FabricTagProvider.FabricTagBuilder flowersTagBuilder = this.getOrCreateTagBuilder(class_3481.field_20339);
        FabricTagProvider.FabricTagBuilder railTagBuilder = this.getOrCreateTagBuilder(class_3481.field_15463);
        FabricTagProvider.FabricTagBuilder sandTagBuilder = this.getOrCreateTagBuilder(class_3481.field_15466);
        FabricTagProvider.FabricTagBuilder torchBuilder = this.getOrCreateTagBuilder(class_3481.field_22276);
        FabricTagProvider.FabricTagBuilder wallTagBuilder = this.getOrCreateTagBuilder(class_3481.field_15504);
        FabricTagProvider.FabricTagBuilder coralTagBuilder = this.getOrCreateTagBuilder(class_3481.field_15488);
        FabricTagProvider.FabricTagBuilder wallCoralTagBuilder = this.getOrCreateTagBuilder(class_3481.field_15476);
        HashMap<String, FabricTagProvider.FabricTagBuilder> customTagBuilders = new HashMap<String, FabricTagProvider.FabricTagBuilder>();
        for (BlockDefinitionV2 definition : registry.getAllDefinitions()) {
            if (this.isTestBlock(definition)) continue;
            String blockType = definition.getBlockType();
            String blockName = definition.getBlockName();
            class_2248 block = ModBlocks.getAutoRegisteredBlock(blockName);
            if (block == null) continue;
            switch (blockType.toLowerCase()) {
                case "door": 
                case "halfdoor": {
                    doorTagBuilder.add((Object)block);
                    break;
                }
                case "log": {
                    logTagBuilder.add((Object)block);
                    break;
                }
                case "slab": {
                    slabTagBuilder.add((Object)block);
                    break;
                }
                case "flowerpot": {
                    flowerPotTagBuilder.add((Object)block);
                    break;
                }
                case "stair": {
                    stairTagBuilder.add((Object)block);
                    break;
                }
                case "ladder": {
                    if (definition.isNoClimb()) break;
                    ladderTagBuilder.add((Object)block);
                    break;
                }
                case "fence": {
                    fenceTagBuilder.add((Object)block);
                    if (!"wood".equalsIgnoreCase(definition.getSoundGroup())) break;
                    woodenFenceTagBuilder.add((Object)block);
                    break;
                }
                case "fencegate": {
                    fenceGateTagBuilder.add((Object)block);
                    break;
                }
                case "leaves": {
                    leavesTagBuilder.add((Object)block);
                    break;
                }
                case "bed": {
                    bedTagBuilder.add((Object)block);
                    break;
                }
                case "crop": {
                    cropTagBuilder.add((Object)block);
                    break;
                }
                case "trapdoor": {
                    trapdoorTagBuilder.add((Object)block);
                    break;
                }
                case "fire": {
                    fireTagBuilder.add((Object)block);
                    break;
                }
                case "plant": {
                    flowersTagBuilder.add((Object)block);
                    break;
                }
                case "rail": {
                    railTagBuilder.add((Object)block);
                    break;
                }
                case "sand": {
                    sandTagBuilder.add((Object)block);
                    break;
                }
                case "torch": {
                    torchBuilder.add((Object)block);
                    class_2248 wallTorchBlock = ModBlocks.getAutoRegisteredBlock("wall_" + blockName);
                    if (wallTorchBlock == null) break;
                    torchBuilder.add((Object)wallTorchBlock);
                    break;
                }
                case "wall": {
                    wallTagBuilder.add((Object)block);
                    break;
                }
                case "fan": {
                    coralTagBuilder.add((Object)block);
                    class_2248 wallFanBlock = ModBlocks.getAutoRegisteredBlock("wall_" + blockName);
                    if (wallFanBlock == null) break;
                    wallCoralTagBuilder.add((Object)wallFanBlock);
                    break;
                }
            }
            if (!definition.hasCustomTags()) continue;
            for (String customTag : definition.getCustomTags()) {
                String tagName = customTag.replace("-", "_");
                FabricTagProvider.FabricTagBuilder customTagBuilder = customTagBuilders.computeIfAbsent(tagName, tag -> {
                    class_6862 tagKey = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)class_2960.method_60655((String)"westerosblocks", (String)tag));
                    return this.getOrCreateTagBuilder(tagKey);
                });
                customTagBuilder.add((Object)block);
            }
        }
        this.generateCustomTags(registry);
    }

    private void generateCustomTags(BlockDefinitionRegistry registry) {
        BlockTagsDefinition blockTags = registry.getBlockTags();
        if (blockTags == null || !blockTags.hasTags()) {
            WesterosBlocks.LOGGER.debug("No custom block tags to generate");
            return;
        }
        WesterosBlocks.LOGGER.info("Generating {} custom block tags", (Object)blockTags.getTagCount());
        for (BlockTagEntry entry : blockTags.getTags()) {
            if (!entry.hasCustomTag()) continue;
            String tagName = entry.getCustomTag().replace("-", "_");
            class_6862 customTag = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)class_2960.method_60655((String)"westerosblocks", (String)tagName));
            FabricTagProvider.FabricTagBuilder tagBuilder = this.getOrCreateTagBuilder(customTag);
            for (String blockName : entry.getBlockNames()) {
                class_2248 block = this.resolveBlock(blockName);
                if (block != null) {
                    tagBuilder.add((Object)block);
                    continue;
                }
                WesterosBlocks.LOGGER.warn("Could not resolve block '{}' for custom tag '{}'", (Object)blockName, (Object)entry.getCustomTag());
            }
        }
    }

    private class_2248 resolveBlock(String blockName) {
        if (blockName.contains(":")) {
            String[] parts = blockName.split(":", 2);
            String namespace = parts[0];
            String path = parts[1];
            if ("minecraft".equals(namespace)) {
                class_2960 id = class_2960.method_60655((String)"minecraft", (String)path);
                return (class_2248)class_7923.field_41175.method_10223(id);
            }
            if ("westerosblocks".equals(namespace)) {
                return ModBlocks.getAutoRegisteredBlock(path);
            }
            class_2960 id = class_2960.method_60655((String)namespace, (String)path);
            return (class_2248)class_7923.field_41175.method_10223(id);
        }
        return ModBlocks.getAutoRegisteredBlock(blockName);
    }
}

