/*
 * Decompiled with CFR 0.152.
 */
package com.westerosblocks.datagen.providers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.westerosblocks.WesterosBlocks;
import com.westerosblocks.data.BlockDefinitionRegistry;
import com.westerosblocks.data.BlockDefinitionV2;
import com.westerosblocks.data.ColorMapDefinition;
import com.westerosblocks.data.ColorMapEntry;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7784;

public class ModPolytoneProvider
implements class_2405 {
    private final class_7784.class_7489 blockModifiersPathResolver;
    private final class_7784.class_7489 itemModifiersPathResolver;

    public ModPolytoneProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registryLookup) {
        this.blockModifiersPathResolver = output.method_45973(class_7784.class_7490.field_39368, "polytone/block_modifiers");
        this.itemModifiersPathResolver = output.method_45973(class_7784.class_7490.field_39368, "polytone/item_modifiers");
    }

    public CompletableFuture<?> method_10319(class_7403 writer) {
        List<String> blockIds;
        String colormapId;
        HashMap<String, List> blocksByColormap = new HashMap<String, List>();
        BlockDefinitionRegistry registry = BlockDefinitionRegistry.getInstance();
        if (!registry.isInitialized()) {
            WesterosBlocks.LOGGER.warn("BlockDefinitionRegistry not initialized - skipping Polytone generation");
            return CompletableFuture.completedFuture(null);
        }
        for (BlockDefinitionV2 definition : registry.getAllDefinitions()) {
            if ("westeros_test_tab".equals(definition.getCreativeTab())) continue;
            String blockId = "westerosblocks:" + definition.getBlockName();
            if (definition.hasColorMult()) {
                String colorMult = definition.getColorMult();
                String colormapId2 = this.extractColormapId(colorMult);
                blocksByColormap.computeIfAbsent(colormapId2, k -> new ArrayList()).add(blockId);
            }
            if (!definition.hasColorMults()) continue;
            List<String> colorMults = definition.getColorMults();
            for (String colorMult : colorMults) {
                String colormapId3 = this.extractColormapId(colorMult);
                blocksByColormap.computeIfAbsent(colormapId3, k -> new ArrayList()).add(blockId);
            }
        }
        ColorMapDefinition colorMaps = registry.getColorMaps();
        int vanillaBlockCount = 0;
        if (colorMaps != null && colorMaps.hasColorMaps()) {
            for (ColorMapEntry entry : colorMaps.getColorMaps()) {
                if (!entry.hasColorMult() || !entry.hasBlockNames()) continue;
                String colorMult = entry.getColorMult();
                if (colorMult.startsWith("#")) {
                    WesterosBlocks.LOGGER.debug("Skipping hex color {} for blocks: {}", (Object)colorMult, entry.getBlockNames());
                    continue;
                }
                colormapId = this.extractColormapId(colorMult);
                blockIds = entry.getBlockNames();
                blocksByColormap.computeIfAbsent(colormapId, k -> new ArrayList()).addAll(blockIds);
                vanillaBlockCount += blockIds.size();
            }
            WesterosBlocks.LOGGER.info("Added {} vanilla/external blocks from color_maps.json", (Object)vanillaBlockCount);
        }
        if (blocksByColormap.isEmpty()) {
            WesterosBlocks.LOGGER.info("No blocks with colorMult property found - skipping Polytone generation");
            return CompletableFuture.completedFuture(null);
        }
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
        for (Map.Entry entry : blocksByColormap.entrySet()) {
            colormapId = (String)entry.getKey();
            blockIds = (List<String>)entry.getValue();
            Collections.sort(blockIds);
            JsonObject json = new JsonObject();
            JsonArray targetsArray = new JsonArray();
            blockIds.forEach(arg_0 -> ((JsonArray)targetsArray).add(arg_0));
            json.add("targets", (JsonElement)targetsArray);
            json.addProperty("colormap", "westerosblocks:" + colormapId);
            class_2960 blockFileId = class_2960.method_60655((String)"westerosblocks", (String)(colormapId + "_tinted_blocks"));
            Path blockOutputPath = this.blockModifiersPathResolver.method_44107(blockFileId);
            CompletableFuture blockFuture = class_2405.method_10320((class_7403)writer, (JsonElement)json, (Path)blockOutputPath);
            futures.add(blockFuture);
            class_2960 itemFileId = class_2960.method_60655((String)"westerosblocks", (String)(colormapId + "_tinted_blocks"));
            Path itemOutputPath = this.itemModifiersPathResolver.method_44107(itemFileId);
            CompletableFuture itemFuture = class_2405.method_10320((class_7403)writer, (JsonElement)json, (Path)itemOutputPath);
            futures.add(itemFuture);
        }
        WesterosBlocks.LOGGER.info("Successfully generated {} Polytone modifier files ({} in block_modifiers, {} in item_modifiers)", new Object[]{blocksByColormap.size() * 2, blocksByColormap.size(), blocksByColormap.size()});
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    private String extractColormapId(String colorMult) {
        if (colorMult.contains("/")) {
            String[] parts = colorMult.split("/");
            return parts[parts.length - 1];
        }
        return colorMult;
    }

    public String method_10321() {
        return "Polytone Block & Item Modifiers";
    }
}

