/*
 * Decompiled with CFR 0.152.
 */
package net.multiverse.dynamicheight.worldheight;

import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2874;
import net.minecraft.class_4284;
import net.minecraft.class_7225;
import net.multiverse.dynamicheight.worldheight.HeightValidator;
import net.multiverse.dynamicheight.worldheight.WorldHeightData;

public final class WorldHeightSavedData
extends class_18 {
    private static final String KEY_MIN = "MinY";
    private static final String KEY_MAX = "MaxY";
    private int minY;
    private int maxY;

    public static class_18.class_8645<WorldHeightSavedData> factory(class_2874 dimensionType) {
        return new class_18.class_8645(() -> new WorldHeightSavedData(dimensionType.comp_651(), dimensionType.comp_651() + dimensionType.comp_652()), (tag, provider) -> WorldHeightSavedData.load(tag, dimensionType), class_4284.field_19212);
    }

    public WorldHeightSavedData() {
        this(-64, 135);
    }

    public WorldHeightSavedData(int minY, int maxY) {
        this.applyRangeInternal(HeightValidator.sanitize(minY, maxY));
    }

    private static WorldHeightSavedData load(class_2487 tag, class_2874 dimensionType) {
        int fallbackMin = dimensionType.comp_651();
        int fallbackMax = fallbackMin + dimensionType.comp_652();
        int min = tag.method_10545(KEY_MIN) ? tag.method_10550(KEY_MIN) : fallbackMin;
        int max = tag.method_10545(KEY_MAX) ? tag.method_10550(KEY_MAX) : fallbackMax;
        return new WorldHeightSavedData(min, max);
    }

    public class_2487 method_75(class_2487 tag, class_7225.class_7874 provider) {
        tag.method_10569(KEY_MIN, this.minY);
        tag.method_10569(KEY_MAX, this.maxY);
        return tag;
    }

    public int minY() {
        return this.minY;
    }

    public int maxY() {
        return this.maxY;
    }

    public int height() {
        return this.maxY - this.minY;
    }

    public void update(WorldHeightData.Snapshot snapshot) {
        this.applyRange(snapshot.minY(), snapshot.maxY());
    }

    public boolean applyRange(int newMinY, int newMaxY) {
        return this.applyRangeInternal(HeightValidator.sanitize(newMinY, newMaxY));
    }

    private boolean applyRangeInternal(HeightValidator.HeightRange range) {
        if (range.minY() == this.minY && range.maxY() == this.maxY) {
            return false;
        }
        this.minY = range.minY();
        this.maxY = range.maxY();
        this.method_80();
        return true;
    }
}

