/*
 * Decompiled with CFR 0.152.
 */
package net.multiverse.dynamicheight.network;

import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.multiverse.dynamicheight.network.WorldHeightAppliedPayload;
import net.multiverse.dynamicheight.network.WorldHeightSyncPayload;
import net.multiverse.dynamicheight.worldheight.WorldHeightData;
import net.multiverse.dynamicheight.worldheight.WorldHeightManager;
import net.multiverse.dynamicheight.worldheight.WorldHeightSavedData;

public final class WorldHeightNetwork {
    private WorldHeightNetwork() {
    }

    public static void register() {
        PayloadTypeRegistry.playC2S().register(WorldHeightSyncPayload.TYPE, WorldHeightSyncPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(WorldHeightAppliedPayload.TYPE, WorldHeightAppliedPayload.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(WorldHeightSyncPayload.TYPE, (payload, context) -> context.player().field_13995.execute(() -> {
            WorldHeightData.updateFromClient(payload.minY(), payload.maxY());
            WorldHeightManager.applyClientSelection(context.player(), WorldHeightData.consumeSnapshot());
            WorldHeightNetwork.sendCurrentRange(context.player(), context.player().method_51469());
        }));
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> WorldHeightNetwork.sendCurrentRange(handler.field_14140, handler.field_14140.method_51469()));
        ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD.register((player, origin, destination) -> WorldHeightNetwork.sendCurrentRange(player, destination));
    }

    public static void sendCurrentRange(class_3222 player, class_3218 level) {
        WorldHeightSavedData data = WorldHeightManager.currentData(level);
        ServerPlayNetworking.send((class_3222)player, (class_8710)new WorldHeightAppliedPayload(level.method_27983().method_29177(), data.minY(), data.maxY()));
    }

    public static void broadcast(class_3218 level, WorldHeightSavedData data) {
        for (class_3222 player : level.method_18456()) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)new WorldHeightAppliedPayload(level.method_27983().method_29177(), data.minY(), data.maxY()));
        }
    }
}

