/*
 * Decompiled with CFR 0.152.
 */
package net.multiverse.dynamicheight.mixin;

import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.multiverse.dynamicheight.client.ClientDimensionHeights;
import net.multiverse.dynamicheight.util.DimensionTypeUtil;
import net.multiverse.dynamicheight.worldheight.WorldHeightData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientLevel.class})
public abstract class ClientLevelMixin {
    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void dynamicheight$applyCustomHeights(ClientPacketListener clientPacketListener, ClientLevel.ClientLevelData clientLevelData, ResourceKey<Level> resourceKey, Holder<DimensionType> holder, int chunkRadius, int simulationDistance, LevelRenderer levelRenderer, boolean bl, long seed, int lightingTickCounter, CallbackInfo ci) {
        ClientLevel level = (ClientLevel)this;
        ResourceLocation dimensionId = level.dimension().location();
        WorldHeightData.Snapshot override = Optional.ofNullable(ClientDimensionHeights.lookup(dimensionId)).orElseGet(() -> {
            if (Minecraft.getInstance().hasSingleplayerServer()) {
                return WorldHeightData.currentSnapshot();
            }
            return null;
        });
        if (override == null) {
            return;
        }
        ClientLevelMixin.applyDimensionOverride(level, holder, override);
    }

    private static void applyDimensionOverride(ClientLevel level, Holder<DimensionType> holder, WorldHeightData.Snapshot override) {
        DimensionType current = (DimensionType)holder.value();
        if (current.minY() == override.minY() && current.height() == override.height()) {
            return;
        }
        DimensionType updated = DimensionTypeUtil.copyWithHeight(current, override.minY(), override.maxY());
        DimensionTypeUtil.bindUpdatedDimensionType(level.registryAccess(), holder, updated);
    }
}

