/*
 * Decompiled with CFR 0.152.
 */
package net.multiverse.dynamicheight.client;

import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.multiverse.dynamicheight.client.ClientDimensionHeights;
import net.multiverse.dynamicheight.network.WorldHeightNetwork;
import net.multiverse.dynamicheight.worldheight.WorldHeightData;

public final class WorldHeightClientNetworking {
    private WorldHeightClientNetworking() {
    }

    public static void register() {
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> WorldHeightClientNetworking.sendCurrentSelection());
        ClientPlayNetworking.registerGlobalReceiver((class_2960)WorldHeightNetwork.APPLIED_CHANNEL, (client, handler, buf, responseSender) -> {
            class_2960 dimensionId = buf.method_10810();
            int minY = buf.readInt();
            int maxY = buf.readInt();
            client.execute(() -> WorldHeightClientNetworking.handleServerApplied(dimensionId, minY, maxY));
        });
    }

    public static void sendCurrentSelection() {
        class_310 client = class_310.method_1551();
        if (client.method_1562() == null) {
            return;
        }
        WorldHeightData.Snapshot snapshot = WorldHeightData.currentSnapshot();
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(snapshot.minY());
        buf.writeInt(snapshot.maxY());
        ClientPlayNetworking.send((class_2960)WorldHeightNetwork.SYNC_CHANNEL, (class_2540)buf);
    }

    private static void handleServerApplied(class_2960 dimension, int minY, int maxY) {
        WorldHeightData.applyServerRange(minY, maxY);
        ClientDimensionHeights.remember(dimension, minY, maxY);
    }
}

