/*
 * Decompiled with CFR 0.152.
 */
package net.multiverse.dynamicheight.client;

import com.mojang.serialization.Lifecycle;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.minecraft.class_2370;
import net.minecraft.class_2561;
import net.minecraft.class_2874;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_525;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_6880;
import net.minecraft.class_7723;
import net.minecraft.class_7919;
import net.minecraft.class_7924;
import net.multiverse.dynamicheight.client.WorldHeightSettings;
import net.multiverse.dynamicheight.mixin.ScreenInvoker;
import net.multiverse.dynamicheight.util.DimensionTypeUtil;

public final class WorldHeightScreenHooks {
    private static final class_2561 HEADER = class_2561.method_43470((String)"Custom Height Settings");
    private static final class_2561 FLOOR_LABEL = class_2561.method_43470((String)"Floor (min Y)");
    private static final class_2561 CEILING_LABEL = class_2561.method_43470((String)"Ceiling (max Y)");
    private static LabelWidget minLabel;
    private static LabelWidget maxLabel;
    private static class_342 minBox;
    private static class_342 maxBox;
    private static class_4185 resetButton;
    private static boolean panelVisible;
    private static final Class<?> TAB_MANAGER_CLASS;
    private static Field TAB_MANAGER_FIELD;
    private static Method TAB_MANAGER_METHOD;
    private static Method GET_UI_STATE_METHOD;
    private static Field UI_STATE_FIELD;
    private static Method UPDATE_DIMENSIONS_METHOD;
    private static Class<?> DIMENSIONS_UPDATER_CLASS;

    private WorldHeightScreenHooks() {
    }

    public static void register() {
        ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            if (screen instanceof class_525) {
                class_525 createWorldScreen = (class_525)screen;
                WorldHeightScreenHooks.onInit(createWorldScreen);
            } else {
                WorldHeightScreenHooks.clearWidgets();
            }
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            class_437 patt0$temp = client.field_1755;
            if (patt0$temp instanceof class_525) {
                class_525 screen = (class_525)patt0$temp;
                WorldHeightScreenHooks.refreshBoxes(screen);
            }
        });
    }

    private static void clearWidgets() {
        minLabel = null;
        maxLabel = null;
        minBox = null;
        maxBox = null;
        resetButton = null;
        panelVisible = false;
    }

    private static void onInit(class_525 screen) {
        WorldHeightScreenHooks.clearWidgets();
        panelVisible = true;
        int panelWidth = 220;
        int panelX = 20;
        int fieldWidth = panelWidth * 2 / 5;
        int startY = 20;
        resetButton = class_4185.method_46430((class_2561)HEADER, button -> {
            WorldHeightSettings.resetToDefaults();
            WorldHeightScreenHooks.refreshBoxes(screen);
            WorldHeightScreenHooks.applySelection(screen);
        }).method_46434(panelX, startY, panelWidth, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Reset to the default overworld height"))).method_46431();
        WorldHeightScreenHooks.addWidget(screen, (class_339)resetButton);
        int rowY = startY + 28;
        minLabel = new LabelWidget(panelX, rowY, fieldWidth, 10, FLOOR_LABEL);
        WorldHeightScreenHooks.addWidget(screen, minLabel);
        minBox = new class_342(class_310.method_1551().field_1772, panelX, rowY += 12, fieldWidth, 20, FLOOR_LABEL);
        minBox.method_1852(Integer.toString(WorldHeightSettings.getMinY()));
        minBox.method_1890(WorldHeightScreenHooks::allowIntegerInput);
        minBox.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Clamped to multiples of 16 down to vanilla minimum (-64).")));
        minBox.method_1863(value -> {
            Integer parsed = WorldHeightScreenHooks.parseInt(value);
            if (parsed != null) {
                WorldHeightSettings.setMinY(parsed);
                WorldHeightScreenHooks.applySelection(screen);
            }
        });
        WorldHeightScreenHooks.addWidget(screen, (class_339)minBox);
        maxLabel = new LabelWidget(panelX, rowY += 28, fieldWidth, 10, CEILING_LABEL);
        WorldHeightScreenHooks.addWidget(screen, maxLabel);
        maxBox = new class_342(class_310.method_1551().field_1772, panelX, rowY += 12, fieldWidth, 20, CEILING_LABEL);
        maxBox.method_1852(Integer.toString(WorldHeightSettings.getMaxY()));
        maxBox.method_1890(WorldHeightScreenHooks::allowIntegerInput);
        maxBox.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Snaps to 16-block steps and never below vanilla ceiling.")));
        maxBox.method_1863(value -> {
            Integer parsed = WorldHeightScreenHooks.parseInt(value);
            if (parsed != null) {
                WorldHeightSettings.setMaxY(parsed);
                WorldHeightScreenHooks.applySelection(screen);
            }
        });
        WorldHeightScreenHooks.addWidget(screen, (class_339)maxBox);
        WorldHeightScreenHooks.applySelection(screen);
        WorldHeightScreenHooks.setWidgetVisibility(true);
        WorldHeightScreenHooks.updateFieldValues();
    }

    private static void refreshBoxes(class_525 screen) {
        boolean visible = WorldHeightScreenHooks.isWorldTabActive(screen);
        if (visible != panelVisible) {
            panelVisible = visible;
            WorldHeightScreenHooks.setWidgetVisibility(visible);
        }
        if (visible) {
            WorldHeightScreenHooks.updateFieldValues();
        }
    }

    private static void applySelection(class_525 screen) {
        Object state = WorldHeightScreenHooks.resolveUiState(screen);
        if (state != null) {
            WorldHeightScreenHooks.invokeUpdateDimensions(state, WorldHeightSettings.getMinY(), WorldHeightSettings.getMaxY());
        }
    }

    private static class_7723 rebuildDimensions(class_5455.class_6890 registryAccess, class_7723 existing, int minY, int maxY) {
        class_2370 rebuilt = new class_2370(class_7924.field_41224, Lifecycle.stable());
        existing.comp_1014().method_29722().forEach(entry -> rebuilt.method_10272((class_5321)entry.getKey(), (Object)WorldHeightScreenHooks.rebuildStem((class_5455)registryAccess, (class_5363)entry.getValue(), minY, maxY), Lifecycle.stable()));
        return new class_7723(rebuilt.method_40276());
    }

    private static class_5363 rebuildStem(class_5455 registryAccess, class_5363 stem, int minY, int maxY) {
        class_2874 updated = DimensionTypeUtil.copyWithHeight((class_2874)stem.comp_1012().comp_349(), minY, maxY);
        class_6880<class_2874> updatedHolder = DimensionTypeUtil.bindUpdatedDimensionType(registryAccess, (class_6880<class_2874>)stem.comp_1012(), updated);
        return new class_5363(updatedHolder, stem.comp_1013());
    }

    private static boolean isWorldTabActive(class_525 screen) {
        Object manager = WorldHeightScreenHooks.resolveTabManager(screen);
        if (manager == null) {
            return true;
        }
        try {
            Method getCurrentTab = manager.getClass().getMethod("getCurrentTab", new Class[0]);
            Object current = getCurrentTab.invoke(manager, new Object[0]);
            if (current == null) {
                return true;
            }
            String simpleName = current.getClass().getSimpleName();
            if (simpleName.contains("WorldTab")) {
                return true;
            }
            Package pkg = current.getClass().getPackage();
            return pkg != null && pkg.getName().contains("worldselection");
        }
        catch (ReflectiveOperationException ignored) {
            return true;
        }
    }

    private static void setWidgetVisibility(boolean visible) {
        if (resetButton != null) {
            WorldHeightScreenHooks.resetButton.field_22764 = visible;
            WorldHeightScreenHooks.resetButton.field_22763 = visible;
        }
        if (minLabel != null) {
            WorldHeightScreenHooks.minLabel.field_22764 = visible;
        }
        if (maxLabel != null) {
            WorldHeightScreenHooks.maxLabel.field_22764 = visible;
        }
        if (minBox != null) {
            WorldHeightScreenHooks.minBox.field_22764 = visible;
            WorldHeightScreenHooks.minBox.field_22763 = visible;
        }
        if (maxBox != null) {
            WorldHeightScreenHooks.maxBox.field_22764 = visible;
            WorldHeightScreenHooks.maxBox.field_22763 = visible;
        }
    }

    private static void updateFieldValues() {
        String desired;
        if (minBox != null && !minBox.method_25370() && !(desired = Integer.toString(WorldHeightSettings.getMinY())).equals(minBox.method_1882())) {
            minBox.method_1852(desired);
        }
        if (maxBox != null && !maxBox.method_25370() && !(desired = Integer.toString(WorldHeightSettings.getMaxY())).equals(maxBox.method_1882())) {
            maxBox.method_1852(desired);
        }
    }

    private static Object resolveTabManager(class_525 screen) {
        if (TAB_MANAGER_CLASS == null) {
            return null;
        }
        try {
            if (TAB_MANAGER_FIELD == null && (TAB_MANAGER_FIELD = WorldHeightScreenHooks.findFieldWithType(screen.getClass(), TAB_MANAGER_CLASS)) != null) {
                TAB_MANAGER_FIELD.setAccessible(true);
            }
            if (TAB_MANAGER_FIELD != null) {
                return TAB_MANAGER_FIELD.get(screen);
            }
            if (TAB_MANAGER_METHOD == null && (TAB_MANAGER_METHOD = WorldHeightScreenHooks.findZeroArgMethodReturning(screen.getClass(), TAB_MANAGER_CLASS)) != null) {
                TAB_MANAGER_METHOD.setAccessible(true);
            }
            if (TAB_MANAGER_METHOD != null) {
                return TAB_MANAGER_METHOD.invoke((Object)screen, new Object[0]);
            }
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return null;
    }

    private static Field findFieldWithType(Class<?> owner, Class<?> type) {
        if (type == null) {
            return null;
        }
        for (Class<?> current = owner; current != null && current != Object.class; current = current.getSuperclass()) {
            for (Field field : current.getDeclaredFields()) {
                if (field.getType() != type) continue;
                return field;
            }
        }
        return null;
    }

    private static Method findZeroArgMethodReturning(Class<?> owner, Class<?> type) {
        if (type == null) {
            return null;
        }
        for (Class<?> current = owner; current != null && current != Object.class; current = current.getSuperclass()) {
            for (Method method : current.getDeclaredMethods()) {
                if (method.getParameterCount() != 0 || method.getReturnType() != type) continue;
                return method;
            }
        }
        return null;
    }

    private static Field findFieldByName(Class<?> owner, String name) {
        for (Class<?> current = owner; current != null && current != Object.class; current = current.getSuperclass()) {
            try {
                return current.getDeclaredField(name);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        return null;
    }

    private static Method findMethod(Class<?> owner, String name, int parameterCount) {
        for (Class<?> current = owner; current != null && current != Object.class; current = current.getSuperclass()) {
            for (Method method : current.getDeclaredMethods()) {
                if (!method.getName().equals(name) || method.getParameterCount() != parameterCount) continue;
                return method;
            }
        }
        return null;
    }

    private static boolean allowIntegerInput(String value) {
        if (value == null || value.isEmpty() || "-".equals(value)) {
            return true;
        }
        return WorldHeightScreenHooks.parseInt(value) != null;
    }

    private static Integer parseInt(String value) {
        if (value == null || value.isEmpty() || "-".equals(value)) {
            return null;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static void addWidget(class_525 screen, class_339 widget) {
        ((ScreenInvoker)screen).dynamicheight$addRenderableWidget(widget);
    }

    private static Class<?> resolveTabManagerClass() {
        try {
            return Class.forName("net.minecraft.client.gui.components.tabs.TabManager");
        }
        catch (ClassNotFoundException ignored) {
            return null;
        }
    }

    private static Object resolveUiState(class_525 screen) {
        try {
            if (GET_UI_STATE_METHOD == null && UI_STATE_FIELD == null) {
                try {
                    GET_UI_STATE_METHOD = screen.getClass().getMethod("getUiState", new Class[0]);
                    GET_UI_STATE_METHOD.setAccessible(true);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                if (GET_UI_STATE_METHOD == null && (UI_STATE_FIELD = WorldHeightScreenHooks.findFieldByName(screen.getClass(), "uiState")) != null) {
                    UI_STATE_FIELD.setAccessible(true);
                }
            }
            if (GET_UI_STATE_METHOD != null) {
                return GET_UI_STATE_METHOD.invoke((Object)screen, new Object[0]);
            }
            if (UI_STATE_FIELD != null) {
                return UI_STATE_FIELD.get(screen);
            }
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return null;
    }

    private static void invokeUpdateDimensions(Object state, int minY, int maxY) {
        try {
            if (UPDATE_DIMENSIONS_METHOD == null && (UPDATE_DIMENSIONS_METHOD = WorldHeightScreenHooks.findMethod(state.getClass(), "updateDimensions", 1)) != null) {
                UPDATE_DIMENSIONS_METHOD.setAccessible(true);
                DIMENSIONS_UPDATER_CLASS = UPDATE_DIMENSIONS_METHOD.getParameterTypes()[0];
            }
            if (UPDATE_DIMENSIONS_METHOD == null || DIMENSIONS_UPDATER_CLASS == null || !DIMENSIONS_UPDATER_CLASS.isInterface()) {
                return;
            }
            Object updater = Proxy.newProxyInstance(DIMENSIONS_UPDATER_CLASS.getClassLoader(), new Class[]{DIMENSIONS_UPDATER_CLASS}, (proxy, method, args) -> {
                if (args != null && args.length == 2 && args[0] instanceof class_5455.class_6890 && args[1] instanceof class_7723) {
                    return WorldHeightScreenHooks.rebuildDimensions((class_5455.class_6890)args[0], (class_7723)args[1], minY, maxY);
                }
                return null;
            });
            UPDATE_DIMENSIONS_METHOD.invoke(state, updater);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }

    static {
        TAB_MANAGER_CLASS = WorldHeightScreenHooks.resolveTabManagerClass();
    }

    private static final class LabelWidget
    extends class_339 {
        private final int color;

        private LabelWidget(int x, int y, int width, int height, class_2561 message) {
            this(x, y, width, height, message, 0xFFFFFF);
        }

        private LabelWidget(int x, int y, int width, int height, class_2561 message, int color) {
            super(x, y, width, height, message);
            this.color = color;
            this.field_22763 = false;
        }

        public void method_25359(class_4587 poseStack, int mouseX, int mouseY, float delta) {
            class_327 font = class_310.method_1551().field_1772;
            font.method_30883(poseStack, this.method_25369(), (float)this.method_46426(), (float)this.method_46427(), this.color);
        }

        protected void method_47399(class_6382 narrationElementOutput) {
            narrationElementOutput.method_37034(class_6381.field_33788, this.method_25369());
        }
    }
}

