/*
 * Decompiled with CFR 0.152.
 */
package net.multiverse.dynamicheight.util;

import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.dimension.DimensionType;

public final class DimensionTypeUtil {
    private static final Method HOLDER_REFERENCE_BIND_METHOD = DimensionTypeUtil.locateHolderReferenceBindMethod();
    private static final Field MAPPED_REGISTRY_VALUE_TO_ID_FIELD = DimensionTypeUtil.locateMappedRegistryValueToIdField();

    private DimensionTypeUtil() {
    }

    public static DimensionType copyWithHeight(DimensionType base, int minY, int maxY) {
        int height = maxY - minY;
        return new DimensionType(base.fixedTime(), base.hasSkyLight(), base.hasCeiling(), base.ultraWarm(), base.natural(), base.coordinateScale(), base.bedWorks(), base.respawnAnchorWorks(), minY, height, Math.max(16, height), base.infiniburn(), base.effectsLocation(), base.ambientLight(), base.monsterSettings());
    }

    public static Holder<DimensionType> bindUpdatedDimensionType(RegistryAccess registryAccess, Holder<DimensionType> original, DimensionType updated) {
        Registry registry = registryAccess.lookupOrThrow(Registries.DIMENSION_TYPE);
        Holder.Reference targetReference = null;
        if (original instanceof Holder.Reference) {
            Holder.Reference reference;
            targetReference = reference = (Holder.Reference)original;
        } else {
            Optional key = original.unwrapKey();
            if (key.isPresent() && registry instanceof MappedRegistry) {
                MappedRegistry mapped = (MappedRegistry)registry;
                HolderGetter lookup = mapped.createRegistrationLookup();
                targetReference = lookup.get((ResourceKey)key.get()).orElse(null);
            }
        }
        if (targetReference != null) {
            DimensionType previous = (DimensionType)targetReference.value();
            DimensionTypeUtil.bindHolderReference(targetReference, updated);
            if (registry instanceof MappedRegistry) {
                MappedRegistry mapped = (MappedRegistry)registry;
                DimensionTypeUtil.updateMappedRegistryEntry(mapped, previous, updated, targetReference);
            }
            return targetReference;
        }
        return Holder.direct((Object)updated);
    }

    private static <T> void bindHolderReference(Holder.Reference<T> reference, T value) {
        try {
            HOLDER_REFERENCE_BIND_METHOD.invoke(reference, value);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Failed to bind updated registry value reflectively", e);
        }
    }

    private static Method locateHolderReferenceBindMethod() {
        for (Method method : Holder.Reference.class.getDeclaredMethods()) {
            if (Modifier.isStatic(method.getModifiers()) || method.getReturnType() != Void.TYPE || method.getParameterCount() != 1 || method.getParameterTypes()[0] != Object.class) continue;
            method.setAccessible(true);
            return method;
        }
        throw new IllegalStateException("Unable to locate Holder.Reference#bindValue equivalent");
    }

    private static Field locateMappedRegistryValueToIdField() {
        for (Class current = MappedRegistry.class; current != null && current != Object.class; current = current.getSuperclass()) {
            for (Field field : current.getDeclaredFields()) {
                if (!Reference2IntMap.class.isAssignableFrom(field.getType())) continue;
                field.setAccessible(true);
                return field;
            }
        }
        throw new IllegalStateException("Unable to locate MappedRegistry value-id map field");
    }

    private static <T> void updateMappedRegistryEntry(MappedRegistry<T> registry, T previous, T updated, Holder.Reference<T> reference) {
        if (previous == updated) {
            return;
        }
        Map<T, Holder.Reference<T>> valueMap = DimensionTypeUtil.findValueToHolderMap(registry, previous);
        if (valueMap != null) {
            valueMap.remove(previous);
            valueMap.put(updated, reference);
        }
        DimensionTypeUtil.rebuildIdMap(registry, previous, updated);
    }

    private static <T> Map<T, Holder.Reference<T>> findValueToHolderMap(MappedRegistry<T> registry, T probe) {
        for (Class<?> current = registry.getClass(); current != null && current != Object.class; current = current.getSuperclass()) {
            for (Field field : current.getDeclaredFields()) {
                if (!Map.class.isAssignableFrom(field.getType())) continue;
                field.setAccessible(true);
                try {
                    IdentityHashMap identity;
                    IdentityHashMap map;
                    Object raw = field.get(registry);
                    if (!(raw instanceof IdentityHashMap) || !(map = (identity = (IdentityHashMap)raw)).containsKey(probe)) continue;
                    return map;
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException("Failed to inspect registry value map reflectively", e);
                }
            }
        }
        return null;
    }

    private static <T> void rebuildIdMap(MappedRegistry<T> registry, T previous, T updated) {
        try {
            Reference2IntMap original = (Reference2IntMap)MAPPED_REGISTRY_VALUE_TO_ID_FIELD.get(registry);
            if (original == null || original.isEmpty()) {
                return;
            }
            Reference2IntOpenHashMap rebuilt = new Reference2IntOpenHashMap(original.size());
            rebuilt.defaultReturnValue(original.defaultReturnValue());
            for (Reference2IntMap.Entry entry : original.reference2IntEntrySet()) {
                Object key = entry.getKey();
                int value = entry.getIntValue();
                if (key == previous) {
                    key = updated;
                }
                rebuilt.put(key, value);
            }
            MAPPED_REGISTRY_VALUE_TO_ID_FIELD.set(registry, rebuilt);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Failed to rebuild registry id map reflectively", e);
        }
    }
}

