/*
 * Decompiled with CFR 0.152.
 */
package net.multiverse.dynamicheight.worldheight;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.saveddata.SavedData;
import net.multiverse.dynamicheight.worldheight.HeightValidator;
import net.multiverse.dynamicheight.worldheight.WorldHeightData;

public final class WorldHeightSavedData
extends SavedData {
    private static final String KEY_MIN = "MinY";
    private static final String KEY_MAX = "MaxY";
    private int minY;
    private int maxY;

    public WorldHeightSavedData() {
        this(-64, 135);
    }

    public WorldHeightSavedData(int minY, int maxY) {
        this.applyRangeInternal(HeightValidator.sanitize(minY, maxY));
    }

    public static SavedData.Factory<WorldHeightSavedData> factory(ResourceKey<Level> dimension, DimensionType dimensionType) {
        return new SavedData.Factory(() -> new WorldHeightSavedData(dimensionType.minY(), dimensionType.minY() + dimensionType.height()), WorldHeightSavedData::load, DataFixTypes.LEVEL);
    }

    public int minY() {
        return this.minY;
    }

    public int maxY() {
        return this.maxY;
    }

    public int height() {
        return this.maxY - this.minY;
    }

    public void update(WorldHeightData.Snapshot snapshot) {
        this.applyRange(snapshot.minY(), snapshot.maxY());
    }

    public boolean applyRange(int newMinY, int newMaxY) {
        return this.applyRangeInternal(HeightValidator.sanitize(newMinY, newMaxY));
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
        tag.putInt(KEY_MIN, this.minY);
        tag.putInt(KEY_MAX, this.maxY);
        return tag;
    }

    private boolean applyRangeInternal(HeightValidator.HeightRange range) {
        if (range.minY() == this.minY && range.maxY() == this.maxY) {
            return false;
        }
        this.minY = range.minY();
        this.maxY = range.maxY();
        this.setDirty();
        return true;
    }

    private static WorldHeightSavedData load(CompoundTag tag, HolderLookup.Provider provider) {
        int minY = tag.getInt(KEY_MIN);
        int maxY = tag.getInt(KEY_MAX);
        return new WorldHeightSavedData(minY, maxY);
    }

    public static String storageKey(ResourceKey<Level> dimension) {
        String path = dimension.location().getPath().replace('/', '_');
        return "dynamic_height_" + dimension.location().getNamespace() + "_" + path;
    }
}

