/*
 * Decompiled with CFR 0.152.
 */
package net.multiverse.dynamicheight.util;

import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2874;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7871;
import net.minecraft.class_7924;

public final class DimensionTypeUtil {
    private static final Method HOLDER_REFERENCE_BIND_METHOD = DimensionTypeUtil.locateHolderReferenceBindMethod();
    private static final Field MAPPED_REGISTRY_VALUE_TO_ID_FIELD = DimensionTypeUtil.locateMappedRegistryValueToIdField();

    private DimensionTypeUtil() {
    }

    public static class_2874 copyWithHeight(class_2874 base, int minY, int maxY) {
        int height = maxY - minY;
        return new class_2874(base.comp_641(), base.comp_642(), base.comp_643(), base.comp_644(), base.comp_645(), base.comp_646(), base.comp_648(), base.comp_649(), minY, height, Math.max(16, height), base.comp_654(), base.comp_655(), base.comp_656(), base.comp_4037(), base.comp_847());
    }

    public static class_6880<class_2874> bindUpdatedDimensionType(class_5455 registryAccess, class_6880<class_2874> original, class_2874 updated) {
        class_2378 registry = registryAccess.method_30530(class_7924.field_41241);
        class_6880.class_6883 targetReference = null;
        if (original instanceof class_6880.class_6883) {
            class_6880.class_6883 reference;
            targetReference = reference = (class_6880.class_6883)original;
        } else {
            Optional key = original.method_40230();
            if (key.isPresent() && registry instanceof class_2370) {
                class_2370 mapped = (class_2370)registry;
                class_7871 lookup = mapped.method_46769();
                targetReference = lookup.method_46746((class_5321)key.get()).orElse(null);
            }
        }
        if (targetReference != null) {
            class_2874 previous = (class_2874)targetReference.comp_349();
            DimensionTypeUtil.bindHolderReference(targetReference, updated);
            if (registry instanceof class_2370) {
                class_2370 mapped = (class_2370)registry;
                DimensionTypeUtil.updateMappedRegistryEntry(mapped, previous, updated, targetReference);
            }
            return targetReference;
        }
        return class_6880.method_40223((Object)updated);
    }

    private static <T> void bindHolderReference(class_6880.class_6883<T> reference, T value) {
        try {
            HOLDER_REFERENCE_BIND_METHOD.invoke(reference, value);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Failed to bind updated registry value reflectively", e);
        }
    }

    private static Method locateHolderReferenceBindMethod() {
        for (Method method : class_6880.class_6883.class.getDeclaredMethods()) {
            if (Modifier.isStatic(method.getModifiers()) || method.getReturnType() != Void.TYPE || method.getParameterCount() != 1 || method.getParameterTypes()[0] != Object.class) continue;
            method.setAccessible(true);
            return method;
        }
        throw new IllegalStateException("Unable to locate Holder.Reference#bindValue equivalent");
    }

    private static Field locateMappedRegistryValueToIdField() {
        for (Class current = class_2370.class; current != null && current != Object.class; current = current.getSuperclass()) {
            for (Field field : current.getDeclaredFields()) {
                if (!Reference2IntMap.class.isAssignableFrom(field.getType())) continue;
                field.setAccessible(true);
                return field;
            }
        }
        throw new IllegalStateException("Unable to locate MappedRegistry value-id map field");
    }

    private static <T> void updateMappedRegistryEntry(class_2370<T> registry, T previous, T updated, class_6880.class_6883<T> reference) {
        if (previous == updated) {
            return;
        }
        Map<T, class_6880.class_6883<T>> valueMap = DimensionTypeUtil.findValueToHolderMap(registry, previous);
        if (valueMap != null) {
            valueMap.remove(previous);
            valueMap.put(updated, reference);
        }
        DimensionTypeUtil.rebuildIdMap(registry, previous, updated);
    }

    private static <T> Map<T, class_6880.class_6883<T>> findValueToHolderMap(class_2370<T> registry, T probe) {
        for (Class<?> current = registry.getClass(); current != null && current != Object.class; current = current.getSuperclass()) {
            for (Field field : current.getDeclaredFields()) {
                if (!Map.class.isAssignableFrom(field.getType())) continue;
                field.setAccessible(true);
                try {
                    IdentityHashMap identity;
                    IdentityHashMap map;
                    Object raw = field.get(registry);
                    if (!(raw instanceof IdentityHashMap) || !(map = (identity = (IdentityHashMap)raw)).containsKey(probe)) continue;
                    return map;
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException("Failed to inspect registry value map reflectively", e);
                }
            }
        }
        return null;
    }

    private static <T> void rebuildIdMap(class_2370<T> registry, T previous, T updated) {
        try {
            Reference2IntMap original = (Reference2IntMap)MAPPED_REGISTRY_VALUE_TO_ID_FIELD.get(registry);
            if (original == null || original.isEmpty()) {
                return;
            }
            Reference2IntOpenHashMap rebuilt = new Reference2IntOpenHashMap(original.size());
            rebuilt.defaultReturnValue(original.defaultReturnValue());
            for (Reference2IntMap.Entry entry : original.reference2IntEntrySet()) {
                Object key = entry.getKey();
                int value = entry.getIntValue();
                if (key == previous) {
                    key = updated;
                }
                rebuilt.put(key, value);
            }
            MAPPED_REGISTRY_VALUE_TO_ID_FIELD.set(registry, rebuilt);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Failed to rebuild registry id map reflectively", e);
        }
    }
}

