/*
 * Decompiled with CFR 0.152.
 */
package net.multiverse.dynamicheight.worldheight;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_10741;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2874;
import net.minecraft.class_4284;
import net.minecraft.class_5321;
import net.multiverse.dynamicheight.worldheight.HeightValidator;
import net.multiverse.dynamicheight.worldheight.WorldHeightData;

public final class WorldHeightSavedData
extends class_18 {
    private static final String KEY_MIN = "MinY";
    private static final String KEY_MAX = "MaxY";
    private static final Codec<WorldHeightSavedData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf(KEY_MIN).forGetter(WorldHeightSavedData::minY), (App)Codec.INT.fieldOf(KEY_MAX).forGetter(WorldHeightSavedData::maxY)).apply((Applicative)instance, WorldHeightSavedData::new));
    private int minY;
    private int maxY;

    private static class_10741<WorldHeightSavedData> type(class_5321<class_1937> dimension, class_2874 dimensionType) {
        return new class_10741(WorldHeightSavedData.storageKey(dimension), context -> new WorldHeightSavedData(dimensionType.comp_651(), dimensionType.comp_651() + dimensionType.comp_652()), context -> CODEC, class_4284.field_19212);
    }

    public WorldHeightSavedData() {
        this(-64, 135);
    }

    public WorldHeightSavedData(int minY, int maxY) {
        this.applyRangeInternal(HeightValidator.sanitize(minY, maxY));
    }

    public static class_10741<WorldHeightSavedData> typeFor(class_5321<class_1937> dimension, class_2874 dimensionType) {
        return WorldHeightSavedData.type(dimension, dimensionType);
    }

    public int minY() {
        return this.minY;
    }

    public int maxY() {
        return this.maxY;
    }

    public int height() {
        return this.maxY - this.minY;
    }

    public void update(WorldHeightData.Snapshot snapshot) {
        this.applyRange(snapshot.minY(), snapshot.maxY());
    }

    public boolean applyRange(int newMinY, int newMaxY) {
        return this.applyRangeInternal(HeightValidator.sanitize(newMinY, newMaxY));
    }

    private boolean applyRangeInternal(HeightValidator.HeightRange range) {
        if (range.minY() == this.minY && range.maxY() == this.maxY) {
            return false;
        }
        this.minY = range.minY();
        this.maxY = range.maxY();
        this.method_80();
        return true;
    }

    private static String storageKey(class_5321<class_1937> dimension) {
        String path = dimension.method_29177().method_12832().replace('/', '_');
        return "dynamic_height_" + dimension.method_29177().method_12836() + "_" + path;
    }
}

