/*
 * Decompiled with CFR 0.152.
 */
package net.multiverse.dynamicheight.worldheight;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.dimension.DimensionType;
import net.multiverse.dynamicheight.network.WorldHeightNetwork;
import net.multiverse.dynamicheight.util.DimensionTypeUtil;
import net.multiverse.dynamicheight.worldheight.HeightValidator;
import net.multiverse.dynamicheight.worldheight.WorldHeightData;
import net.multiverse.dynamicheight.worldheight.WorldHeightSavedData;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.LevelEvent;

public final class WorldHeightManager {
    private static final Map<ResourceKey<Level>, WorldHeightSavedData> BY_DIMENSION = new ConcurrentHashMap<ResourceKey<Level>, WorldHeightSavedData>();

    private WorldHeightManager() {
    }

    public static void onLevelLoad(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        WorldHeightSavedData data = WorldHeightManager.getData(level);
        if (level.dimension().equals(Level.OVERWORLD) && WorldHeightData.hasPendingClientSelection()) {
            data.update(WorldHeightData.consumeSnapshot());
        }
        WorldHeightManager.applyDimensionSettings(level, data);
    }

    public static void onLevelUnload(LevelEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            BY_DIMENSION.remove(level.dimension());
        }
    }

    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        WorldHeightSavedData data = WorldHeightManager.getData(level2);
        BlockPos target = event.getPos().relative(event.getFace());
        int y = target.getY();
        if (y < data.minY() || y >= data.maxY()) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.displayClientMessage((Component)Component.literal((String)("Cannot place blocks outside the configured vertical range (" + data.minY() + " .. " + (data.maxY() - 1) + ") in " + String.valueOf(level2.dimension().location()))).withStyle(ChatFormatting.RED), true);
            }
            event.setCancellationResult((InteractionResult)InteractionResult.FAIL);
            event.setCanceled(true);
        }
    }

    public static void applyClientSelection(ServerPlayer player, WorldHeightData.Snapshot snapshot) {
        MinecraftServer server = player.level().getServer();
        if (server == null) {
            return;
        }
        HeightValidator.HeightRange range = HeightValidator.sanitize(snapshot.minY(), snapshot.maxY());
        WorldHeightData.Snapshot sanitized = new WorldHeightData.Snapshot(range.minY(), range.maxY());
        for (ServerLevel level : server.getAllLevels()) {
            WorldHeightSavedData data = WorldHeightManager.getData(level);
            data.update(sanitized);
            WorldHeightManager.applyDimensionSettings(level, data);
        }
    }

    public static WorldHeightSavedData currentData(ServerLevel level) {
        return WorldHeightManager.getData(level);
    }

    private static WorldHeightSavedData getData(ServerLevel level) {
        return BY_DIMENSION.compute((ResourceKey<Level>)level.dimension(), (key, existing) -> {
            if (existing != null) {
                return existing;
            }
            WorldHeightSavedData loaded = (WorldHeightSavedData)level.getDataStorage().computeIfAbsent(WorldHeightSavedData.typeFor((ResourceKey<Level>)level.dimension(), level.dimensionType()));
            return loaded;
        });
    }

    private static void applyDimensionSettings(ServerLevel level, WorldHeightSavedData data) {
        Holder holder = level.dimensionTypeRegistration();
        DimensionType current = (DimensionType)holder.value();
        if (current.minY() != data.minY() || current.height() != data.height()) {
            DimensionType updated = DimensionTypeUtil.copyWithHeight(current, data.minY(), data.maxY());
            DimensionTypeUtil.bindUpdatedDimensionType(level.registryAccess(), (Holder<DimensionType>)holder, updated);
        }
        WorldHeightNetwork.broadcast(level, data);
    }
}

