/*
 * Decompiled with CFR 0.152.
 */
package net.multiverse.dynamicheight.network;

import java.util.concurrent.atomic.AtomicBoolean;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.multiverse.dynamicheight.client.ClientDimensionHeights;
import net.multiverse.dynamicheight.network.WorldHeightAppliedPayload;
import net.multiverse.dynamicheight.network.WorldHeightSyncPayload;
import net.multiverse.dynamicheight.worldheight.WorldHeightData;
import net.multiverse.dynamicheight.worldheight.WorldHeightManager;
import net.multiverse.dynamicheight.worldheight.WorldHeightSavedData;

public final class WorldHeightNetwork {
    private static final AtomicBoolean PAYLOADS_REGISTERED = new AtomicBoolean(false);

    private WorldHeightNetwork() {
    }

    private static void registerPayloadTypes() {
        if (PAYLOADS_REGISTERED.compareAndSet(false, true)) {
            PayloadTypeRegistry.playC2S().register(WorldHeightSyncPayload.TYPE, WorldHeightSyncPayload.CODEC);
            PayloadTypeRegistry.playS2C().register(WorldHeightAppliedPayload.TYPE, WorldHeightAppliedPayload.CODEC);
        }
    }

    public static void registerServer() {
        WorldHeightNetwork.registerPayloadTypes();
        ServerPlayNetworking.registerGlobalReceiver(WorldHeightSyncPayload.TYPE, WorldHeightNetwork::handleSyncFromClient);
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_3222 player = handler.field_14140;
            class_3218 level = player.method_51469();
            WorldHeightNetwork.sendCurrentRange(player, level);
        });
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> {
            if (entity instanceof class_3222) {
                class_3222 player = (class_3222)entity;
                if (world instanceof class_3218) {
                    class_3218 level = world;
                    WorldHeightNetwork.sendCurrentRange(player, level);
                }
            }
        });
    }

    public static void registerClient() {
        WorldHeightNetwork.registerPayloadTypes();
        ClientPlayNetworking.registerGlobalReceiver(WorldHeightAppliedPayload.TYPE, WorldHeightNetwork::handleAppliedOnClient);
    }

    public static void sendCurrentRange(class_3222 player, class_3218 level) {
        WorldHeightSavedData data = WorldHeightManager.currentData(level);
        ServerPlayNetworking.send((class_3222)player, (class_8710)new WorldHeightAppliedPayload(level.method_27983().method_29177(), data.minY(), data.maxY()));
    }

    public static void broadcast(class_3218 level, WorldHeightSavedData data) {
        for (class_3222 player : level.method_18456()) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)new WorldHeightAppliedPayload(level.method_27983().method_29177(), data.minY(), data.maxY()));
        }
    }

    private static void handleSyncFromClient(WorldHeightSyncPayload payload, ServerPlayNetworking.Context context) {
        class_3222 player = context.player();
        class_3218 level = player.method_51469();
        level.method_8503().execute(() -> {
            WorldHeightData.updateFromClient(payload.minY(), payload.maxY());
            WorldHeightManager.applyClientSelection(player, WorldHeightData.consumeSnapshot());
            WorldHeightNetwork.sendCurrentRange(player, level);
        });
    }

    private static void handleAppliedOnClient(WorldHeightAppliedPayload payload, ClientPlayNetworking.Context context) {
        context.client().execute(() -> {
            WorldHeightData.applyServerRange(payload.minY(), payload.maxY());
            ClientDimensionHeights.remember(payload.dimension(), payload.minY(), payload.maxY());
        });
    }
}

