/*
 * Decompiled with CFR 0.152.
 */
package net.multiverse.dynamicheight.worldheight;

public final class HeightValidator {
    public static final int INPUT_STEP = 16;
    public static final int CHUNK_ALIGNMENT = 16;
    public static final int ABS_MIN_Y = -2016;
    public static final int ABS_MAX_Y = 2016;
    public static final int DEFAULT_MIN_Y = -2016;
    public static final int DEFAULT_MAX_Y = 2016;

    private HeightValidator() {
    }

    public static HeightRange sanitize(int minCandidate, int maxCandidate) {
        int min = HeightValidator.sanitizeMin(minCandidate);
        int max = HeightValidator.sanitizeMax(min, maxCandidate);
        return new HeightRange(min, max);
    }

    public static int sanitizeMin(int value) {
        int maxMin = 2001;
        int clamped = Math.max(-2016, Math.min(value, maxMin));
        int snapped = HeightValidator.snapToNearestMultiple(clamped, 16);
        if (snapped > maxMin) {
            snapped = HeightValidator.snapDownToMultiple(maxMin, 16);
        }
        if (snapped < -2016) {
            snapped = -2016;
        }
        return snapped;
    }

    public static int sanitizeMax(int min, int value) {
        int maxHeight;
        int height;
        int maxAllowed = 2016;
        int minAllowed = min + 15;
        int clamped = Math.max(minAllowed, Math.min(value, maxAllowed));
        if ((clamped = HeightValidator.snapToNearestMultiple(clamped, 16)) < minAllowed) {
            clamped = minAllowed;
        }
        if ((height = HeightValidator.snapToNearestMultiple(clamped - min + 1, 16)) < 16) {
            height = 16;
        }
        if (height > (maxHeight = HeightValidator.snapDownToMultiple(maxAllowed - min + 1, 16))) {
            height = maxHeight;
        }
        int candidateMax = min + height - 1;
        return Math.min(candidateMax, maxAllowed);
    }

    private static int snapDownToMultiple(int value, int multiple) {
        return Math.floorDiv(value, multiple) * multiple;
    }

    private static int snapToNearestMultiple(int value, int multiple) {
        return Math.round((float)value / (float)multiple) * multiple;
    }

    private static int snapUpToMultiple(int value, int multiple) {
        return Math.floorDiv(value + multiple - 1, multiple) * multiple;
    }

    public record HeightRange(int minY, int maxY) {
        public int height() {
            return this.maxY - this.minY + 1;
        }
    }
}

