/*
 * Decompiled with CFR 0.152.
 */
package net.multiverse.dynamicheight.network;

import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.multiverse.dynamicheight.worldheight.WorldHeightData;
import net.multiverse.dynamicheight.worldheight.WorldHeightManager;
import net.multiverse.dynamicheight.worldheight.WorldHeightSavedData;

public final class WorldHeightNetwork {
    public static final class_2960 SYNC_CHANNEL = new class_2960("dynamicheight", "sync");
    public static final class_2960 APPLIED_CHANNEL = new class_2960("dynamicheight", "applied");

    private WorldHeightNetwork() {
    }

    public static void register() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SYNC_CHANNEL, (server, player, handler, buf, responseSender) -> {
            int minY = buf.readInt();
            int maxY = buf.readInt();
            server.execute(() -> {
                WorldHeightData.updateFromClient(minY, maxY);
                WorldHeightManager.applyClientSelection(player, WorldHeightData.consumeSnapshot());
                WorldHeightNetwork.sendCurrentRange(player, WorldHeightNetwork.levelFor(player));
            });
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> WorldHeightNetwork.sendCurrentRange(handler.field_14140, WorldHeightNetwork.levelFor(handler.field_14140)));
        ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD.register((player, origin, destination) -> WorldHeightNetwork.sendCurrentRange(player, destination));
    }

    public static void sendClientSelection(class_3222 player, int minY, int maxY) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(minY);
        buf.writeInt(maxY);
        ServerPlayNetworking.send((class_3222)player, (class_2960)SYNC_CHANNEL, (class_2540)buf);
    }

    public static void sendCurrentRange(class_3222 player, class_3218 level) {
        WorldHeightSavedData data = WorldHeightManager.currentData(level);
        class_2540 buf = PacketByteBufs.create();
        buf.method_10812(level.method_27983().method_29177());
        buf.writeInt(data.minY());
        buf.writeInt(data.maxY());
        ServerPlayNetworking.send((class_3222)player, (class_2960)APPLIED_CHANNEL, (class_2540)buf);
    }

    public static void broadcast(class_3218 level, WorldHeightSavedData data) {
        for (class_3222 player : level.method_18456()) {
            class_2540 buf = PacketByteBufs.create();
            buf.method_10812(level.method_27983().method_29177());
            buf.writeInt(data.minY());
            buf.writeInt(data.maxY());
            ServerPlayNetworking.send((class_3222)player, (class_2960)APPLIED_CHANNEL, (class_2540)buf);
        }
    }

    private static class_3218 levelFor(class_3222 player) {
        return (class_3218)player.method_5770();
    }
}

