/*
 * Decompiled with CFR 0.152.
 */
package net.multiverse.dynamicheight.client;

import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_525;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.multiverse.dynamicheight.client.WorldHeightSettings;
import net.multiverse.dynamicheight.mixin.ScreenInvoker;

public final class WorldHeightScreenHooks {
    private static final class_2561 HEADER = class_2561.method_43470((String)"Custom Height Settings");
    private static final class_2561 FLOOR_LABEL = class_2561.method_43470((String)"Floor (min Y)");
    private static final class_2561 CEILING_LABEL = class_2561.method_43470((String)"Ceiling (max Y)");
    private static LabelWidget minLabel;
    private static LabelWidget maxLabel;
    private static class_342 minBox;
    private static class_342 maxBox;
    private static class_4185 resetButton;

    private WorldHeightScreenHooks() {
    }

    public static void register() {
        ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            if (screen instanceof class_525) {
                class_525 createWorldScreen = (class_525)screen;
                WorldHeightScreenHooks.onInit(createWorldScreen);
            } else {
                WorldHeightScreenHooks.clearWidgets();
            }
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1755 instanceof class_525) {
                WorldHeightScreenHooks.updateFieldValues();
            }
        });
    }

    private static void clearWidgets() {
        minLabel = null;
        maxLabel = null;
        minBox = null;
        maxBox = null;
        resetButton = null;
    }

    private static void onInit(class_525 screen) {
        WorldHeightScreenHooks.clearWidgets();
        int panelWidth = 220;
        int panelX = 20;
        int fieldWidth = panelWidth * 2 / 5;
        int startY = 20;
        resetButton = new class_4185(panelX, startY, panelWidth, 20, HEADER, button -> {
            WorldHeightSettings.resetToDefaults();
            WorldHeightScreenHooks.updateFieldValues();
        });
        WorldHeightScreenHooks.addWidget(screen, (class_339)resetButton);
        int rowY = startY + 28;
        minLabel = new LabelWidget(panelX, rowY, fieldWidth, 10, FLOOR_LABEL);
        WorldHeightScreenHooks.addWidget(screen, minLabel);
        minBox = new class_342(class_310.method_1551().field_1772, panelX, rowY += 12, fieldWidth, 20, FLOOR_LABEL);
        minBox.method_1852(Integer.toString(WorldHeightSettings.getMinY()));
        minBox.method_1890(WorldHeightScreenHooks::allowIntegerInput);
        minBox.method_1863(value -> {
            Integer parsed = WorldHeightScreenHooks.parseInt(value);
            if (parsed != null) {
                WorldHeightSettings.setMinY(parsed);
                WorldHeightScreenHooks.updateFieldValues();
            }
        });
        WorldHeightScreenHooks.addWidget(screen, (class_339)minBox);
        maxLabel = new LabelWidget(panelX, rowY += 28, fieldWidth, 10, CEILING_LABEL);
        WorldHeightScreenHooks.addWidget(screen, maxLabel);
        maxBox = new class_342(class_310.method_1551().field_1772, panelX, rowY += 12, fieldWidth, 20, CEILING_LABEL);
        maxBox.method_1852(Integer.toString(WorldHeightSettings.getMaxY()));
        maxBox.method_1890(WorldHeightScreenHooks::allowIntegerInput);
        maxBox.method_1863(value -> {
            Integer parsed = WorldHeightScreenHooks.parseInt(value);
            if (parsed != null) {
                WorldHeightSettings.setMaxY(parsed);
                WorldHeightScreenHooks.updateFieldValues();
            }
        });
        WorldHeightScreenHooks.addWidget(screen, (class_339)maxBox);
    }

    private static void updateFieldValues() {
        String desired;
        if (minBox != null && !minBox.method_25370() && !(desired = Integer.toString(WorldHeightSettings.getMinY())).equals(minBox.method_1882())) {
            minBox.method_1852(desired);
        }
        if (maxBox != null && !maxBox.method_25370() && !(desired = Integer.toString(WorldHeightSettings.getMaxY())).equals(maxBox.method_1882())) {
            maxBox.method_1852(desired);
        }
    }

    private static boolean allowIntegerInput(String value) {
        if (value == null || value.isEmpty() || "-".equals(value)) {
            return true;
        }
        return WorldHeightScreenHooks.parseInt(value) != null;
    }

    private static Integer parseInt(String value) {
        if (value == null || value.isEmpty() || "-".equals(value)) {
            return null;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static void addWidget(class_525 screen, class_339 widget) {
        ((ScreenInvoker)screen).dynamicheight$addRenderableWidget(widget);
    }

    private static final class LabelWidget
    extends class_339 {
        private final int color;

        private LabelWidget(int x, int y, int width, int height, class_2561 message) {
            this(x, y, width, height, message, 0xFFFFFF);
        }

        private LabelWidget(int x, int y, int width, int height, class_2561 message, int color) {
            super(x, y, width, height, message);
            this.color = color;
            this.field_22763 = false;
        }

        public void method_25359(class_4587 poseStack, int mouseX, int mouseY, float delta) {
            class_327 font = class_310.method_1551().field_1772;
            font.method_30883(poseStack, this.method_25369(), (float)this.field_22760, (float)this.field_22761, this.color);
        }

        public void method_37020(class_6382 narrationElementOutput) {
            narrationElementOutput.method_37034(class_6381.field_33788, this.method_25369());
        }
    }
}

