/*
 * Decompiled with CFR 0.152.
 */
package net.multiverse.dynamicheight.client;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.multiverse.dynamicheight.client.WorldHeightSettings;

public final class WorldHeightScreenHooks {
    private static final Component HEADER = Component.m_237113_((String)"Custom Height Settings");
    private static final Component FLOOR_LABEL = Component.m_237113_((String)"Floor (min Y)");
    private static final Component CEILING_LABEL = Component.m_237113_((String)"Ceiling (max Y)");
    private static LabelWidget minLabel;
    private static LabelWidget maxLabel;
    private static EditBox minBox;
    private static EditBox maxBox;
    private static Button resetButton;

    private WorldHeightScreenHooks() {
    }

    public static void register() {
        MinecraftForge.EVENT_BUS.addListener(WorldHeightScreenHooks::onInit);
        MinecraftForge.EVENT_BUS.addListener(WorldHeightScreenHooks::onRender);
    }

    private static void onInit(ScreenEvent.Init.Post event) {
        Screen screen = event.getScreen();
        if (!(screen instanceof CreateWorldScreen)) {
            return;
        }
        CreateWorldScreen createWorldScreen = (CreateWorldScreen)screen;
        minLabel = null;
        maxLabel = null;
        minBox = null;
        maxBox = null;
        resetButton = null;
        int panelWidth = 220;
        int panelX = 20;
        int fieldWidth = panelWidth * 2 / 5;
        int startY = 20;
        Font font = Minecraft.m_91087_().f_91062_;
        resetButton = Button.m_253074_((Component)HEADER, button -> {
            WorldHeightSettings.resetToDefaults();
            WorldHeightScreenHooks.refreshBoxes(createWorldScreen);
            WorldHeightScreenHooks.applySelection(createWorldScreen);
        }).m_252987_(panelX, startY, panelWidth, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Reset to the default overworld height"))).m_253136_();
        event.addListener((GuiEventListener)resetButton);
        int rowY = startY + 28;
        minLabel = new LabelWidget(panelX, rowY, fieldWidth, 10, FLOOR_LABEL, font);
        event.addListener((GuiEventListener)minLabel);
        minBox = new EditBox(font, panelX, rowY += 12, fieldWidth, 20, FLOOR_LABEL);
        minBox.m_94144_(Integer.toString(WorldHeightSettings.getMinY()));
        minBox.m_94153_(WorldHeightScreenHooks::allowIntegerInput);
        minBox.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Clamped to multiples of 16 down to vanilla minimum (-64).")));
        minBox.m_94151_(value -> {
            Integer parsed = WorldHeightScreenHooks.parseInt(value);
            if (parsed != null) {
                WorldHeightSettings.setMinY(parsed);
                WorldHeightScreenHooks.applySelection(createWorldScreen);
            }
        });
        event.addListener((GuiEventListener)minBox);
        maxLabel = new LabelWidget(panelX, rowY += 28, fieldWidth, 10, CEILING_LABEL, font);
        event.addListener((GuiEventListener)maxLabel);
        maxBox = new EditBox(font, panelX, rowY += 12, fieldWidth, 20, CEILING_LABEL);
        maxBox.m_94144_(Integer.toString(WorldHeightSettings.getMaxY()));
        maxBox.m_94153_(WorldHeightScreenHooks::allowIntegerInput);
        maxBox.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Snaps to 16-block steps and never below vanilla ceiling.")));
        maxBox.m_94151_(value -> {
            Integer parsed = WorldHeightScreenHooks.parseInt(value);
            if (parsed != null) {
                WorldHeightSettings.setMaxY(parsed);
                WorldHeightScreenHooks.applySelection(createWorldScreen);
            }
        });
        event.addListener((GuiEventListener)maxBox);
        WorldHeightScreenHooks.applySelection(createWorldScreen);
        WorldHeightScreenHooks.refreshBoxes(createWorldScreen);
    }

    private static void onRender(ScreenEvent.Render.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof CreateWorldScreen) {
            CreateWorldScreen createWorldScreen = (CreateWorldScreen)screen;
            WorldHeightScreenHooks.refreshBoxes(createWorldScreen);
        }
    }

    private static void refreshBoxes(CreateWorldScreen screen) {
        if (resetButton != null) {
            WorldHeightScreenHooks.resetButton.f_93624_ = true;
            WorldHeightScreenHooks.resetButton.f_93623_ = true;
        }
        if (minBox != null) {
            if (!minBox.m_93696_()) {
                minBox.m_94144_(Integer.toString(WorldHeightSettings.getMinY()));
            }
            WorldHeightScreenHooks.minBox.f_93624_ = true;
            WorldHeightScreenHooks.minBox.f_93623_ = true;
        }
        if (maxBox != null) {
            if (!maxBox.m_93696_()) {
                maxBox.m_94144_(Integer.toString(WorldHeightSettings.getMaxY()));
            }
            WorldHeightScreenHooks.maxBox.f_93624_ = true;
            WorldHeightScreenHooks.maxBox.f_93623_ = true;
        }
    }

    private static boolean allowIntegerInput(String value) {
        return value == null || value.isEmpty() || "-".equals(value) || WorldHeightScreenHooks.parseInt(value) != null;
    }

    private static Integer parseInt(String value) {
        if (value == null || value.isEmpty() || "-".equals(value)) {
            return null;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static void applySelection(CreateWorldScreen screen) {
    }

    private static final class LabelWidget
    extends AbstractWidget {
        private final Font font;

        private LabelWidget(int x, int y, int width, int height, Component message, Font font) {
            super(x, y, width, height, message);
            this.font = font;
            this.f_93623_ = false;
        }

        public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            this.font.m_92889_(poseStack, this.m_6035_(), (float)this.m_252754_(), (float)this.m_252907_(), 0xFFFFFF);
        }

        protected void m_168797_(NarrationElementOutput output) {
        }
    }
}

