/*
 * Decompiled with CFR 0.152.
 */
package net.multiverse.dynamicheight.worldheight;

import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2874;
import net.multiverse.dynamicheight.worldheight.HeightValidator;
import net.multiverse.dynamicheight.worldheight.WorldHeightData;

public final class WorldHeightSavedData
extends class_18 {
    private static final String KEY_MIN = "MinY";
    private static final String KEY_MAX = "MaxY";
    private int minY;
    private int maxY;

    public WorldHeightSavedData() {
        this(-64, 135);
    }

    public WorldHeightSavedData(int minY, int maxY) {
        HeightValidator.HeightRange range = HeightValidator.sanitize(minY, maxY);
        this.minY = range.minY();
        this.maxY = range.maxY();
    }

    public static WorldHeightSavedData createFromDimension(class_2874 type) {
        int min = type.method_29959();
        int max = min + type.method_32924();
        return new WorldHeightSavedData(min, max);
    }

    public static WorldHeightSavedData load(class_2487 tag, class_2874 type) {
        int min = tag.method_10545(KEY_MIN) ? tag.method_10550(KEY_MIN) : type.method_29959();
        int max = tag.method_10545(KEY_MAX) ? tag.method_10550(KEY_MAX) : type.method_29959() + type.method_32924();
        return new WorldHeightSavedData(min, max);
    }

    public class_2487 method_75(class_2487 tag) {
        tag.method_10569(KEY_MIN, this.minY);
        tag.method_10569(KEY_MAX, this.maxY);
        return tag;
    }

    public int minY() {
        return this.minY;
    }

    public int maxY() {
        return this.maxY;
    }

    public int height() {
        return this.maxY - this.minY;
    }

    public void update(WorldHeightData.Snapshot snapshot) {
        HeightValidator.HeightRange range = HeightValidator.sanitize(snapshot.minY(), snapshot.maxY());
        this.minY = range.minY();
        this.maxY = range.maxY();
        this.method_80();
    }
}

