/*
 * Decompiled with CFR 0.152.
 */
package net.multiverse.dynamicheight.client;

import com.mojang.serialization.Lifecycle;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.minecraft.class_2370;
import net.minecraft.class_2561;
import net.minecraft.class_2874;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_525;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7723;
import net.minecraft.class_7842;
import net.minecraft.class_7919;
import net.minecraft.class_7924;
import net.minecraft.class_8088;
import net.minecraft.class_8100;
import net.multiverse.dynamicheight.client.WorldHeightSettings;
import net.multiverse.dynamicheight.mixin.ScreenInvoker;
import net.multiverse.dynamicheight.util.DimensionTypeUtil;

public final class WorldHeightScreenHooks {
    private static final class_2561 HEADER = class_2561.method_43470((String)"Custom Height Settings");
    private static final class_2561 FLOOR_LABEL = class_2561.method_43470((String)"Floor (min Y)");
    private static final class_2561 CEILING_LABEL = class_2561.method_43470((String)"Ceiling (max Y)");
    private static class_7842 minLabel;
    private static class_7842 maxLabel;
    private static class_342 minBox;
    private static class_342 maxBox;
    private static class_4185 resetButton;
    private static Field TAB_MANAGER_FIELD;
    private static Method TAB_MANAGER_METHOD;

    private WorldHeightScreenHooks() {
    }

    public static void register() {
        ScreenEvents.AFTER_INIT.register((client, screen, width, height) -> {
            if (screen instanceof class_525) {
                class_525 createWorldScreen = (class_525)screen;
                WorldHeightScreenHooks.onInit(createWorldScreen);
            } else {
                WorldHeightScreenHooks.clearWidgets();
            }
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            class_437 patt0$temp = client.field_1755;
            if (patt0$temp instanceof class_525) {
                class_525 screen = (class_525)patt0$temp;
                WorldHeightScreenHooks.refreshBoxes(screen);
            }
        });
    }

    private static void clearWidgets() {
        minLabel = null;
        maxLabel = null;
        minBox = null;
        maxBox = null;
        resetButton = null;
    }

    private static void onInit(class_525 screen) {
        WorldHeightScreenHooks.clearWidgets();
        int panelWidth = 220;
        int panelX = 20;
        int fieldWidth = panelWidth * 2 / 5;
        int startY = 20;
        resetButton = class_4185.method_46430((class_2561)HEADER, button -> {
            WorldHeightSettings.resetToDefaults();
            WorldHeightScreenHooks.refreshBoxes(screen);
            WorldHeightScreenHooks.applySelection(screen);
        }).method_46434(panelX, startY, panelWidth, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Reset to the default overworld height"))).method_46431();
        WorldHeightScreenHooks.addWidget(screen, (class_339)resetButton);
        int rowY = startY + 28;
        minLabel = new class_7842(panelX, rowY, fieldWidth, 10, FLOOR_LABEL, class_310.method_1551().field_1772);
        WorldHeightScreenHooks.addWidget(screen, (class_339)minLabel);
        minBox = new class_342(class_310.method_1551().field_1772, panelX, rowY += 12, fieldWidth, 20, FLOOR_LABEL);
        minBox.method_1852(Integer.toString(WorldHeightSettings.getMinY()));
        minBox.method_1890(WorldHeightScreenHooks::allowIntegerInput);
        minBox.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Must be divisible by 16; allowed roughly -2016 to 2015.")));
        minBox.method_1863(value -> {
            Integer parsed = WorldHeightScreenHooks.parseInt(value);
            if (parsed != null) {
                WorldHeightSettings.setMinY(parsed);
                WorldHeightScreenHooks.applySelection(screen);
            }
        });
        WorldHeightScreenHooks.addWidget(screen, (class_339)minBox);
        maxLabel = new class_7842(panelX, rowY += 28, fieldWidth, 10, CEILING_LABEL, class_310.method_1551().field_1772);
        WorldHeightScreenHooks.addWidget(screen, (class_339)maxLabel);
        maxBox = new class_342(class_310.method_1551().field_1772, panelX, rowY += 12, fieldWidth, 20, CEILING_LABEL);
        maxBox.method_1852(Integer.toString(WorldHeightSettings.getMaxY()));
        maxBox.method_1890(WorldHeightScreenHooks::allowIntegerInput);
        maxBox.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Must be divisible by 16; height stays a multiple of 16 (max practical top is 2015).")));
        maxBox.method_1863(value -> {
            Integer parsed = WorldHeightScreenHooks.parseInt(value);
            if (parsed != null) {
                WorldHeightSettings.setMaxY(parsed);
                WorldHeightScreenHooks.applySelection(screen);
            }
        });
        WorldHeightScreenHooks.addWidget(screen, (class_339)maxBox);
        WorldHeightScreenHooks.applySelection(screen);
        WorldHeightScreenHooks.refreshBoxes(screen);
    }

    private static void refreshBoxes(class_525 screen) {
        boolean visible = true;
        if (resetButton != null) {
            WorldHeightScreenHooks.resetButton.field_22764 = visible;
            WorldHeightScreenHooks.resetButton.field_22763 = visible;
        }
        if (minLabel != null) {
            WorldHeightScreenHooks.minLabel.field_22764 = visible;
        }
        if (maxLabel != null) {
            WorldHeightScreenHooks.maxLabel.field_22764 = visible;
        }
        if (minBox != null) {
            if (!minBox.method_25370()) {
                minBox.method_1852(Integer.toString(WorldHeightSettings.getMinY()));
            }
            WorldHeightScreenHooks.minBox.field_22764 = visible;
            WorldHeightScreenHooks.minBox.field_22763 = visible;
        }
        if (maxBox != null) {
            if (!maxBox.method_25370()) {
                maxBox.method_1852(Integer.toString(WorldHeightSettings.getMaxY()));
            }
            WorldHeightScreenHooks.maxBox.field_22764 = visible;
            WorldHeightScreenHooks.maxBox.field_22763 = visible;
        }
    }

    private static void applySelection(class_525 screen) {
        class_8100 state = screen.method_48657();
        state.method_48700((registryAccess, dimensions) -> WorldHeightScreenHooks.rebuildDimensions(registryAccess, dimensions, WorldHeightSettings.getMinY(), WorldHeightSettings.getMaxY()));
    }

    private static class_7723 rebuildDimensions(class_5455.class_6890 registryAccess, class_7723 existing, int minY, int maxY) {
        class_2370 rebuilt = new class_2370(class_7924.field_41224, Lifecycle.stable());
        existing.comp_1014().method_29722().forEach(entry -> rebuilt.method_10272((class_5321)entry.getKey(), (Object)WorldHeightScreenHooks.rebuildStem((class_5455)registryAccess, (class_5363)entry.getValue(), minY, maxY), Lifecycle.stable()));
        return new class_7723(rebuilt.method_40276());
    }

    private static class_5363 rebuildStem(class_5455 registryAccess, class_5363 stem, int minY, int maxY) {
        class_2874 updated = DimensionTypeUtil.copyWithHeight((class_2874)stem.comp_1012().comp_349(), minY, maxY);
        class_6880<class_2874> updatedHolder = DimensionTypeUtil.bindUpdatedDimensionType(registryAccess, (class_6880<class_2874>)stem.comp_1012(), updated);
        return new class_5363(updatedHolder, stem.comp_1013());
    }

    private static boolean isWorldTabActive(class_525 screen) {
        Object manager = WorldHeightScreenHooks.resolveTabManager(screen);
        if (manager == null) {
            return true;
        }
        try {
            Method getCurrentTab = manager.getClass().getMethod("getCurrentTab", new Class[0]);
            Object current = getCurrentTab.invoke(manager, new Object[0]);
            if (current == null) {
                return true;
            }
            String simpleName = current.getClass().getSimpleName();
            if (simpleName.contains("WorldTab")) {
                return true;
            }
            Package pkg = current.getClass().getPackage();
            return pkg != null && pkg.getName().contains("worldselection");
        }
        catch (ReflectiveOperationException ignored) {
            return true;
        }
    }

    private static Object resolveTabManager(class_525 screen) {
        try {
            if (TAB_MANAGER_FIELD == null && (TAB_MANAGER_FIELD = WorldHeightScreenHooks.findFieldWithType(screen.getClass(), class_8088.class)) != null) {
                TAB_MANAGER_FIELD.setAccessible(true);
            }
            if (TAB_MANAGER_FIELD != null) {
                return TAB_MANAGER_FIELD.get(screen);
            }
            if (TAB_MANAGER_METHOD == null && (TAB_MANAGER_METHOD = WorldHeightScreenHooks.findZeroArgMethodReturning(screen.getClass(), class_8088.class)) != null) {
                TAB_MANAGER_METHOD.setAccessible(true);
            }
            if (TAB_MANAGER_METHOD != null) {
                return TAB_MANAGER_METHOD.invoke((Object)screen, new Object[0]);
            }
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return null;
    }

    private static Field findFieldWithType(Class<?> owner, Class<?> type) {
        for (Class<?> current = owner; current != null && current != Object.class; current = current.getSuperclass()) {
            for (Field field : current.getDeclaredFields()) {
                if (field.getType() != type) continue;
                return field;
            }
        }
        return null;
    }

    private static Method findZeroArgMethodReturning(Class<?> owner, Class<?> type) {
        for (Class<?> current = owner; current != null && current != Object.class; current = current.getSuperclass()) {
            for (Method method : current.getDeclaredMethods()) {
                if (method.getParameterCount() != 0 || method.getReturnType() != type) continue;
                return method;
            }
        }
        return null;
    }

    private static void addWidget(class_525 screen, class_339 widget) {
        ScreenInvoker invoker = (ScreenInvoker)screen;
        invoker.dynamicheight$addRenderableWidget(widget);
    }

    private static boolean allowIntegerInput(String value) {
        if (value.isEmpty() || "-".equals(value)) {
            return true;
        }
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static Integer parseInt(String value) {
        if (value == null || value.isBlank()) {
            return null;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

