/*
 * Decompiled with CFR 0.152.
 */
package net.multiverse.dynamicheight.worldheight;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2874;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.server.MinecraftServer;
import net.multiverse.dynamicheight.network.WorldHeightNetwork;
import net.multiverse.dynamicheight.util.DimensionTypeUtil;
import net.multiverse.dynamicheight.worldheight.HeightValidator;
import net.multiverse.dynamicheight.worldheight.WorldHeightData;
import net.multiverse.dynamicheight.worldheight.WorldHeightSavedData;

public final class WorldHeightManager {
    private static final Map<class_5321<class_1937>, WorldHeightSavedData> BY_DIMENSION = new ConcurrentHashMap<class_5321<class_1937>, WorldHeightSavedData>();

    private WorldHeightManager() {
    }

    public static void registerEvents() {
        ServerWorldEvents.LOAD.register((server, level) -> {
            WorldHeightSavedData data = WorldHeightManager.getData(level);
            if (level.method_27983().equals(class_1937.field_25179) && WorldHeightData.hasPendingClientSelection()) {
                data.update(WorldHeightData.consumeSnapshot());
            }
            WorldHeightManager.applyDimensionSettings(level, data);
        });
        ServerWorldEvents.UNLOAD.register((server, level) -> BY_DIMENSION.remove(level.method_27983()));
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            if (!(world instanceof class_3218)) {
                return class_1269.field_5811;
            }
            class_3218 level = (class_3218)world;
            WorldHeightSavedData data = WorldHeightManager.getData(level);
            class_2338 target = hitResult.method_17777().method_10093(hitResult.method_17780());
            int y = target.method_10264();
            if (y < data.minY() || y > data.maxY()) {
                player.method_7353((class_2561)class_2561.method_43470((String)("Cannot place blocks outside the configured vertical range (" + data.minY() + " .. " + data.maxY() + ") in " + String.valueOf(level.method_27983().method_29177()))).method_27692(class_124.field_1061), true);
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        });
    }

    public static void applyClientSelection(class_3222 player, WorldHeightData.Snapshot snapshot) {
        MinecraftServer server = player.method_5682();
        if (server == null) {
            return;
        }
        HeightValidator.HeightRange range = HeightValidator.sanitize(snapshot.minY(), snapshot.maxY());
        WorldHeightData.Snapshot sanitized = new WorldHeightData.Snapshot(range.minY(), range.maxY());
        for (class_3218 level : server.method_3738()) {
            WorldHeightSavedData data = WorldHeightManager.getData(level);
            data.update(sanitized);
            WorldHeightManager.applyDimensionSettings(level, data);
        }
    }

    public static WorldHeightSavedData currentData(class_3218 level) {
        return WorldHeightManager.getData(level);
    }

    private static WorldHeightSavedData getData(class_3218 level) {
        return BY_DIMENSION.compute((class_5321<class_1937>)level.method_27983(), (key, existing) -> {
            if (existing != null) {
                return existing;
            }
            class_2874 type = level.method_8597();
            String storageKey = WorldHeightSavedData.storageKey((class_5321<class_1937>)level.method_27983());
            WorldHeightSavedData loaded = (WorldHeightSavedData)level.method_17983().method_20786(tag -> WorldHeightSavedData.load(tag, type), storageKey);
            if (loaded == null) {
                loaded = WorldHeightSavedData.createFromDimension(type);
                level.method_17983().method_123(storageKey, (class_18)loaded);
            }
            return loaded;
        });
    }

    private static void applyDimensionSettings(class_3218 level, WorldHeightSavedData data) {
        class_6880 holder = level.method_40134();
        class_2874 current = (class_2874)holder.comp_349();
        if (current.comp_651() != data.minY() || current.comp_652() != data.height()) {
            class_2874 updated = DimensionTypeUtil.copyWithHeight(current, data.minY(), data.maxY());
            DimensionTypeUtil.bindUpdatedDimensionType(level.method_30349(), (class_6880<class_2874>)holder, updated);
        }
        WorldHeightNetwork.broadcast(level, data);
    }
}

