/*
 * Decompiled with CFR 0.152.
 */
package net.multiverse.dynamicheight.worldheight;

import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2874;
import net.minecraft.class_5321;
import net.multiverse.dynamicheight.worldheight.HeightValidator;
import net.multiverse.dynamicheight.worldheight.WorldHeightData;

public final class WorldHeightSavedData
extends class_18 {
    private static final String KEY_MIN = "MinY";
    private static final String KEY_MAX = "MaxY";
    private int minY;
    private int maxY;

    public WorldHeightSavedData() {
        this(-2016, 2016);
    }

    public WorldHeightSavedData(int minY, int maxY) {
        this.applyRangeInternal(HeightValidator.sanitize(minY, maxY));
    }

    public static WorldHeightSavedData createFromDimension(class_2874 type) {
        return new WorldHeightSavedData(type.comp_651(), type.comp_651() + type.comp_652() - 1);
    }

    public static WorldHeightSavedData load(class_2487 tag, class_2874 type) {
        int min = tag.method_10545(KEY_MIN) ? tag.method_10550(KEY_MIN) : type.comp_651();
        int max = tag.method_10545(KEY_MAX) ? tag.method_10550(KEY_MAX) : type.comp_651() + type.comp_652() - 1;
        return new WorldHeightSavedData(min, max);
    }

    public class_2487 method_75(class_2487 tag) {
        tag.method_10569(KEY_MIN, this.minY);
        tag.method_10569(KEY_MAX, this.maxY);
        return tag;
    }

    public int minY() {
        return this.minY;
    }

    public int maxY() {
        return this.maxY;
    }

    public int height() {
        return this.maxY - this.minY + 1;
    }

    public void update(WorldHeightData.Snapshot snapshot) {
        this.applyRange(snapshot.minY(), snapshot.maxY());
    }

    public boolean applyRange(int newMinY, int newMaxY) {
        return this.applyRangeInternal(HeightValidator.sanitize(newMinY, newMaxY));
    }

    private boolean applyRangeInternal(HeightValidator.HeightRange range) {
        if (range.minY() == this.minY && range.maxY() == this.maxY) {
            return false;
        }
        this.minY = range.minY();
        this.maxY = range.maxY();
        this.method_80();
        return true;
    }

    public static String storageKey(class_5321<class_1937> dimension) {
        String path = dimension.method_29177().method_12832().replace('/', '_');
        return "dynamic_height_" + dimension.method_29177().method_12836() + "_" + path;
    }
}

