/*
 * Decompiled with CFR 0.152.
 */
package net.multiverse.dynamicheight.client;

import com.mojang.serialization.Lifecycle;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.tabs.TabManager;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.gui.screens.worldselection.WorldCreationUiState;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.multiverse.dynamicheight.client.WorldHeightSettings;
import net.multiverse.dynamicheight.mixin.ScreenInvoker;
import net.multiverse.dynamicheight.util.DimensionTypeUtil;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;

public final class WorldHeightScreenHooks {
    private static final Component HEADER = Component.literal((String)"Custom Height Settings");
    private static final Component FLOOR_LABEL = Component.literal((String)"Floor (min Y)");
    private static final Component CEILING_LABEL = Component.literal((String)"Ceiling (max Y)");
    private static StringWidget minLabel;
    private static StringWidget maxLabel;
    private static EditBox minBox;
    private static EditBox maxBox;
    private static Button resetButton;
    private static Field TAB_MANAGER_FIELD;
    private static Method TAB_MANAGER_METHOD;

    private WorldHeightScreenHooks() {
    }

    public static void onScreenInit(ScreenEvent.Init.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof CreateWorldScreen) {
            CreateWorldScreen createWorldScreen = (CreateWorldScreen)screen;
            WorldHeightScreenHooks.onInit(createWorldScreen);
        } else {
            WorldHeightScreenHooks.clearWidgets();
        }
    }

    public static void onClientTick(ClientTickEvent.Post event) {
        Minecraft client = Minecraft.getInstance();
        Screen screen = client.screen;
        if (screen instanceof CreateWorldScreen) {
            CreateWorldScreen screen2 = (CreateWorldScreen)screen;
            WorldHeightScreenHooks.refreshBoxes(screen2);
        }
    }

    private static void clearWidgets() {
        minLabel = null;
        maxLabel = null;
        minBox = null;
        maxBox = null;
        resetButton = null;
    }

    private static void onInit(CreateWorldScreen screen) {
        WorldHeightScreenHooks.clearWidgets();
        int panelWidth = 220;
        int panelX = 20;
        int fieldWidth = panelWidth * 2 / 5;
        int startY = 20;
        resetButton = Button.builder((Component)HEADER, button -> {
            WorldHeightSettings.resetToDefaults();
            WorldHeightScreenHooks.refreshBoxes(screen);
            WorldHeightScreenHooks.applySelection(screen);
        }).bounds(panelX, startY, panelWidth, 20).tooltip(Tooltip.create((Component)Component.literal((String)"Reset to the default overworld height"))).build();
        WorldHeightScreenHooks.addWidget(screen, (AbstractWidget)resetButton);
        int rowY = startY + 28;
        minLabel = new StringWidget(panelX, rowY, fieldWidth, 10, FLOOR_LABEL, Minecraft.getInstance().font);
        WorldHeightScreenHooks.addWidget(screen, (AbstractWidget)minLabel);
        minBox = new EditBox(Minecraft.getInstance().font, panelX, rowY += 12, fieldWidth, 20, FLOOR_LABEL);
        minBox.setValue(Integer.toString(WorldHeightSettings.getMinY()));
        minBox.setFilter(WorldHeightScreenHooks::allowIntegerInput);
        minBox.setTooltip(Tooltip.create((Component)Component.literal((String)"Clamped to multiples of 16 down to vanilla minimum (-64).")));
        minBox.setResponder(value -> {
            Integer parsed = WorldHeightScreenHooks.parseInt(value);
            if (parsed != null) {
                WorldHeightSettings.setMinY(parsed);
                WorldHeightScreenHooks.applySelection(screen);
            }
        });
        WorldHeightScreenHooks.addWidget(screen, (AbstractWidget)minBox);
        maxLabel = new StringWidget(panelX, rowY += 28, fieldWidth, 10, CEILING_LABEL, Minecraft.getInstance().font);
        WorldHeightScreenHooks.addWidget(screen, (AbstractWidget)maxLabel);
        maxBox = new EditBox(Minecraft.getInstance().font, panelX, rowY += 12, fieldWidth, 20, CEILING_LABEL);
        maxBox.setValue(Integer.toString(WorldHeightSettings.getMaxY()));
        maxBox.setFilter(WorldHeightScreenHooks::allowIntegerInput);
        maxBox.setTooltip(Tooltip.create((Component)Component.literal((String)"Snaps to 16-block steps and never below vanilla ceiling.")));
        maxBox.setResponder(value -> {
            Integer parsed = WorldHeightScreenHooks.parseInt(value);
            if (parsed != null) {
                WorldHeightSettings.setMaxY(parsed);
                WorldHeightScreenHooks.applySelection(screen);
            }
        });
        WorldHeightScreenHooks.addWidget(screen, (AbstractWidget)maxBox);
        WorldHeightScreenHooks.applySelection(screen);
        WorldHeightScreenHooks.refreshBoxes(screen);
    }

    private static void refreshBoxes(CreateWorldScreen screen) {
        boolean visible = WorldHeightScreenHooks.isWorldTabActive(screen);
        if (resetButton != null) {
            WorldHeightScreenHooks.resetButton.visible = visible;
            WorldHeightScreenHooks.resetButton.active = visible;
        }
        if (minLabel != null) {
            WorldHeightScreenHooks.minLabel.visible = visible;
        }
        if (maxLabel != null) {
            WorldHeightScreenHooks.maxLabel.visible = visible;
        }
        if (minBox != null) {
            if (!minBox.isFocused()) {
                minBox.setValue(Integer.toString(WorldHeightSettings.getMinY()));
            }
            WorldHeightScreenHooks.minBox.visible = visible;
            WorldHeightScreenHooks.minBox.active = visible;
        }
        if (maxBox != null) {
            if (!maxBox.isFocused()) {
                maxBox.setValue(Integer.toString(WorldHeightSettings.getMaxY()));
            }
            WorldHeightScreenHooks.maxBox.visible = visible;
            WorldHeightScreenHooks.maxBox.active = visible;
        }
    }

    private static void applySelection(CreateWorldScreen screen) {
        WorldCreationUiState state = screen.getUiState();
        state.updateDimensions((registryAccess, dimensions) -> WorldHeightScreenHooks.rebuildDimensions(registryAccess, dimensions, WorldHeightSettings.getMinY(), WorldHeightSettings.getMaxY()));
    }

    private static WorldDimensions rebuildDimensions(RegistryAccess.Frozen registryAccess, WorldDimensions existing, int minY, int maxY) {
        MappedRegistry rebuilt = new MappedRegistry(Registries.LEVEL_STEM, Lifecycle.stable());
        existing.dimensions().forEach((key, stem) -> rebuilt.register(key, (Object)WorldHeightScreenHooks.rebuildStem((RegistryAccess)registryAccess, stem, minY, maxY), RegistrationInfo.BUILT_IN));
        return new WorldDimensions(rebuilt.freeze());
    }

    private static LevelStem rebuildStem(RegistryAccess registryAccess, LevelStem stem, int minY, int maxY) {
        DimensionType updated = DimensionTypeUtil.copyWithHeight((DimensionType)stem.type().value(), minY, maxY);
        Holder<DimensionType> updatedHolder = DimensionTypeUtil.bindUpdatedDimensionType(registryAccess, (Holder<DimensionType>)stem.type(), updated);
        return new LevelStem(updatedHolder, stem.generator());
    }

    private static boolean isWorldTabActive(CreateWorldScreen screen) {
        Object manager = WorldHeightScreenHooks.resolveTabManager(screen);
        if (manager == null) {
            return true;
        }
        try {
            Method getCurrentTab = manager.getClass().getMethod("getCurrentTab", new Class[0]);
            Object current = getCurrentTab.invoke(manager, new Object[0]);
            if (current == null) {
                return true;
            }
            String simpleName = current.getClass().getSimpleName();
            if (simpleName.contains("WorldTab")) {
                return true;
            }
            Package pkg = current.getClass().getPackage();
            return pkg != null && pkg.getName().contains("worldselection");
        }
        catch (ReflectiveOperationException ignored) {
            return true;
        }
    }

    private static Object resolveTabManager(CreateWorldScreen screen) {
        try {
            if (TAB_MANAGER_FIELD == null && (TAB_MANAGER_FIELD = WorldHeightScreenHooks.findFieldWithType(screen.getClass(), TabManager.class)) != null) {
                TAB_MANAGER_FIELD.setAccessible(true);
            }
            if (TAB_MANAGER_FIELD != null) {
                return TAB_MANAGER_FIELD.get(screen);
            }
            if (TAB_MANAGER_METHOD == null && (TAB_MANAGER_METHOD = WorldHeightScreenHooks.findZeroArgMethodReturning(screen.getClass(), TabManager.class)) != null) {
                TAB_MANAGER_METHOD.setAccessible(true);
            }
            if (TAB_MANAGER_METHOD != null) {
                return TAB_MANAGER_METHOD.invoke((Object)screen, new Object[0]);
            }
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return null;
    }

    private static Field findFieldWithType(Class<?> owner, Class<?> type) {
        for (Class<?> current = owner; current != null && current != Object.class; current = current.getSuperclass()) {
            for (Field field : current.getDeclaredFields()) {
                if (field.getType() != type) continue;
                return field;
            }
        }
        return null;
    }

    private static Method findZeroArgMethodReturning(Class<?> owner, Class<?> type) {
        for (Class<?> current = owner; current != null && current != Object.class; current = current.getSuperclass()) {
            for (Method method : current.getDeclaredMethods()) {
                if (method.getParameterCount() != 0 || method.getReturnType() != type) continue;
                return method;
            }
        }
        return null;
    }

    private static boolean allowIntegerInput(String value) {
        if (value == null || value.isEmpty() || "-".equals(value)) {
            return true;
        }
        return WorldHeightScreenHooks.parseInt(value) != null;
    }

    private static Integer parseInt(String value) {
        if (value == null || value.isEmpty() || "-".equals(value)) {
            return null;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static void addWidget(CreateWorldScreen screen, AbstractWidget widget) {
        ((ScreenInvoker)screen).dynamicheight$addRenderableWidget(widget);
    }
}

