/*
 * Decompiled with CFR 0.152.
 */
package net.multiverse.dynamicheight.network;

import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.multiverse.dynamicheight.client.ClientDimensionHeights;
import net.multiverse.dynamicheight.network.WorldHeightAppliedPayload;
import net.multiverse.dynamicheight.network.WorldHeightSyncPayload;
import net.multiverse.dynamicheight.worldheight.WorldHeightData;
import net.multiverse.dynamicheight.worldheight.WorldHeightManager;
import net.multiverse.dynamicheight.worldheight.WorldHeightSavedData;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public final class WorldHeightNetwork {
    private WorldHeightNetwork() {
    }

    public static void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1.0.0");
        registrar.playToServer(WorldHeightSyncPayload.TYPE, WorldHeightSyncPayload.CODEC, WorldHeightNetwork::handleSyncFromClient);
        registrar.playToClient(WorldHeightAppliedPayload.TYPE, WorldHeightAppliedPayload.CODEC, WorldHeightNetwork::handleAppliedOnClient);
    }

    public static void sendCurrentRange(ServerPlayer player, ServerLevel level) {
        WorldHeightSavedData data = WorldHeightManager.currentData(level);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new WorldHeightAppliedPayload(level.dimension().location(), data.minY(), data.maxY()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void broadcast(ServerLevel level, WorldHeightSavedData data) {
        for (ServerPlayer player : level.players()) {
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new WorldHeightAppliedPayload(level.dimension().location(), data.minY(), data.maxY()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private static void handleSyncFromClient(WorldHeightSyncPayload payload, IPayloadContext context) {
        Player player = context.player();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        context.enqueueWork(() -> {
            WorldHeightData.updateFromClient(payload.minY(), payload.maxY());
            WorldHeightManager.applyClientSelection(player2, WorldHeightData.consumeSnapshot());
            WorldHeightNetwork.sendCurrentRange(player2, player2.level());
        });
    }

    private static void handleAppliedOnClient(WorldHeightAppliedPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            WorldHeightData.applyServerRange(payload.minY(), payload.maxY());
            ClientDimensionHeights.remember(payload.dimension(), payload.minY(), payload.maxY());
        });
    }

    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player;
        Player player2 = event.getEntity();
        if (player2 instanceof ServerPlayer && (player2 = (player = (ServerPlayer)player2).level()) instanceof ServerLevel) {
            Player level = player2;
            WorldHeightNetwork.sendCurrentRange(player, (ServerLevel)level);
        }
    }

    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        ServerPlayer player;
        Player player2 = event.getEntity();
        if (player2 instanceof ServerPlayer && (player2 = (player = (ServerPlayer)player2).level()) instanceof ServerLevel) {
            Player level = player2;
            WorldHeightNetwork.sendCurrentRange(player, (ServerLevel)level);
        }
    }
}

