/*
 * Decompiled with CFR 0.152.
 */
package net.multiverse.dynamicheight.util;

import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.status.WorldGenContext;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.multiverse.dynamicheight.mixin.ChunkMapAccessor;

public final class ServerGeneratorReloader {
    private ServerGeneratorReloader() {
    }

    public static void swapGenerator(ServerLevel level, NoiseBasedChunkGenerator generator, NoiseGeneratorSettings settings) {
        ServerChunkCache chunkSource = level.getChunkSource();
        ChunkMap chunkMap = chunkSource.chunkMap;
        ChunkMapAccessor accessor = (ChunkMapAccessor)chunkMap;
        RegistryAccess registryAccess = level.registryAccess();
        HolderLookup.RegistryLookup noiseLookup = registryAccess.lookupOrThrow(Registries.NOISE);
        RandomState randomState = RandomState.create((NoiseGeneratorSettings)settings, (HolderGetter)noiseLookup, (long)level.getSeed());
        HolderLookup.RegistryLookup structureSets = registryAccess.lookupOrThrow(Registries.STRUCTURE_SET);
        ChunkGeneratorStructureState generatorState = generator.createState((HolderLookup)structureSets, randomState, level.getSeed());
        WorldGenContext previous = accessor.dynamicheight$getWorldGenContext();
        WorldGenContext updated = new WorldGenContext(level, (ChunkGenerator)generator, previous.structureManager(), previous.lightEngine());
        accessor.dynamicheight$setWorldGenContext(updated);
        accessor.dynamicheight$setRandomState(randomState);
        accessor.dynamicheight$setChunkGeneratorState(generatorState);
    }
}

