/*
 * Decompiled with CFR 0.152.
 */
package miragefairy2024.wave;

import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import miragefairy2024.shadow.mirrg.kotlin.slf4j.hydrogen.LoggingKt;
import miragefairy2024.wave.ByteArrayKt;
import miragefairy2024.wave.OggKt;
import miragefairy2024.wave.PhaseKt;
import miragefairy2024.wave.Spectrogram;
import miragefairy2024.wave.SpectrogramKt;
import miragefairy2024.wave.WavKt;
import miragefairy2024.wave.Waveform;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bR\u0014\u0010\n\u001a\u00020\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\u000bR\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lmiragefairy2024/wave/GenerateV1;", "", "<init>", "()V", "Ljava/io/File;", "inputFile", "", "generate", "(Ljava/io/File;)V", "Lorg/slf4j/Logger;", "logger", "Lorg/slf4j/Logger;", "", "samplesPerSecond", "I", "IFR25KU-fabric"})
@SourceDebugExtension(value={"SMAP\nGenerateV1.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateV1.kt\nmiragefairy2024/wave/GenerateV1\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,65:1\n1#2:66\n*E\n"})
public final class GenerateV1 {
    @NotNull
    public static final GenerateV1 INSTANCE = new GenerateV1();
    @NotNull
    private static final Logger logger = LoggingKt.getLogger(GenerateV1.class);
    private static final int samplesPerSecond = 48000;

    private GenerateV1() {
    }

    public final void generate(@NotNull File inputFile) {
        Intrinsics.checkNotNullParameter((Object)inputFile, (String)"inputFile");
        logger.info("inputFile        = " + inputFile);
        String string = FilesKt.getExtension((File)inputFile);
        if (Intrinsics.areEqual((Object)string, (Object)"wav")) {
            SpectrogramKt.writeTo(SpectrogramKt.toSpectrogram(WavKt.toWaveformAsWav(FilesKt.readBytes((File)inputFile)), 8, 2.5E-4), FilesKt.resolveSibling((File)inputFile, (String)(FilesKt.getNameWithoutExtension((File)inputFile) + ".png")));
        } else if (Intrinsics.areEqual((Object)string, (Object)"png")) {
            Object object;
            Regex regex = new Regex("(.*)\\.(\\d+)b\\.(\\d+)ms\\.(\\d+)a\\.scr\\.png");
            String string2 = inputFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            MatchResult matchResult = regex.matchEntire((CharSequence)string2);
            Intrinsics.checkNotNull((Object)matchResult);
            MatchResult m = matchResult;
            MatchGroup matchGroup = m.getGroups().get(1);
            String string3 = matchGroup != null ? matchGroup.getValue() : null;
            Intrinsics.checkNotNull((Object)string3);
            String baseName = string3;
            logger.info("baseName         = " + baseName);
            File outputFile = FilesKt.resolveSibling((File)inputFile, (String)(baseName + ".ogg"));
            logger.info("outputFile       = " + outputFile);
            MatchGroup matchGroup2 = m.getGroups().get(2);
            String string4 = matchGroup2 != null ? matchGroup2.getValue() : null;
            Intrinsics.checkNotNull((Object)string4);
            int bits = Integer.parseInt(string4);
            logger.info("bits             = " + bits);
            int windowSize = 1 << bits;
            logger.info("windowSize       = " + windowSize);
            int imageHeight = windowSize / 2 + 1;
            logger.info("imageHeight      = " + imageHeight);
            logger.info("samplesPerSecond = " + samplesPerSecond);
            MatchGroup matchGroup3 = m.getGroups().get(3);
            String string5 = matchGroup3 != null ? matchGroup3.getValue() : null;
            Intrinsics.checkNotNull((Object)string5);
            double duration = Double.parseDouble(string5) * 0.001;
            logger.info("duration         = " + duration);
            int imageWidth = (int)((double)samplesPerSecond * duration + (double)(windowSize - 1));
            logger.info("imageWidth       = " + imageWidth);
            MatchGroup matchGroup4 = m.getGroups().get(4);
            String string6 = matchGroup4 != null ? matchGroup4.getValue() : null;
            Intrinsics.checkNotNull((Object)string6);
            double amplifier = Double.parseDouble(string6);
            logger.info("amplifier        = " + amplifier);
            Object it = object = PhaseKt.generatePhaseGriffinLim(PhaseKt.generatePhaseSimple(SpectrogramKt.resize(SpectrogramKt.readSpectrogram(inputFile), imageWidth, imageHeight)), 20, (Function1<? super Spectrogram, Waveform>)((Function1)arg_0 -> GenerateV1.generate$lambda$0(bits, arg_0)), (Function1<? super Waveform, Spectrogram>)((Function1)arg_0 -> GenerateV1.generate$lambda$1(bits, arg_0)));
            boolean bl = false;
            SpectrogramKt.writeTo((Spectrogram)it, FilesKt.resolveSibling((File)inputFile, (String)"dump.png"));
            it = object = (Object)WavKt.toWavByteArray(SpectrogramKt.toWaveform((Spectrogram)object, bits, 1.0 / amplifier));
            boolean bl2 = false;
            ByteArrayKt.writeTo((byte[])it, FilesKt.resolveSibling((File)inputFile, (String)"dump.wav"));
            ByteArrayKt.writeTo(OggKt.toOggAsWav((byte[])object), outputFile);
        }
    }

    private static final Waveform generate$lambda$0(int $bits, Spectrogram it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return SpectrogramKt.toWaveform(it, $bits, 1.0);
    }

    private static final Spectrogram generate$lambda$1(int $bits, Waveform it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return SpectrogramKt.toSpectrogram(it, $bits, 1.0);
    }
}

