/*
 * Decompiled with CFR 0.152.
 */
package miragefairy2024.wave;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import miragefairy2024.shadow.mirrg.kotlin.slf4j.hydrogen.LoggingKt;
import miragefairy2024.wave.Wav;
import miragefairy2024.wave.Waveform;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0011\u0010\u0002\u001a\u00020\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u0011\u0010\u0004\u001a\u00020\u0000*\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005\"\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"", "Lmiragefairy2024/wave/Waveform;", "toWaveformAsWav", "([B)Lmiragefairy2024/wave/Waveform;", "toWavByteArray", "(Lmiragefairy2024/wave/Waveform;)[B", "Lorg/slf4j/Logger;", "logger", "Lorg/slf4j/Logger;", "IFR25KU-fabric"})
public final class WavKt {
    @NotNull
    private static final Logger logger = LoggingKt.getLogger(Wav.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Waveform toWaveformAsWav(@NotNull byte[] $this$toWaveformAsWav) {
        Intrinsics.checkNotNullParameter((Object)$this$toWaveformAsWav, (String)"<this>");
        Closeable closeable = AudioSystem.getAudioInputStream(new ByteArrayInputStream($this$toWaveformAsWav));
        Throwable throwable = null;
        try {
            AudioInputStream input = (AudioInputStream)closeable;
            boolean bl = false;
            logger.info(String.valueOf(input.getFormat()));
            logger.info(String.valueOf(input.getFormat().getSampleRate()));
            logger.info(String.valueOf(input.getFormat().getFrameSize()));
            byte[] inputBytes = input.readAllBytes();
            int length = inputBytes.length / input.getFormat().getFrameSize();
            double[] outputDoubles = new double[length];
            for (int i = 0; i < length; ++i) {
                int i2 = i;
                boolean bl2 = false;
                int a = i2 * input.getFormat().getFrameSize();
                double value = 0.0;
                int n = input.getFormat().getChannels();
                for (int j = 0; j < n; ++j) {
                    int channel = j;
                    boolean bl3 = false;
                    value += (switch (input.getFormat().getSampleSizeInBits()) {
                        case 8 -> inputBytes[a + 1 * channel + 0];
                        case 16 -> {
                            byte b0 = inputBytes[a + 2 * channel + 0];
                            byte b1 = inputBytes[a + 2 * channel + 1];
                            yield b0 & 0xFF | b1 << 8;
                        }
                        default -> throw new RuntimeException("Bits not supported: " + input.getFormat().getSampleSizeInBits());
                    });
                }
                outputDoubles[i2] = value /= (double)input.getFormat().getChannels();
            }
            Waveform waveform = new Waveform(outputDoubles);
            return waveform;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public static final byte[] toWavByteArray(@NotNull Waveform $this$toWavByteArray) {
        Intrinsics.checkNotNullParameter((Object)$this$toWavByteArray, (String)"<this>");
        byte[] bytes = new byte[$this$toWavByteArray.getDoubleArray().length * 2];
        int n = $this$toWavByteArray.getDoubleArray().length;
        int n2 = 0;
        while (n2 < n) {
            int i = n2++;
            boolean bl = false;
            int n3 = RangesKt.coerceIn((int)((int)$this$toWavByteArray.getDoubleArray()[i]), (ClosedRange)((ClosedRange)RangesKt.until((int)Short.MIN_VALUE, (int)32768)));
            bytes[2 * i + 0] = (byte)(n3 >> 0 & 0xFF);
            bytes[2 * i + 1] = (byte)(n3 >> 8 & 0xFF);
        }
        AudioFormat format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 48000.0f, 16, 1, 2, 48000.0f, false);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        AudioSystem.write(new AudioInputStream(new ByteArrayInputStream(bytes), format, $this$toWavByteArray.getDoubleArray().length), AudioFileFormat.Type.WAVE, output);
        byte[] byArray = output.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return byArray;
    }
}

