/*
 * Decompiled with CFR 0.152.
 */
package miragefairy2024.client.mod.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import miragefairy2024.shadow.mirrg.kotlin.helium.NumberKt;
import net.fabricmc.fabric.api.client.particle.v1.FabricSpriteProvider;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0019\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ%\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J'\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001dJ'\u0010\"\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020 2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\"\u0010#J/\u0010&\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020 2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010%\u001a\u00020$H\u0002\u00a2\u0006\u0004\b&\u0010'J7\u0010-\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020\u00102\u0006\u0010+\u001a\u00020\u00102\u0006\u0010,\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b-\u0010.J\u000f\u0010/\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b/\u00100J\u0017\u00101\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b1\u00102J\u0017\u00104\u001a\u00020\b2\u0006\u00103\u001a\u00020\u0010H\u0014\u00a2\u0006\u0004\b4\u00105J\u000f\u00107\u001a\u000206H\u0016\u00a2\u0006\u0004\b7\u00108R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u00109R\"\u0010:\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b:\u0010;\u001a\u0004\b<\u0010=\"\u0004\b>\u0010\u001dR\"\u0010\u0016\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0016\u0010;\u001a\u0004\b?\u0010=\"\u0004\b@\u0010\u001dR\"\u0010\u0017\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0017\u0010;\u001a\u0004\bA\u0010=\"\u0004\bB\u0010\u001dR\"\u0010C\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bC\u0010;\u001a\u0004\bD\u0010=\"\u0004\bE\u0010\u001dR(\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00100\u00128\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bF\u0010G\u001a\u0004\bH\u0010I\"\u0004\bJ\u0010KR(\u0010L\u001a\b\u0012\u0004\u0012\u00020\u00100\u00128\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bL\u0010G\u001a\u0004\bM\u0010I\"\u0004\bN\u0010K\u00a8\u0006O"}, d2={"Lmiragefairy2024/client/mod/particle/MagicSquareParticle;", "Lnet/minecraft/client/particle/TextureSheetParticle;", "Lnet/minecraft/client/multiplayer/ClientLevel;", "world", "", "x", "y", "z", "", "layer", "Lnet/minecraft/world/phys/Vec3;", "targetPosition", "Lnet/minecraft/client/particle/SpriteSet;", "spriteProvider", "<init>", "(Lnet/minecraft/client/multiplayer/ClientLevel;DDDILnet/minecraft/world/phys/Vec3;Lnet/minecraft/client/particle/SpriteSet;)V", "", "tickDelta", "", "ticks", "getValue", "(F[Ljava/lang/Float;)F", "color1", "color2", "delta", "", "setColor", "(IIF)V", "color", "(I)V", "Lcom/mojang/blaze3d/vertex/VertexConsumer;", "vertexConsumer", "Lnet/minecraft/client/Camera;", "camera", "render", "(Lcom/mojang/blaze3d/vertex/VertexConsumer;Lnet/minecraft/client/Camera;F)V", "", "flip", "buildGeometry", "(Lcom/mojang/blaze3d/vertex/VertexConsumer;Lnet/minecraft/client/Camera;FZ)V", "Lorg/joml/Vector3f;", "pos", "u", "v", "light", "vertex", "(Lcom/mojang/blaze3d/vertex/VertexConsumer;Lorg/joml/Vector3f;FFI)V", "tick", "()V", "getQuadSize", "(F)F", "tint", "getLightColor", "(F)I", "Lnet/minecraft/client/particle/ParticleRenderType;", "getRenderType", "()Lnet/minecraft/client/particle/ParticleRenderType;", "Lnet/minecraft/world/phys/Vec3;", "delay", "I", "getDelay", "()I", "setDelay", "getColor1", "setColor1", "getColor2", "setColor2", "color3", "getColor3", "setColor3", "alphaTicks", "[Ljava/lang/Float;", "getAlphaTicks", "()[Ljava/lang/Float;", "setAlphaTicks", "([Ljava/lang/Float;)V", "lightTicks", "getLightTicks", "setLightTicks", "IFR25KU-common_client"})
@SourceDebugExtension(value={"SMAP\nMagicSquareParticle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MagicSquareParticle.kt\nmiragefairy2024/client/mod/particle/MagicSquareParticle\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,189:1\n13409#2,2:190\n*S KotlinDebug\n*F\n+ 1 MagicSquareParticle.kt\nmiragefairy2024/client/mod/particle/MagicSquareParticle\n*L\n142#1:190,2\n*E\n"})
public final class MagicSquareParticle
extends TextureSheetParticle {
    @NotNull
    private final Vec3 targetPosition;
    private int delay;
    private int color1;
    private int color2;
    private int color3;
    @NotNull
    private Float[] alphaTicks;
    @NotNull
    private Float[] lightTicks;

    public MagicSquareParticle(@NotNull ClientLevel world, double x, double y, double z, int layer, @NotNull Vec3 targetPosition, @NotNull SpriteSet spriteProvider) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)targetPosition, (String)"targetPosition");
        Intrinsics.checkNotNullParameter((Object)spriteProvider, (String)"spriteProvider");
        super(world, x, y, z);
        this.targetPosition = targetPosition;
        this.color1 = 16774355;
        this.color2 = 16758828;
        this.color3 = 3414798;
        Float[] floatArray = new Float[]{Float.valueOf(0.0f), Float.valueOf(10.0f), Float.valueOf(70.0f), Float.valueOf(80.0f)};
        this.alphaTicks = floatArray;
        floatArray = new Float[]{Float.valueOf(0.0f), Float.valueOf(10.0f), Float.valueOf(70.0f), Float.valueOf(80.0f)};
        this.lightTicks = floatArray;
        List sprites = ((FabricSpriteProvider)spriteProvider).getSprites();
        Intrinsics.checkNotNull((Object)sprites);
        this.setSprite((TextureAtlasSprite)sprites.get(RangesKt.coerceIn((int)layer, (ClosedRange)((ClosedRange)CollectionsKt.getIndices((Collection)sprites)))));
        this.lifetime = 80;
        this.quadSize = 0.5f;
    }

    public final int getDelay() {
        return this.delay;
    }

    public final void setDelay(int n) {
        this.delay = n;
    }

    public final int getColor1() {
        return this.color1;
    }

    public final void setColor1(int n) {
        this.color1 = n;
    }

    public final int getColor2() {
        return this.color2;
    }

    public final void setColor2(int n) {
        this.color2 = n;
    }

    public final int getColor3() {
        return this.color3;
    }

    public final void setColor3(int n) {
        this.color3 = n;
    }

    @NotNull
    public final Float[] getAlphaTicks() {
        return this.alphaTicks;
    }

    public final void setAlphaTicks(@NotNull Float[] floatArray) {
        Intrinsics.checkNotNullParameter((Object)floatArray, (String)"<set-?>");
        this.alphaTicks = floatArray;
    }

    @NotNull
    public final Float[] getLightTicks() {
        return this.lightTicks;
    }

    public final void setLightTicks(@NotNull Float[] floatArray) {
        Intrinsics.checkNotNullParameter((Object)floatArray, (String)"<set-?>");
        this.lightTicks = floatArray;
    }

    private final float getValue(float tickDelta, Float[] ticks) {
        float a = (float)this.age + tickDelta;
        return a < ticks[0].floatValue() ? 0.0f : (a < ticks[1].floatValue() ? 0.0f + (a - ticks[0].floatValue()) / (ticks[1].floatValue() - ticks[0].floatValue()) : (a < ticks[2].floatValue() ? 1.0f : (a < ticks[3].floatValue() ? 1.0f - (a - ticks[2].floatValue()) / (ticks[3].floatValue() - ticks[2].floatValue()) : 0.0f)));
    }

    private final void setColor(int color1, int color2, float delta) {
        float r1 = (float)(color1 >> 16 & 0xFF) / 255.0f;
        float g1 = (float)(color1 >> 8 & 0xFF) / 255.0f;
        float b1 = (float)(color1 & 0xFF) / 255.0f;
        float r2 = (float)(color2 >> 16 & 0xFF) / 255.0f;
        float g2 = (float)(color2 >> 8 & 0xFF) / 255.0f;
        float b2 = (float)(color2 & 0xFF) / 255.0f;
        this.rCol = r1 + (r2 - r1) * delta;
        this.gCol = g1 + (g2 - g1) * delta;
        this.bCol = b1 + (b2 - b1) * delta;
    }

    private final void setColor(int color) {
        this.rCol = (float)(color >> 16 & 0xFF) / 255.0f;
        this.gCol = (float)(color >> 8 & 0xFF) / 255.0f;
        this.bCol = (float)(color & 0xFF) / 255.0f;
    }

    public void render(@NotNull VertexConsumer vertexConsumer, @NotNull Camera camera, float tickDelta) {
        Intrinsics.checkNotNullParameter((Object)vertexConsumer, (String)"vertexConsumer");
        Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
        if (this.delay > 0) {
            return;
        }
        float a = (float)this.age + tickDelta;
        if (a < this.alphaTicks[0].floatValue()) {
            this.setColor(this.color1);
        } else if (a < this.alphaTicks[1].floatValue()) {
            this.setColor(this.color1);
        } else if (a < this.alphaTicks[2].floatValue()) {
            this.setColor(this.color1, this.color2, (a - this.alphaTicks[1].floatValue()) / (this.alphaTicks[2].floatValue() - this.alphaTicks[1].floatValue()));
        } else if (a < this.alphaTicks[3].floatValue()) {
            this.setColor(this.color2, this.color3, (a - this.alphaTicks[2].floatValue()) / (this.alphaTicks[3].floatValue() - this.alphaTicks[2].floatValue()));
        } else {
            this.setColor(this.color3);
        }
        this.alpha = this.getValue(tickDelta, this.alphaTicks);
        this.buildGeometry(vertexConsumer, camera, tickDelta, false);
        this.buildGeometry(vertexConsumer, camera, tickDelta, true);
    }

    private final void buildGeometry(VertexConsumer vertexConsumer, Camera camera, float tickDelta, boolean flip) {
        Vector3f[] vector3fs;
        float offsetX = (float)(this.targetPosition.x - this.x);
        float offsetY = (float)(this.targetPosition.y - this.y);
        float offsetZ = (float)(this.targetPosition.z - this.z);
        float yaw = (float)Mth.atan2((double)offsetX, (double)offsetZ);
        float pitch = (float)Mth.atan2((double)(-((double)offsetY)), (double)Mth.sqrt((float)(offsetX * offsetX + offsetZ * offsetZ)));
        Quaternionf quaternionf = new Quaternionf().rotationYXZ(yaw, pitch, Mth.lerp((float)tickDelta, (float)this.oRoll, (float)this.roll));
        if (flip) {
            quaternionf.rotateY((float)(-Math.PI));
        }
        float size = this.getQuadSize(tickDelta);
        Vec3 cameraPos = camera.getPosition();
        float translateX = (float)(Mth.lerp((double)tickDelta, (double)this.xo, (double)this.x) - cameraPos.x());
        float translateY = (float)(Mth.lerp((double)tickDelta, (double)this.yo, (double)this.y) - cameraPos.y());
        float translateZ = (float)(Mth.lerp((double)tickDelta, (double)this.zo, (double)this.z) - cameraPos.z());
        Vector3f[] vector3fArray = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        Vector3f[] $this$forEach$iv = vector3fs = vector3fArray;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            Vector3f element$iv;
            Vector3f vector3f = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            vector3f.rotate((Quaternionfc)quaternionf);
            vector3f.mul(size);
            vector3f.add(translateX, translateY, translateZ);
        }
        int brightness = this.getLightColor(tickDelta);
        this.vertex(vertexConsumer, vector3fs[0], this.getU1(), this.getV1(), brightness);
        this.vertex(vertexConsumer, vector3fs[1], this.getU1(), this.getV0(), brightness);
        this.vertex(vertexConsumer, vector3fs[2], this.getU0(), this.getV0(), brightness);
        this.vertex(vertexConsumer, vector3fs[3], this.getU0(), this.getV1(), brightness);
    }

    private final void vertex(VertexConsumer vertexConsumer, Vector3f pos, float u, float v, int light) {
        vertexConsumer.addVertex(pos.x(), pos.y(), pos.z()).setUv(u, v).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(light);
    }

    public void tick() {
        if (this.delay > 0) {
            int n = this.delay;
            this.delay = n + -1;
            return;
        }
        int n = this.age;
        this.age = n + 1;
        if (this.age >= this.lifetime) {
            this.remove();
        }
        this.oRoll = this.roll;
        this.roll += 0.10471976f;
    }

    public float getQuadSize(float tickDelta) {
        return this.quadSize * (1.0f - 0.2f * Mth.cos((float)(((float)this.age + tickDelta) / 80.0f * ((float)Math.PI * 2))));
    }

    protected int getLightColor(float tint) {
        int brightness = super.getLightColor(tint);
        int oldSkyLight = brightness >> 20 & 0xF;
        int oldBlockLight = brightness >> 4 & 0xF;
        int skyLight = oldSkyLight;
        int blockLight = ((Number)((Object)NumberKt.max(oldBlockLight, MathKt.roundToInt((float)(15.0f * this.getValue(tint, this.lightTicks)))))).intValue();
        return skyLight << 20 | blockLight << 4;
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        ParticleRenderType particleRenderType = ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
        Intrinsics.checkNotNullExpressionValue((Object)particleRenderType, (String)"PARTICLE_SHEET_TRANSLUCENT");
        return particleRenderType;
    }
}

