/*
 * Decompiled with CFR 0.152.
 */
package miragefairy2024.mod.magicplant.contents;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import miragefairy2024.ModContext;
import miragefairy2024.mod.magicplant.contents.TraitConditionCard;
import miragefairy2024.shadow.mirrg.kotlin.helium.NumberKt;
import miragefairy2024.util.BlockKt;
import miragefairy2024.util.RegistryKt;
import miragefairy2024.util.TranslationKt;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalBiomeTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u001a\u001f\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006\u001a\u001b\u0010\u0007\u001a\u00020\u0004*\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0007\u0010\u0006\u001a\u001b\u0010\b\u001a\u00020\u0004*\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\b\u0010\u0006\u001a\u0011\u0010\u000b\u001a\u00020\nR\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/core/BlockPos;", "blockPos", "", "getFloorHardness", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)D", "getHighAltitudeFactor", "getLowAltitudeFactor", "Lmiragefairy2024/ModContext;", "", "initTraitConditionCard", "(Lmiragefairy2024/ModContext;)V", "IFR25KU-common"})
@SourceDebugExtension(value={"SMAP\nTraitConditionCard.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TraitConditionCard.kt\nmiragefairy2024/mod/magicplant/contents/TraitConditionCardKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n1863#2,2:99\n*S KotlinDebug\n*F\n+ 1 TraitConditionCard.kt\nmiragefairy2024/mod/magicplant/contents/TraitConditionCardKt\n*L\n94#1:99,2\n*E\n"})
public final class TraitConditionCardKt {
    private static final double getFloorHardness(Level world, BlockPos blockPos) {
        BlockState blockState = world.getBlockState(blockPos.below());
        Intrinsics.checkNotNull((Object)blockState);
        TagKey tagKey = BlockTags.MINEABLE_WITH_PICKAXE;
        Intrinsics.checkNotNullExpressionValue((Object)tagKey, (String)"MINEABLE_WITH_PICKAXE");
        if (BlockKt.isNotIn(blockState, (TagKey<Block>)tagKey)) {
            return 0.0;
        }
        float hardness = blockState.getDestroySpeed((BlockGetter)world, blockPos.below());
        if (hardness < 0.0f) {
            return 0.0;
        }
        return NumberKt.atMost((double)hardness / 2.0, 2.0);
    }

    private static final double getHighAltitudeFactor(Level $this$getHighAltitudeFactor, BlockPos blockPos) {
        double d;
        if ($this$getHighAltitudeFactor.dimensionType().natural()) {
            d = NumberKt.atMost(NumberKt.atLeast(((double)blockPos.getY() - 64.0) / 128.0, 0.0), 1.0);
        } else {
            Holder holder = $this$getHighAltitudeFactor.getBiome(blockPos);
            TagKey tagKey = ConventionalBiomeTags.IS_NETHER;
            Intrinsics.checkNotNullExpressionValue((Object)tagKey, (String)"IS_NETHER");
            if (RegistryKt.isIn(holder, tagKey)) {
                d = 0.0;
            } else {
                Holder holder2 = $this$getHighAltitudeFactor.getBiome(blockPos);
                TagKey tagKey2 = ConventionalBiomeTags.IS_END;
                Intrinsics.checkNotNullExpressionValue((Object)tagKey2, (String)"IS_END");
                d = RegistryKt.isIn(holder2, tagKey2) ? 1.0 : 0.0;
            }
        }
        return d;
    }

    private static final double getLowAltitudeFactor(Level $this$getLowAltitudeFactor, BlockPos blockPos) {
        double d;
        if ($this$getLowAltitudeFactor.dimensionType().natural()) {
            d = NumberKt.atMost(NumberKt.atLeast(-((double)blockPos.getY() - 64.0) / 128.0, 0.0), 1.0);
        } else {
            Holder holder = $this$getLowAltitudeFactor.getBiome(blockPos);
            TagKey tagKey = ConventionalBiomeTags.IS_NETHER;
            Intrinsics.checkNotNullExpressionValue((Object)tagKey, (String)"IS_NETHER");
            if (RegistryKt.isIn(holder, tagKey)) {
                d = 1.0;
            } else {
                Holder holder2 = $this$getLowAltitudeFactor.getBiome(blockPos);
                TagKey tagKey2 = ConventionalBiomeTags.IS_END;
                Intrinsics.checkNotNullExpressionValue((Object)tagKey2, (String)"IS_END");
                d = RegistryKt.isIn(holder2, tagKey2) ? 0.0 : 0.0;
            }
        }
        return d;
    }

    public static final void initTraitConditionCard(@NotNull ModContext $context_receiver_0) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Iterable $this$forEach$iv = (Iterable)TraitConditionCard.getEntries();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TraitConditionCard it = (TraitConditionCard)((Object)element$iv);
            boolean bl = false;
            TranslationKt.enJa($context_receiver_0, it.getTranslation());
        }
    }

    public static final /* synthetic */ double access$getFloorHardness(Level world, BlockPos blockPos) {
        return TraitConditionCardKt.getFloorHardness(world, blockPos);
    }

    public static final /* synthetic */ double access$getHighAltitudeFactor(Level $receiver, BlockPos blockPos) {
        return TraitConditionCardKt.getHighAltitudeFactor($receiver, blockPos);
    }

    public static final /* synthetic */ double access$getLowAltitudeFactor(Level $receiver, BlockPos blockPos) {
        return TraitConditionCardKt.getLowAltitudeFactor($receiver, blockPos);
    }
}

