/*
 * Decompiled with CFR 0.152.
 */
package miragefairy2024.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import miragefairy2024.shadow.mirrg.kotlin.helium.NumberKt;
import miragefairy2024.util.ItemStackKt;
import miragefairy2024.util.MathKt;
import miragefairy2024.util.MultiMine;
import miragefairy2024.util.NeighborType;
import miragefairy2024.util.ServerSide;
import miragefairy2024.util.SideKt;
import miragefairy2024.util.WorldKt;
import net.minecraft.core.BlockBox;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0018\b&\u0018\u00002\u00020\u0001:\u0003234B7\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0010H&\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0015\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u000f\u0010\u001e\u001a\u0004\u0018\u00010\u001d\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010 \u001a\u0004\b!\u0010\"R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010#\u001a\u0004\b$\u0010%R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010&\u001a\u0004\b'\u0010(R\u0017\u0010\t\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u0010)\u001a\u0004\b*\u0010+R\u0017\u0010\u000b\u001a\u00020\n8\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010,\u001a\u0004\b-\u0010.R\u0017\u0010\r\u001a\u00020\f8\u0006\u00a2\u0006\f\n\u0004\b\r\u0010/\u001a\u0004\b0\u00101\u00a8\u00065"}, d2={"Lmiragefairy2024/util/MultiMine;", "", "Lnet/minecraft/world/level/Level;", "level", "Lnet/minecraft/core/BlockPos;", "blockPos", "Lnet/minecraft/world/level/block/state/BlockState;", "blockState", "Lnet/minecraft/world/entity/player/Player;", "miner", "Lnet/minecraft/world/item/Item;", "toolItem", "Lnet/minecraft/world/item/ItemStack;", "toolItemStack", "<init>", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/item/Item;Lnet/minecraft/world/item/ItemStack;)V", "Lmiragefairy2024/util/MultiMine$Visitor;", "visitor", "", "visit", "(Lmiragefairy2024/util/MultiMine$Visitor;)F", "", "isValidBaseBlockState", "()Z", "Lmiragefairy2024/util/ServerSide;", "serverSide", "", "execute", "(Lmiragefairy2024/util/ServerSide;)V", "Lmiragefairy2024/util/MultiMine$MiningArea;", "collect", "()Lmiragefairy2024/util/MultiMine$MiningArea;", "Lnet/minecraft/world/level/Level;", "getLevel", "()Lnet/minecraft/world/level/Level;", "Lnet/minecraft/core/BlockPos;", "getBlockPos", "()Lnet/minecraft/core/BlockPos;", "Lnet/minecraft/world/level/block/state/BlockState;", "getBlockState", "()Lnet/minecraft/world/level/block/state/BlockState;", "Lnet/minecraft/world/entity/player/Player;", "getMiner", "()Lnet/minecraft/world/entity/player/Player;", "Lnet/minecraft/world/item/Item;", "getToolItem", "()Lnet/minecraft/world/item/Item;", "Lnet/minecraft/world/item/ItemStack;", "getToolItemStack", "()Lnet/minecraft/world/item/ItemStack;", "Visitor", "MiningArea", "VisitedBlockEntry", "IFR25KU-common"})
public abstract class MultiMine {
    @NotNull
    private final Level level;
    @NotNull
    private final BlockPos blockPos;
    @NotNull
    private final BlockState blockState;
    @NotNull
    private final Player miner;
    @NotNull
    private final Item toolItem;
    @NotNull
    private final ItemStack toolItemStack;

    public MultiMine(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull BlockState blockState, @NotNull Player miner, @NotNull Item toolItem, @NotNull ItemStack toolItemStack) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)miner, (String)"miner");
        Intrinsics.checkNotNullParameter((Object)toolItem, (String)"toolItem");
        Intrinsics.checkNotNullParameter((Object)toolItemStack, (String)"toolItemStack");
        this.level = level;
        this.blockPos = blockPos;
        this.blockState = blockState;
        this.miner = miner;
        this.toolItem = toolItem;
        this.toolItemStack = toolItemStack;
    }

    @NotNull
    public final Level getLevel() {
        return this.level;
    }

    @NotNull
    public final BlockPos getBlockPos() {
        return this.blockPos;
    }

    @NotNull
    public final BlockState getBlockState() {
        return this.blockState;
    }

    @NotNull
    public final Player getMiner() {
        return this.miner;
    }

    @NotNull
    public final Item getToolItem() {
        return this.toolItem;
    }

    @NotNull
    public final ItemStack getToolItemStack() {
        return this.toolItemStack;
    }

    public abstract float visit(@NotNull Visitor var1);

    public boolean isValidBaseBlockState() {
        return true;
    }

    public final void execute(@NotNull ServerSide serverSide) {
        Intrinsics.checkNotNullParameter((Object)serverSide, (String)"serverSide");
        if (this.miner.isCreative()) {
            return;
        }
        if (this.miner.isShiftKeyDown()) {
            return;
        }
        if (!this.toolItem.isCorrectToolForDrops(this.toolItemStack, this.blockState)) {
            return;
        }
        if (!this.isValidBaseBlockState()) {
            return;
        }
        this.visit(new Visitor(this, serverSide){
            final /* synthetic */ MultiMine this$0;
            final /* synthetic */ ServerSide $serverSide;
            {
                this.this$0 = $receiver;
                this.$serverSide = $serverSide;
            }

            /*
             * WARNING - void declaration
             */
            public boolean visit(Iterable<? extends BlockPos> originalBlockPosList, double miningDamage, int maxDistance, Integer maxCount, NeighborType neighborType, Function1<? super BlockPos, Unit> onMine, BlockBox region, Function2<? super BlockPos, ? super BlockState, Boolean> canContinue) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter(originalBlockPosList, (String)"originalBlockPosList");
                Intrinsics.checkNotNullParameter((Object)((Object)neighborType), (String)"neighborType");
                Intrinsics.checkNotNullParameter(onMine, (String)"onMine");
                Intrinsics.checkNotNullParameter(canContinue, (String)"canContinue");
                Sequence<Pair<Integer, BlockPos>> sequence = WorldKt.blockVisitor(originalBlockPosList, false, maxDistance, maxCount, neighborType, (Function3<? super Integer, ? super BlockPos, ? super BlockPos, Boolean>)((Function3)(arg_0, arg_1, arg_2) -> execute.1.visit$lambda$0(region, this.this$0, canContinue, arg_0, arg_1, arg_2)));
                MultiMine multiMine = this.this$0;
                ServerSide serverSide = this.$serverSide;
                boolean $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    Pair pair = (Pair)element$iv;
                    boolean bl = false;
                    BlockPos blockPos = (BlockPos)pair.component2();
                    if (multiMine.getToolItemStack().isEmpty()) {
                        return false;
                    }
                    if (ItemStackKt.getDurability(multiMine.getToolItemStack()) <= NumberKt.ceilToInt(miningDamage)) {
                        return false;
                    }
                    BlockState targetBlockState = multiMine.getLevel().getBlockState(blockPos);
                    Intrinsics.checkNotNull((Object)targetBlockState);
                    if (!((Boolean)canContinue.invoke((Object)blockPos, (Object)targetBlockState)).booleanValue()) continue;
                    float targetHardness = targetBlockState.getDestroySpeed((BlockGetter)multiMine.getLevel(), blockPos);
                    if (!WorldKt.breakBlockByMagic(multiMine.getToolItemStack(), multiMine.getLevel(), blockPos, SideKt.asServerPlayer(multiMine.getMiner(), serverSide))) continue;
                    if (targetHardness > 0.0f) {
                        RandomSource randomSource = multiMine.getLevel().random;
                        Intrinsics.checkNotNullExpressionValue((Object)randomSource, (String)"random");
                        int damage = MathKt.randomInt(randomSource, miningDamage);
                        if (damage > 0) {
                            multiMine.getToolItemStack().hurtAndBreak(damage, (LivingEntity)multiMine.getMiner(), EquipmentSlot.MAINHAND);
                        }
                    }
                    onMine.invoke((Object)blockPos);
                }
                return true;
            }

            private static final boolean visit$lambda$0(BlockBox $region, MultiMine this$0, Function2 $canContinue, int n, BlockPos blockPos, BlockPos toBlockPos) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$canContinue, (String)"$canContinue");
                Intrinsics.checkNotNullParameter((Object)toBlockPos, (String)"toBlockPos");
                if ($region != null && !$region.contains(toBlockPos)) {
                    return false;
                }
                BlockState blockState = this$0.getLevel().getBlockState(toBlockPos);
                if (blockState.getDestroySpeed((BlockGetter)this$0.getLevel(), toBlockPos) < 0.0f) {
                    return false;
                }
                Intrinsics.checkNotNull((Object)blockState);
                return (Boolean)$canContinue.invoke((Object)toBlockPos, (Object)blockState);
            }
        });
    }

    @Nullable
    public final MiningArea collect() {
        if (this.miner.isCreative()) {
            return null;
        }
        if (this.miner.isShiftKeyDown()) {
            return null;
        }
        if (!this.toolItem.isCorrectToolForDrops(this.toolItemStack, this.blockState)) {
            return null;
        }
        if (!this.isValidBaseBlockState()) {
            return null;
        }
        List entries = new ArrayList();
        float hardness2 = this.visit(new Visitor(this, entries){
            final /* synthetic */ MultiMine this$0;
            final /* synthetic */ List<VisitedBlockEntry> $entries;
            {
                this.this$0 = $receiver;
                this.$entries = $entries;
            }

            /*
             * WARNING - void declaration
             */
            public boolean visit(Iterable<? extends BlockPos> originalBlockPosList, double miningDamage, int maxDistance, Integer maxCount, NeighborType neighborType, Function1<? super BlockPos, Unit> onMine, BlockBox region, Function2<? super BlockPos, ? super BlockState, Boolean> canContinue) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter(originalBlockPosList, (String)"originalBlockPosList");
                Intrinsics.checkNotNullParameter((Object)((Object)neighborType), (String)"neighborType");
                Intrinsics.checkNotNullParameter(onMine, (String)"onMine");
                Intrinsics.checkNotNullParameter(canContinue, (String)"canContinue");
                Sequence<Pair<Integer, BlockPos>> sequence = WorldKt.blockVisitor(originalBlockPosList, false, maxDistance, maxCount, neighborType, (Function3<? super Integer, ? super BlockPos, ? super BlockPos, Boolean>)((Function3)(arg_0, arg_1, arg_2) -> collect.hardness.1.visit$lambda$0(region, this.this$0, canContinue, arg_0, arg_1, arg_2)));
                MultiMine multiMine = this.this$0;
                List<VisitedBlockEntry> list = this.$entries;
                boolean $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    Pair pair = (Pair)element$iv;
                    boolean bl = false;
                    BlockPos blockPos = (BlockPos)pair.component2();
                    BlockState targetBlockState = multiMine.getLevel().getBlockState(blockPos);
                    Collection collection = list;
                    Intrinsics.checkNotNull((Object)targetBlockState);
                    collection.add(new VisitedBlockEntry(blockPos, targetBlockState));
                    onMine.invoke((Object)blockPos);
                }
                return true;
            }

            private static final boolean visit$lambda$0(BlockBox $region, MultiMine this$0, Function2 $canContinue, int n, BlockPos blockPos, BlockPos toBlockPos) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$canContinue, (String)"$canContinue");
                Intrinsics.checkNotNullParameter((Object)toBlockPos, (String)"toBlockPos");
                if ($region != null && !$region.contains(toBlockPos)) {
                    return false;
                }
                BlockState blockState = this$0.getLevel().getBlockState(toBlockPos);
                if (blockState.getDestroySpeed((BlockGetter)this$0.getLevel(), toBlockPos) < 0.0f) {
                    return false;
                }
                Intrinsics.checkNotNull((Object)blockState);
                return (Boolean)$canContinue.invoke((Object)toBlockPos, (Object)blockState);
            }
        });
        return new MiningArea(this, entries, hardness2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\r\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000b\u001a\u0004\b\f\u0010\rR\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lmiragefairy2024/util/MultiMine$MiningArea;", "", "Lmiragefairy2024/util/MultiMine;", "multiMine", "", "Lmiragefairy2024/util/MultiMine$VisitedBlockEntry;", "visitedBlockEntry", "", "hardness", "<init>", "(Lmiragefairy2024/util/MultiMine;Ljava/util/List;F)V", "Lmiragefairy2024/util/MultiMine;", "getMultiMine", "()Lmiragefairy2024/util/MultiMine;", "Ljava/util/List;", "getVisitedBlockEntry", "()Ljava/util/List;", "F", "getHardness", "()F", "IFR25KU-common"})
    public static final class MiningArea {
        @NotNull
        private final MultiMine multiMine;
        @NotNull
        private final List<VisitedBlockEntry> visitedBlockEntry;
        private final float hardness;

        public MiningArea(@NotNull MultiMine multiMine, @NotNull List<VisitedBlockEntry> visitedBlockEntry, float hardness2) {
            Intrinsics.checkNotNullParameter((Object)multiMine, (String)"multiMine");
            Intrinsics.checkNotNullParameter(visitedBlockEntry, (String)"visitedBlockEntry");
            this.multiMine = multiMine;
            this.visitedBlockEntry = visitedBlockEntry;
            this.hardness = hardness2;
        }

        @NotNull
        public final MultiMine getMultiMine() {
            return this.multiMine;
        }

        @NotNull
        public final List<VisitedBlockEntry> getVisitedBlockEntry() {
            return this.visitedBlockEntry;
        }

        public final float getHardness() {
            return this.hardness;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\b\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u000b\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lmiragefairy2024/util/MultiMine$VisitedBlockEntry;", "", "Lnet/minecraft/core/BlockPos;", "blockPos", "Lnet/minecraft/world/level/block/state/BlockState;", "blockState", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "Lnet/minecraft/core/BlockPos;", "getBlockPos", "()Lnet/minecraft/core/BlockPos;", "Lnet/minecraft/world/level/block/state/BlockState;", "getBlockState", "()Lnet/minecraft/world/level/block/state/BlockState;", "IFR25KU-common"})
    public static final class VisitedBlockEntry {
        @NotNull
        private final BlockPos blockPos;
        @NotNull
        private final BlockState blockState;

        public VisitedBlockEntry(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
            Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
            Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
            this.blockPos = blockPos;
            this.blockState = blockState;
        }

        @NotNull
        public final BlockPos getBlockPos() {
            return this.blockPos;
        }

        @NotNull
        public final BlockState getBlockState() {
            return this.blockState;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\u0081\u0001\u0010\u0015\u001a\u00020\u00132\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\u000b\u001a\u00020\n2\u0014\b\u0002\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r0\f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011H&\u00a2\u0006\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lmiragefairy2024/util/MultiMine$Visitor;", "", "", "Lnet/minecraft/core/BlockPos;", "originalBlockPosList", "", "miningDamage", "", "maxDistance", "maxCount", "Lmiragefairy2024/util/NeighborType;", "neighborType", "Lkotlin/Function1;", "", "onMine", "Lnet/minecraft/core/BlockBox;", "region", "Lkotlin/Function2;", "Lnet/minecraft/world/level/block/state/BlockState;", "", "canContinue", "visit", "(Ljava/lang/Iterable;DILjava/lang/Integer;Lmiragefairy2024/util/NeighborType;Lkotlin/jvm/functions/Function1;Lnet/minecraft/core/BlockBox;Lkotlin/jvm/functions/Function2;)Z", "IFR25KU-common"})
    public static interface Visitor {
        public boolean visit(@NotNull Iterable<? extends BlockPos> var1, double var2, int var4, @Nullable Integer var5, @NotNull NeighborType var6, @NotNull Function1<? super BlockPos, Unit> var7, @Nullable BlockBox var8, @NotNull Function2<? super BlockPos, ? super BlockState, Boolean> var9);

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            public static /* synthetic */ boolean visit$default(Visitor visitor, Iterable iterable, double d, int n, Integer n2, NeighborType neighborType, Function1 function1, BlockBox blockBox, Function2 function2, int n3, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: visit");
                }
                if ((n3 & 4) != 0) {
                    n = Integer.MAX_VALUE;
                }
                if ((n3 & 8) != 0) {
                    n2 = null;
                }
                if ((n3 & 0x10) != 0) {
                    neighborType = NeighborType.FACES;
                }
                if ((n3 & 0x20) != 0) {
                    function1 = DefaultImpls::visit$lambda$0;
                }
                if ((n3 & 0x40) != 0) {
                    blockBox = null;
                }
                return visitor.visit(iterable, d, n, n2, neighborType, (Function1<? super BlockPos, Unit>)function1, blockBox, (Function2<? super BlockPos, ? super BlockState, Boolean>)function2);
            }

            private static Unit visit$lambda$0(BlockPos it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Unit.INSTANCE;
            }
        }
    }
}

