/*
 * Decompiled with CFR 0.152.
 */
package miragefairy2024.mod.machine;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import miragefairy2024.mod.machine.SimpleMachineRecipeCard;
import miragefairy2024.mod.machine.SimpleMachineRecipeInput;
import miragefairy2024.shadow.mirrg.kotlin.helium.NumberKt;
import miragefairy2024.util.CodecKt;
import miragefairy2024.util.IngredientStack;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001:B9\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001d\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\n0\u001b2\u0006\u0010\u0012\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001f\u0010 \u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\b \u0010!J\u001f\u0010$\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\f2\u0006\u0010#\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b$\u0010%J\u0017\u0010&\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\b&\u0010'J\u000f\u0010(\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b(\u0010)J\u0017\u0010+\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000*H\u0016\u00a2\u0006\u0004\b+\u0010,J\u0017\u0010.\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000-H\u0016\u00a2\u0006\u0004\b.\u0010/R\u0018\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u00100R\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u00101R\u001d\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00078\u0006\u00a2\u0006\f\n\u0004\b\t\u00102\u001a\u0004\b3\u00104R\u0017\u0010\u000b\u001a\u00020\n8\u0006\u00a2\u0006\f\n\u0004\b\u000b\u00105\u001a\u0004\b6\u0010)R\u0017\u0010\r\u001a\u00020\f8\u0006\u00a2\u0006\f\n\u0004\b\r\u00107\u001a\u0004\b8\u00109\u00a8\u0006;"}, d2={"Lmiragefairy2024/mod/machine/SimpleMachineRecipe;", "Lnet/minecraft/world/item/crafting/Recipe;", "Lmiragefairy2024/mod/machine/SimpleMachineRecipeInput;", "Lmiragefairy2024/mod/machine/SimpleMachineRecipeCard;", "card", "", "group", "", "Lmiragefairy2024/util/IngredientStack;", "inputs", "Lnet/minecraft/world/item/ItemStack;", "output", "", "duration", "<init>", "(Lmiragefairy2024/mod/machine/SimpleMachineRecipeCard;Ljava/lang/String;Ljava/util/List;Lnet/minecraft/world/item/ItemStack;I)V", "getGroup", "()Ljava/lang/String;", "inventory", "Lnet/minecraft/world/level/Level;", "world", "", "matches", "(Lmiragefairy2024/mod/machine/SimpleMachineRecipeInput;Lnet/minecraft/world/level/Level;)Z", "itemStack", "getCustomizedRemainder", "(Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/world/item/ItemStack;", "Lnet/minecraft/core/NonNullList;", "getRemainingItems", "(Lmiragefairy2024/mod/machine/SimpleMachineRecipeInput;)Lnet/minecraft/core/NonNullList;", "Lnet/minecraft/core/HolderLookup$Provider;", "registries", "assemble", "(Lmiragefairy2024/mod/machine/SimpleMachineRecipeInput;Lnet/minecraft/core/HolderLookup$Provider;)Lnet/minecraft/world/item/ItemStack;", "width", "height", "canCraftInDimensions", "(II)Z", "getResultItem", "(Lnet/minecraft/core/HolderLookup$Provider;)Lnet/minecraft/world/item/ItemStack;", "getToastSymbol", "()Lnet/minecraft/world/item/ItemStack;", "Lmiragefairy2024/mod/machine/SimpleMachineRecipe$Serializer;", "getSerializer", "()Lmiragefairy2024/mod/machine/SimpleMachineRecipe$Serializer;", "Lnet/minecraft/world/item/crafting/RecipeType;", "getType", "()Lnet/minecraft/world/item/crafting/RecipeType;", "Lmiragefairy2024/mod/machine/SimpleMachineRecipeCard;", "Ljava/lang/String;", "Ljava/util/List;", "getInputs", "()Ljava/util/List;", "Lnet/minecraft/world/item/ItemStack;", "getOutput", "I", "getDuration", "()I", "Serializer", "IFR25KU-common"})
@SourceDebugExtension(value={"SMAP\nSimpleMachineRecipe.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleMachineRecipe.kt\nmiragefairy2024/mod/machine/SimpleMachineRecipe\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,187:1\n1872#2,3:188\n1872#2,3:191\n*S KotlinDebug\n*F\n+ 1 SimpleMachineRecipe.kt\nmiragefairy2024/mod/machine/SimpleMachineRecipe\n*L\n82#1:188,3\n93#1:191,3\n*E\n"})
public class SimpleMachineRecipe
implements Recipe<SimpleMachineRecipeInput> {
    @NotNull
    private final SimpleMachineRecipeCard<?> card;
    @NotNull
    private final String group;
    @NotNull
    private final List<IngredientStack> inputs;
    @NotNull
    private final ItemStack output;
    private final int duration;

    public SimpleMachineRecipe(@NotNull SimpleMachineRecipeCard<?> card, @NotNull String group, @NotNull List<IngredientStack> inputs, @NotNull ItemStack output, int duration) {
        Intrinsics.checkNotNullParameter(card, (String)"card");
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter(inputs, (String)"inputs");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        this.card = card;
        this.group = group;
        this.inputs = inputs;
        this.output = output;
        this.duration = duration;
    }

    @NotNull
    public final List<IngredientStack> getInputs() {
        return this.inputs;
    }

    @NotNull
    public final ItemStack getOutput() {
        return this.output;
    }

    public final int getDuration() {
        return this.duration;
    }

    @NotNull
    public String getGroup() {
        return this.group;
    }

    /*
     * WARNING - void declaration
     */
    public boolean matches(@NotNull SimpleMachineRecipeInput inventory, @NotNull Level world) {
        Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Iterable $this$forEachIndexed$iv = this.inputs;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void input;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IngredientStack ingredientStack = (IngredientStack)item$iv;
            int index = n;
            boolean bl = false;
            if (!input.getIngredient().test(inventory.getItem(index))) {
                return false;
            }
            if (inventory.getItem(index).getCount() >= input.getCount()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack getCustomizedRemainder(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        ItemStack itemStack2 = itemStack.getItem().getRecipeRemainder(itemStack);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"getRecipeRemainder(...)");
        return itemStack2;
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(@NotNull SimpleMachineRecipeInput inventory) {
        Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
        NonNullList list = NonNullList.create();
        Iterable $this$forEachIndexed$iv = this.inputs;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int count;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IngredientStack ingredientStack = (IngredientStack)item$iv;
            int index = n;
            boolean bl = false;
            ItemStack remainder = this.getCustomizedRemainder(inventory.getItem(index));
            if (remainder.isEmpty()) continue;
            for (int totalRemainderCount = remainder.getCount() * input.getCount(); totalRemainderCount > 0; totalRemainderCount -= count) {
                count = NumberKt.atMost(totalRemainderCount, remainder.getMaxStackSize());
                Intrinsics.checkNotNull((Object)list);
                ((Collection)list).add(remainder.copyWithCount(count));
            }
        }
        Intrinsics.checkNotNull((Object)list);
        return list;
    }

    @NotNull
    public ItemStack assemble(@NotNull SimpleMachineRecipeInput inventory, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        ItemStack itemStack = this.output.copy();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copy(...)");
        return itemStack;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= this.inputs.size();
    }

    @NotNull
    public ItemStack getResultItem(@NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        return this.output;
    }

    @NotNull
    public ItemStack getToastSymbol() {
        return this.card.getIcon();
    }

    @NotNull
    public Serializer<? extends SimpleMachineRecipe> getSerializer() {
        return this.card.getSerializer();
    }

    @NotNull
    public RecipeType<? extends SimpleMachineRecipe> getType() {
        return this.card.getType();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u0003B\u0015\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u001b\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00028\u00000\u000bH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eR\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lmiragefairy2024/mod/machine/SimpleMachineRecipe$Serializer;", "Lmiragefairy2024/mod/machine/SimpleMachineRecipe;", "R", "Lnet/minecraft/world/item/crafting/RecipeSerializer;", "Lmiragefairy2024/mod/machine/SimpleMachineRecipeCard;", "card", "<init>", "(Lmiragefairy2024/mod/machine/SimpleMachineRecipeCard;)V", "Lcom/mojang/serialization/MapCodec;", "codec", "()Lcom/mojang/serialization/MapCodec;", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "streamCodec", "()Lnet/minecraft/network/codec/StreamCodec;", "Lmiragefairy2024/mod/machine/SimpleMachineRecipeCard;", "IFR25KU-common"})
    public static final class Serializer<R extends SimpleMachineRecipe>
    implements RecipeSerializer<R> {
        @NotNull
        private final SimpleMachineRecipeCard<R> card;

        public Serializer(@NotNull SimpleMachineRecipeCard<R> card) {
            Intrinsics.checkNotNullParameter(card, (String)"card");
            this.card = card;
        }

        @NotNull
        public MapCodec<R> codec() {
            MapCodec mapCodec = RecordCodecBuilder.mapCodec(arg_0 -> Serializer.codec$lambda$4(this, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"mapCodec(...)");
            return mapCodec;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, R> streamCodec() {
            StreamCodec streamCodec2 = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, Serializer::streamCodec$lambda$5, CodecKt.list(IngredientStack.Companion.getSTREAM_CODEC()), Serializer::streamCodec$lambda$6, (StreamCodec)ItemStack.STREAM_CODEC, Serializer::streamCodec$lambda$7, (StreamCodec)ByteBufCodecs.VAR_INT, Serializer::streamCodec$lambda$8, this.card::createRecipe);
            Intrinsics.checkNotNullExpressionValue((Object)streamCodec2, (String)"composite(...)");
            return streamCodec2;
        }

        private static final String codec$lambda$4$lambda$0(SimpleMachineRecipe it) {
            return it.group;
        }

        private static final List codec$lambda$4$lambda$1(SimpleMachineRecipe it) {
            return it.getInputs();
        }

        private static final ItemStack codec$lambda$4$lambda$2(SimpleMachineRecipe it) {
            return it.getOutput();
        }

        private static final Integer codec$lambda$4$lambda$3(SimpleMachineRecipe it) {
            return it.getDuration();
        }

        private static final App codec$lambda$4(Serializer this$0, RecordCodecBuilder.Instance instance) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            return instance.group((App)Codec.STRING.fieldOf("group").forGetter(Serializer::codec$lambda$4$lambda$0), (App)IngredientStack.Companion.getCODEC().listOf().fieldOf("inputs").forGetter(Serializer::codec$lambda$4$lambda$1), (App)ItemStack.CODEC.fieldOf("output").forGetter(Serializer::codec$lambda$4$lambda$2), (App)Codec.INT.fieldOf("duration").forGetter(Serializer::codec$lambda$4$lambda$3)).apply((Applicative)instance, this$0.card::createRecipe);
        }

        private static final String streamCodec$lambda$5(SimpleMachineRecipe it) {
            return it.group;
        }

        private static final List streamCodec$lambda$6(SimpleMachineRecipe it) {
            return it.getInputs();
        }

        private static final ItemStack streamCodec$lambda$7(SimpleMachineRecipe it) {
            return it.getOutput();
        }

        private static final Integer streamCodec$lambda$8(SimpleMachineRecipe it) {
            return it.getDuration();
        }
    }
}

