/*
 * Decompiled with CFR 0.152.
 */
package miragefairy2024.util;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import miragefairy2024.shadow.mirrg.kotlin.helium.NumberKt;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000b\u0010\nJ\u0015\u0010\f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\f\u0010\nJ\u0015\u0010\r\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\r\u0010\nJ\r\u0010\u000e\u001a\u00020\b\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lmiragefairy2024/util/LightProxy;", "", "Lnet/minecraft/world/level/Level;", "level", "<init>", "(Lnet/minecraft/world/level/Level;)V", "Lnet/minecraft/core/BlockPos;", "blockPos", "", "getLightLevel", "(Lnet/minecraft/core/BlockPos;)I", "getPermanentLightLevel", "getBlockLightLevel", "getPermanentSkyLightLevel", "getSkyDarken", "()I", "Lnet/minecraft/world/level/Level;", "getLevel", "()Lnet/minecraft/world/level/Level;", "IFR25KU-common"})
public final class LightProxy {
    @NotNull
    private final Level level;

    public LightProxy(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        this.level = level;
    }

    @NotNull
    public final Level getLevel() {
        return this.level;
    }

    public final int getLightLevel(@NotNull BlockPos blockPos) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        if (this.level.isClientSide) {
            this.level.updateSkyBrightness();
        }
        return this.level.getMaxLocalRawBrightness(blockPos);
    }

    public final int getPermanentLightLevel(@NotNull BlockPos blockPos) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        return ((Number)((Object)NumberKt.max(this.getBlockLightLevel(blockPos), this.getPermanentSkyLightLevel(blockPos)))).intValue();
    }

    public final int getBlockLightLevel(@NotNull BlockPos blockPos) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        return this.level.getBrightness(LightLayer.BLOCK, blockPos);
    }

    public final int getPermanentSkyLightLevel(@NotNull BlockPos blockPos) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        return this.level.getBrightness(LightLayer.SKY, blockPos);
    }

    public final int getSkyDarken() {
        if (this.level.isClientSide) {
            this.level.updateSkyBrightness();
        }
        return this.level.getSkyDarken();
    }
}

