/*
 * Decompiled with CFR 0.152.
 */
package miragefairy2024.wave;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import kotlin.ranges.RangesKt;
import miragefairy2024.wave.Spectrogram;
import miragefairy2024.wave.Waveform;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0011\u0010\u0001\u001a\u00020\u0000*\u00020\u0000\u00a2\u0006\u0004\b\u0001\u0010\u0002\u001a\u0011\u0010\u0003\u001a\u00020\u0000*\u00020\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0002\u001a\u0011\u0010\u0004\u001a\u00020\u0000*\u00020\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0002\u001aA\u0010\u000b\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00052\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\b0\u00072\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00000\u0007\u00a2\u0006\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lmiragefairy2024/wave/Spectrogram;", "removePhase", "(Lmiragefairy2024/wave/Spectrogram;)Lmiragefairy2024/wave/Spectrogram;", "generatePhaseSimple", "generatePhaseLegacy", "", "times", "Lkotlin/Function1;", "Lmiragefairy2024/wave/Waveform;", "toWaveform", "toSpectrogram", "generatePhaseGriffinLim", "(Lmiragefairy2024/wave/Spectrogram;ILkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Lmiragefairy2024/wave/Spectrogram;", "IFR25KU-fabric"})
@SourceDebugExtension(value={"SMAP\nPhase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Phase.kt\nmiragefairy2024/wave/PhaseKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,147:1\n1557#2:148\n1628#2,3:149\n1557#2:152\n1628#2,3:153\n1557#2:156\n1628#2,3:157\n*S KotlinDebug\n*F\n+ 1 Phase.kt\nmiragefairy2024/wave/PhaseKt\n*L\n50#1:148\n50#1:149,3\n51#1:152\n51#1:153,3\n55#1:156\n55#1:157,3\n*E\n"})
public final class PhaseKt {
    @NotNull
    public static final Spectrogram removePhase(@NotNull Spectrogram $this$removePhase) {
        Intrinsics.checkNotNullParameter((Object)$this$removePhase, (String)"<this>");
        BufferedImage image = new BufferedImage($this$removePhase.getBufferedImage().getWidth(), $this$removePhase.getBufferedImage().getHeight(), 1);
        int n = $this$removePhase.getBufferedImage().getWidth();
        for (int i = 0; i < n; ++i) {
            int x = i;
            boolean bl = false;
            int n2 = $this$removePhase.getBufferedImage().getHeight();
            int n3 = 0;
            while (n3 < n2) {
                int y = n3++;
                boolean bl2 = false;
                image.setRGB(x, y, $this$removePhase.getBufferedImage().getRGB(x, y) & 0xFF00);
            }
        }
        return new Spectrogram(image);
    }

    @NotNull
    public static final Spectrogram generatePhaseSimple(@NotNull Spectrogram $this$generatePhaseSimple) {
        Intrinsics.checkNotNullParameter((Object)$this$generatePhaseSimple, (String)"<this>");
        int windowSize = ($this$generatePhaseSimple.getBufferedImage().getHeight() - 1) * 2;
        BufferedImage image = new BufferedImage($this$generatePhaseSimple.getBufferedImage().getWidth(), $this$generatePhaseSimple.getBufferedImage().getHeight(), 1);
        int n = $this$generatePhaseSimple.getBufferedImage().getWidth();
        for (int i = 0; i < n; ++i) {
            int x = i;
            boolean bl = false;
            int n2 = $this$generatePhaseSimple.getBufferedImage().getHeight();
            int n3 = 0;
            while (n3 < n2) {
                int imageY = n3++;
                boolean bl2 = false;
                int y = $this$generatePhaseSimple.getBufferedImage().getHeight() - 1 - imageY;
                double w = Math.PI * 2 / (double)windowSize * (double)y;
                int inputRgb = $this$generatePhaseSimple.getBufferedImage().getRGB(x, imageY);
                double g = inputRgb >> 8 & 0xFF;
                double r = g * Math.cos(w * (double)x);
                double b = g * Math.sin(w * (double)x);
                int outputRgb = (RangesKt.coerceIn((int)MathKt.roundToInt((double)r), (int)-128, (int)127) + 128 & 0xFF) << 16 | (RangesKt.coerceIn((int)((int)g), (int)0, (int)255) & 0xFF) << 8 | (RangesKt.coerceIn((int)MathKt.roundToInt((double)b), (int)-128, (int)127) + 128 & 0xFF) << 0;
                image.setRGB(x, imageY, outputRgb);
            }
        }
        return new Spectrogram(image);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Spectrogram generatePhaseLegacy(@NotNull Spectrogram $this$generatePhaseLegacy) {
        void $this$mapTo$iv$iv;
        int n;
        void $this$mapTo$iv$iv2;
        int n2;
        Collection collection;
        void $this$mapTo$iv$iv3;
        Intrinsics.checkNotNullParameter((Object)$this$generatePhaseLegacy, (String)"<this>");
        int windowSize = ($this$generatePhaseLegacy.getBufferedImage().getHeight() - 1) * 2;
        Random random = RandomKt.Random((int)0);
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)$this$generatePhaseLegacy.getBufferedImage().getHeight());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv3.iterator();
        while (iterator.hasNext()) {
            int item$iv$iv;
            int n3 = item$iv$iv = ((IntIterator)iterator).nextInt();
            collection = destination$iv$iv;
            n2 = 0;
            collection.add(Math.PI * 2 * random.nextDouble());
        }
        List oldPhases = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        Iterable $this$map$iv2 = (Iterable)RangesKt.until((int)0, (int)$this$generatePhaseLegacy.getBufferedImage().getHeight());
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        Iterator item$iv$iv = $this$mapTo$iv$iv2.iterator();
        while (item$iv$iv.hasNext()) {
            int item$iv$iv2;
            n2 = item$iv$iv2 = ((IntIterator)item$iv$iv).nextInt();
            collection = destination$iv$iv2;
            n = 0;
            collection.add(Math.PI * 2 * random.nextDouble());
        }
        List newPhases = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv2));
        Iterable $this$map$iv3 = (Iterable)RangesKt.until((int)0, (int)$this$generatePhaseLegacy.getBufferedImage().getHeight());
        boolean $i$f$map3 = false;
        destination$iv$iv2 = $this$map$iv3;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo3 = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            int item$iv$iv3;
            n = item$iv$iv3 = ((IntIterator)iterator2).nextInt();
            collection = destination$iv$iv3;
            boolean bl = false;
            collection.add(random.nextInt(windowSize));
        }
        List phaseGradientResetOffsets = (List)destination$iv$iv3;
        BufferedImage image = new BufferedImage($this$generatePhaseLegacy.getBufferedImage().getWidth(), $this$generatePhaseLegacy.getBufferedImage().getHeight(), 1);
        int n4 = $this$generatePhaseLegacy.getBufferedImage().getWidth();
        for (int i = 0; i < n4; ++i) {
            int x = i;
            boolean bl = false;
            int n5 = $this$generatePhaseLegacy.getBufferedImage().getHeight();
            for (int j = 0; j < n5; ++j) {
                int imageY = j;
                boolean bl2 = false;
                int y = $this$generatePhaseLegacy.getBufferedImage().getHeight() - 1 - imageY;
                double w = Math.PI * 2 / (double)windowSize * (double)y;
                int inputRgb = $this$generatePhaseLegacy.getBufferedImage().getRGB(x, imageY);
                double g = inputRgb >> 8 & 0xFF;
                int phaseGradientResetPhase = (x + ((Number)phaseGradientResetOffsets.get(y)).intValue()) % windowSize;
                double phaseGradient = (double)phaseGradientResetPhase / (double)windowSize;
                double phase = ((Number)oldPhases.get(y)).doubleValue() * (1.0 - phaseGradient) + ((Number)newPhases.get(y)).doubleValue() * phaseGradient;
                double r = g * Math.cos(phase + w * (double)x);
                double b = g * Math.sin(phase + w * (double)x);
                int outputRgb = (RangesKt.coerceIn((int)((int)r), (int)-128, (int)127) + 128 & 0xFF) << 16 | (RangesKt.coerceIn((int)((int)g), (int)0, (int)255) & 0xFF) << 8 | (RangesKt.coerceIn((int)((int)b), (int)-128, (int)127) + 128 & 0xFF) << 0;
                if (phaseGradientResetPhase == 0) {
                    oldPhases.set(y, newPhases.get(y));
                    newPhases.set(y, Math.PI * 2 * random.nextDouble());
                }
                image.setRGB(x, imageY, outputRgb);
            }
        }
        return new Spectrogram(image);
    }

    @NotNull
    public static final Spectrogram generatePhaseGriffinLim(@NotNull Spectrogram $this$generatePhaseGriffinLim, int times, @NotNull Function1<? super Spectrogram, Waveform> toWaveform, @NotNull Function1<? super Waveform, Spectrogram> toSpectrogram) {
        Intrinsics.checkNotNullParameter((Object)$this$generatePhaseGriffinLim, (String)"<this>");
        Intrinsics.checkNotNullParameter(toWaveform, (String)"toWaveform");
        Intrinsics.checkNotNullParameter(toSpectrogram, (String)"toSpectrogram");
        int width = $this$generatePhaseGriffinLim.getBufferedImage().getWidth();
        int height = $this$generatePhaseGriffinLim.getBufferedImage().getHeight();
        int n = 0;
        int[][] nArrayArray = new int[height][];
        while (n < height) {
            int n2 = n++;
            nArrayArray[n2] = new int[width];
        }
        int[][] correctGTable = nArrayArray;
        int n3 = 0;
        double[][] dArrayArray = new double[height][];
        while (n3 < height) {
            int n4 = n3++;
            dArrayArray[n4] = new double[width];
        }
        double[][] doubleCorrectGTable = dArrayArray;
        for (n3 = 0; n3 < width; ++n3) {
            int x = n3;
            boolean bl = false;
            int n5 = 0;
            while (n5 < height) {
                int thisG;
                int y = n5++;
                boolean bl2 = false;
                int thisRgb = $this$generatePhaseGriffinLim.getBufferedImage().getRGB(x, y);
                correctGTable[y][x] = thisG = thisRgb >> 8 & 0xFF;
                doubleCorrectGTable[y][x] = thisG;
            }
        }
        Object spectrogram = null;
        spectrogram = $this$generatePhaseGriffinLim;
        for (int i = 0; i < times; ++i) {
            int it = i;
            boolean bl = false;
            spectrogram = toSpectrogram.invoke(toWaveform.invoke(spectrogram));
            for (int j = 0; j < width; ++j) {
                int x = j;
                boolean bl3 = false;
                for (int k = 0; k < height; ++k) {
                    int y = k;
                    boolean bl4 = false;
                    int rgb = ((Spectrogram)spectrogram).getBufferedImage().getRGB(x, y);
                    double r = (rgb >> 16 & 0xFF) - 128;
                    double g = rgb >> 8 & 0xFF;
                    double b = (rgb >> 0 & 0xFF) - 128;
                    double rate = g == 0.0 ? 10000.0 : doubleCorrectGTable[y][x] / g;
                    double trueR = r * rate;
                    double trueB = b * rate;
                    int trueRgb = (RangesKt.coerceIn((int)MathKt.roundToInt((double)trueR), (int)-128, (int)127) + 128 & 0xFF) << 16 | (RangesKt.coerceIn((int)correctGTable[y][x], (int)0, (int)255) & 0xFF) << 8 | (RangesKt.coerceIn((int)MathKt.roundToInt((double)trueB), (int)-128, (int)127) + 128 & 0xFF) << 0;
                    ((Spectrogram)spectrogram).getBufferedImage().setRGB(x, y, trueRgb);
                }
            }
        }
        return spectrogram;
    }
}

