/*
 * Decompiled with CFR 0.152.
 */
package miragefairy2024.mixins.api;

import java.util.List;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class BlockCallback {
    public static final Event<AfterBreak> AFTER_BREAK = EventFactory.createArrayBacked(AfterBreak.class, callbacks -> (world, player, pos, state, blockEntity, tool) -> {
        for (AfterBreak callback : callbacks) {
            callback.afterBreak(world, player, pos, state, blockEntity, tool);
        }
    });
    public static final Event<GetDropsByEntity> GET_DROPS_BY_ENTITY = EventFactory.createArrayBacked(GetDropsByEntity.class, callbacks -> (state, level, pos, blockEntity, entity, tool, drops) -> {
        List<ItemStack> newDrops = drops;
        for (GetDropsByEntity callback : callbacks) {
            newDrops = callback.getDrops(state, level, pos, blockEntity, entity, tool, newDrops);
        }
        return newDrops;
    });
    public static final Event<DropByEntity> BEFORE_DROP_BY_ENTITY = EventFactory.createArrayBacked(DropByEntity.class, callbacks -> (state, level, pos, blockEntity, entity, tool) -> {
        for (DropByEntity callback : callbacks) {
            callback.onDropByEntity(state, level, pos, blockEntity, entity, tool);
        }
    });
    public static final Event<DropByEntity> AFTER_DROP_BY_ENTITY = EventFactory.createArrayBacked(DropByEntity.class, callbacks -> (state, level, pos, blockEntity, entity, tool) -> {
        for (DropByEntity callback : callbacks) {
            callback.onDropByEntity(state, level, pos, blockEntity, entity, tool);
        }
    });
    public static final Event<OverrideDestroySpeed> OVERRIDE_DESTROY_SPEED = EventFactory.createArrayBacked(OverrideDestroySpeed.class, callbacks -> (state, player, level, pos, f2) -> {
        float newF = f2;
        for (OverrideDestroySpeed callback : callbacks) {
            newF = callback.overrideDestroySpeed(state, player, level, pos, newF);
        }
        return newF;
    });

    public static interface OverrideDestroySpeed {
        public float overrideDestroySpeed(BlockState var1, Player var2, BlockGetter var3, BlockPos var4, float var5);
    }

    public static interface DropByEntity {
        public void onDropByEntity(BlockState var1, Level var2, BlockPos var3, @Nullable BlockEntity var4, @Nullable Entity var5, ItemStack var6);
    }

    public static interface GetDropsByEntity {
        public List<ItemStack> getDrops(BlockState var1, ServerLevel var2, BlockPos var3, @Nullable BlockEntity var4, @Nullable Entity var5, ItemStack var6, List<ItemStack> var7);
    }

    public static interface AfterBreak {
        public void afterBreak(Level var1, Player var2, BlockPos var3, BlockState var4, @Nullable BlockEntity var5, ItemStack var6);
    }
}

