/*
 * Decompiled with CFR 0.152.
 */
package miragefairy2024.mod.fairybuilding;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import miragefairy2024.RenderingProxy;
import miragefairy2024.lib.MachineBlockEntity;
import miragefairy2024.mod.fairybuilding.FairyBuildingBlockEntity;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b.\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001:\u0003DEFB\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001b\u0010\u000b\u001a\u00020\n2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ+\u0010\u0011\u001a\u00020\n2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u0013R\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0014R\u0016\u0010\u0015\u001a\u00020\u00038\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0013R\u0016\u0010\u0017\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u0016\u0010\u001a\u001a\u00020\u00198\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\"\u0010\u001c\u001a\u00020\u00038\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u0013\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\"\u0010!\u001a\u00020\u00198\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b!\u0010\u001b\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\"\u0010&\u001a\u00020\u00198\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b&\u0010\u001b\u001a\u0004\b'\u0010#\"\u0004\b(\u0010%R\"\u0010)\u001a\u00020\u00198\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b)\u0010\u001b\u001a\u0004\b*\u0010#\"\u0004\b+\u0010%R\"\u0010,\u001a\u00020\u000f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b,\u0010-\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\"\u00102\u001a\u00020\u000f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b2\u0010-\u001a\u0004\b3\u0010/\"\u0004\b4\u00101R\"\u00105\u001a\u00020\u00198\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b5\u0010\u001b\u001a\u0004\b6\u0010#\"\u0004\b7\u0010%R\"\u00108\u001a\u00020\u00198\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b8\u0010\u001b\u001a\u0004\b9\u0010#\"\u0004\b:\u0010%R\"\u0010;\u001a\u00020\u00198\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b;\u0010\u001b\u001a\u0004\b<\u0010#\"\u0004\b=\u0010%R\"\u0010>\u001a\u00020\u000f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b>\u0010-\u001a\u0004\b?\u0010/\"\u0004\b@\u00101R\"\u0010A\u001a\u00020\u000f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bA\u0010-\u001a\u0004\bB\u0010/\"\u0004\bC\u00101\u00a8\u0006G"}, d2={"Lmiragefairy2024/mod/fairybuilding/FairyAnimation;", "Lmiragefairy2024/lib/MachineBlockEntity$Animation;", "Lmiragefairy2024/mod/fairybuilding/FairyBuildingBlockEntity;", "", "inventorySlotIndex", "Lmiragefairy2024/mod/fairybuilding/FairyAnimation$Configuration;", "animation", "<init>", "(ILmiragefairy2024/mod/fairybuilding/FairyAnimation$Configuration;)V", "blockEntity", "", "tick", "(Lmiragefairy2024/mod/fairybuilding/FairyBuildingBlockEntity;)V", "Lmiragefairy2024/RenderingProxy;", "renderingProxy", "", "tickDelta", "render", "(Lmiragefairy2024/mod/fairybuilding/FairyBuildingBlockEntity;Lmiragefairy2024/RenderingProxy;F)V", "I", "Lmiragefairy2024/mod/fairybuilding/FairyAnimation$Configuration;", "index", "Lmiragefairy2024/mod/fairybuilding/FairyAnimation$Position;", "position", "Lmiragefairy2024/mod/fairybuilding/FairyAnimation$Position;", "", "countdown", "D", "ticks", "getTicks", "()I", "setTicks", "(I)V", "xSpeed", "getXSpeed", "()D", "setXSpeed", "(D)V", "ySpeed", "getYSpeed", "setYSpeed", "zSpeed", "getZSpeed", "setZSpeed", "yawSpeed", "F", "getYawSpeed", "()F", "setYawSpeed", "(F)V", "pitchSpeed", "getPitchSpeed", "setPitchSpeed", "x", "getX", "setX", "y", "getY", "setY", "z", "getZ", "setZ", "yaw", "getYaw", "setYaw", "pitch", "getPitch", "setPitch", "Configuration", "Motion", "Position", "IFR25KU-common"})
public final class FairyAnimation
implements MachineBlockEntity.Animation<FairyBuildingBlockEntity<?>> {
    private final int inventorySlotIndex;
    @NotNull
    private final Configuration animation;
    private int index;
    @NotNull
    private Position position;
    private double countdown;
    private int ticks;
    private double xSpeed;
    private double ySpeed;
    private double zSpeed;
    private float yawSpeed;
    private float pitchSpeed;
    private double x;
    private double y;
    private double z;
    private float yaw;
    private float pitch;

    public FairyAnimation(int inventorySlotIndex, @NotNull Configuration animation) {
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
        this.inventorySlotIndex = inventorySlotIndex;
        this.animation = animation;
        if (!(!((Collection)this.animation.getPositions()).isEmpty())) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        this.position = this.animation.getPositions().get(this.index);
        this.countdown = this.position.getDuration();
        this.ticks = (int)(Math.random() * (double)1000);
        this.x = this.position.getX();
        this.y = this.position.getY();
        this.z = this.position.getZ();
        this.yaw = this.position.getYaw();
        this.pitch = this.position.getPitch();
    }

    public final int getTicks() {
        return this.ticks;
    }

    public final void setTicks(int n) {
        this.ticks = n;
    }

    public final double getXSpeed() {
        return this.xSpeed;
    }

    public final void setXSpeed(double d) {
        this.xSpeed = d;
    }

    public final double getYSpeed() {
        return this.ySpeed;
    }

    public final void setYSpeed(double d) {
        this.ySpeed = d;
    }

    public final double getZSpeed() {
        return this.zSpeed;
    }

    public final void setZSpeed(double d) {
        this.zSpeed = d;
    }

    public final float getYawSpeed() {
        return this.yawSpeed;
    }

    public final void setYawSpeed(float f2) {
        this.yawSpeed = f2;
    }

    public final float getPitchSpeed() {
        return this.pitchSpeed;
    }

    public final void setPitchSpeed(float f2) {
        this.pitchSpeed = f2;
    }

    public final double getX() {
        return this.x;
    }

    public final void setX(double d) {
        this.x = d;
    }

    public final double getY() {
        return this.y;
    }

    public final void setY(double d) {
        this.y = d;
    }

    public final double getZ() {
        return this.z;
    }

    public final void setZ(double d) {
        this.z = d;
    }

    public final float getYaw() {
        return this.yaw;
    }

    public final void setYaw(float f2) {
        this.yaw = f2;
    }

    public final float getPitch() {
        return this.pitch;
    }

    public final void setPitch(float f2) {
        this.pitch = f2;
    }

    @Override
    public void tick(@NotNull FairyBuildingBlockEntity<?> blockEntity) {
        int n;
        Intrinsics.checkNotNullParameter(blockEntity, (String)"blockEntity");
        Level level = blockEntity.getLevel();
        if (level == null) {
            return;
        }
        Level world = level;
        double speed = this.animation.getSpeed(blockEntity);
        if (speed > 0.0) {
            this.countdown -= speed;
            if (this.countdown <= 0.0) {
                n = this.index;
                this.index = n + 1;
                if (this.index >= this.animation.getPositions().size()) {
                    this.index = 0;
                }
                this.position = this.animation.getPositions().get(this.index);
                this.countdown = this.animation.getPositions().get(this.index).getDuration() * (1.0 + world.random.nextDouble() * 0.1);
            }
        }
        n = this.ticks;
        this.ticks = n + 1;
        this.xSpeed = (this.position.getX() - this.x) * 0.1;
        this.ySpeed = (this.position.getY() - this.y) * 0.1;
        this.zSpeed = (this.position.getZ() - this.z) * 0.1;
        this.yawSpeed = (this.position.getYaw() - this.yaw) * 0.1f;
        this.pitchSpeed = (this.position.getPitch() - this.pitch) * 0.1f;
        this.x += this.xSpeed;
        this.y += this.ySpeed;
        this.z += this.zSpeed;
        this.yaw += this.yawSpeed;
        this.pitch += this.pitchSpeed;
    }

    @Override
    public void render(@NotNull FairyBuildingBlockEntity<?> blockEntity, @NotNull RenderingProxy renderingProxy2, float tickDelta) {
        Intrinsics.checkNotNullParameter(blockEntity, (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)renderingProxy2, (String)"renderingProxy");
        double cX = this.x + this.xSpeed * (double)tickDelta;
        double cY = this.y + this.ySpeed * (double)tickDelta;
        double cZ = this.z + this.zSpeed * (double)tickDelta;
        float cYaw = this.yaw + this.yawSpeed * tickDelta;
        float cPitch = this.pitch + this.pitchSpeed * tickDelta;
        float yawOffset = switch (WhenMappings.$EnumSwitchMapping$0[this.animation.getMotion().ordinal()]) {
            case 1 -> 0.0f;
            case 2 -> Mth.sin((float)(((float)this.ticks + tickDelta) * 0.03f)) * 3.0f;
            default -> throw new NoWhenBranchMatchedException();
        };
        float pitchOffset = switch (WhenMappings.$EnumSwitchMapping$0[this.animation.getMotion().ordinal()]) {
            case 1 -> 0.0f;
            case 2 -> Mth.sin((float)(((float)this.ticks + tickDelta) * 0.08f)) * 5.0f;
            default -> throw new NoWhenBranchMatchedException();
        };
        renderingProxy2.stack((Function0<Unit>)((Function0)() -> FairyAnimation.render$lambda$0(renderingProxy2, cX, cY, cZ, cYaw, cPitch, this, yawOffset, pitchOffset, blockEntity)));
    }

    private static final Unit render$lambda$0(RenderingProxy $renderingProxy, double $cX, double $cY, double $cZ, float $cYaw, float $cPitch, FairyAnimation this$0, float $yawOffset, float $pitchOffset, FairyBuildingBlockEntity $blockEntity) {
        Intrinsics.checkNotNullParameter((Object)$renderingProxy, (String)"$renderingProxy");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$blockEntity, (String)"$blockEntity");
        $renderingProxy.translate($cX / 16.0, $cY / 16.0, $cZ / 16.0);
        $renderingProxy.rotateY(-$cYaw / 180.0f * (float)Math.PI);
        $renderingProxy.rotateX(-$cPitch / 180.0f * (float)Math.PI);
        $renderingProxy.scale(0.5f, 0.5f, 0.5f);
        switch (WhenMappings.$EnumSwitchMapping$0[this$0.animation.getMotion().ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                $renderingProxy.translate(0.0, 0.25, 0.0);
                $renderingProxy.rotateY(-$yawOffset / 180.0f * (float)Math.PI);
                $renderingProxy.rotateZ(-$pitchOffset / 180.0f * (float)Math.PI);
                $renderingProxy.translate(0.0, -0.25, 0.0);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        $renderingProxy.translate(0.0, 0.125, 0.0);
        $renderingProxy.renderItemStack($blockEntity.getItem(this$0.inventorySlotIndex));
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\u001b\u0010\u0005\u001a\u00020\u00042\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0002H&\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\n\u001a\u00020\u00078&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lmiragefairy2024/mod/fairybuilding/FairyAnimation$Configuration;", "", "Lmiragefairy2024/mod/fairybuilding/FairyBuildingBlockEntity;", "blockEntity", "", "getSpeed", "(Lmiragefairy2024/mod/fairybuilding/FairyBuildingBlockEntity;)D", "Lmiragefairy2024/mod/fairybuilding/FairyAnimation$Motion;", "getMotion", "()Lmiragefairy2024/mod/fairybuilding/FairyAnimation$Motion;", "motion", "", "Lmiragefairy2024/mod/fairybuilding/FairyAnimation$Position;", "getPositions", "()Ljava/util/List;", "positions", "IFR25KU-common"})
    public static interface Configuration {
        @NotNull
        public Motion getMotion();

        @NotNull
        public List<Position> getPositions();

        public double getSpeed(@NotNull FairyBuildingBlockEntity<?> var1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lmiragefairy2024/mod/fairybuilding/FairyAnimation$Motion;", "", "<init>", "(Ljava/lang/String;I)V", "NONE", "FAIRY", "IFR25KU-common"})
    public static final class Motion
    extends Enum<Motion> {
        public static final /* enum */ Motion NONE = new Motion();
        public static final /* enum */ Motion FAIRY = new Motion();
        private static final /* synthetic */ Motion[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Motion[] values() {
            return (Motion[])$VALUES.clone();
        }

        public static Motion valueOf(String value2) {
            return Enum.valueOf(Motion.class, value2);
        }

        @NotNull
        public static EnumEntries<Motion> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = motionArray = new Motion[]{Motion.NONE, Motion.FAIRY};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0010\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0002\u00a2\u0006\u0004\b\n\u0010\u000bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\f\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\f\u001a\u0004\b\u000f\u0010\u000eR\u0017\u0010\u0005\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\f\u001a\u0004\b\u0010\u0010\u000eR\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\b\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u0011\u001a\u0004\b\u0014\u0010\u0013R\u0017\u0010\t\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\f\u001a\u0004\b\u0015\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lmiragefairy2024/mod/fairybuilding/FairyAnimation$Position;", "", "", "x", "y", "z", "", "pitch", "yaw", "duration", "<init>", "(DDDFFD)V", "D", "getX", "()D", "getY", "getZ", "F", "getPitch", "()F", "getYaw", "getDuration", "IFR25KU-common"})
    public static final class Position {
        private final double x;
        private final double y;
        private final double z;
        private final float pitch;
        private final float yaw;
        private final double duration;

        public Position(double x, double y, double z, float pitch, float yaw, double duration) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.pitch = pitch;
            this.yaw = yaw;
            this.duration = duration;
        }

        public final double getX() {
            return this.x;
        }

        public final double getY() {
            return this.y;
        }

        public final double getZ() {
            return this.z;
        }

        public final float getPitch() {
            return this.pitch;
        }

        public final float getYaw() {
            return this.yaw;
        }

        public final double getDuration() {
            return this.duration;
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Motion.values().length];
            try {
                nArray[Motion.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Motion.FAIRY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

