/*
 * Decompiled with CFR 0.152.
 */
package miragefairy2024.wave;

import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import miragefairy2024.shadow.mirrg.kotlin.slf4j.hydrogen.LoggingKt;
import miragefairy2024.wave.ByteArrayKt;
import miragefairy2024.wave.MainKt;
import miragefairy2024.wave.OggKt;
import miragefairy2024.wave.PhaseKt;
import miragefairy2024.wave.Spectrogram;
import miragefairy2024.wave.SpectrogramKt;
import miragefairy2024.wave.WavKt;
import miragefairy2024.wave.Waveform;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001d\u0010\f\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\f\u0010\rR\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u00118\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00118\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0013R\u0014\u0010\u0015\u001a\u00020\u00118\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0013R\u0014\u0010\u0017\u001a\u00020\u00168\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u0013R\u0014\u0010\u001a\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0013\u00a8\u0006\u001b"}, d2={"Lmiragefairy2024/wave/GenerateV2;", "", "<init>", "()V", "Ljava/io/File;", "inputFile", "outputFile", "", "dumpWav", "", "generate", "(Ljava/io/File;Ljava/io/File;Z)V", "degenerate", "(Ljava/io/File;Ljava/io/File;)V", "Lorg/slf4j/Logger;", "logger", "Lorg/slf4j/Logger;", "", "samplesPerSecond", "I", "pixelsPerSecond", "bits", "", "amplifier", "D", "imageHeight", "bias", "IFR25KU-fabric"})
@SourceDebugExtension(value={"SMAP\nGenerateV2.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateV2.kt\nmiragefairy2024/wave/GenerateV2\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,83:1\n1#2:84\n*E\n"})
public final class GenerateV2 {
    @NotNull
    public static final GenerateV2 INSTANCE = new GenerateV2();
    @NotNull
    private static final Logger logger = LoggingKt.getLogger(GenerateV2.class);
    private static final int samplesPerSecond = 48000;
    private static final int pixelsPerSecond = 128;
    private static final int bits = 8;
    private static final double amplifier = 1600.0;
    private static final int imageHeight = (1 << bits) / 2 + 1;
    private static final int bias = (1 << bits) - 1;

    private GenerateV2() {
    }

    /*
     * WARNING - void declaration
     */
    public final void generate(@NotNull File inputFile, @NotNull File outputFile, boolean dumpWav) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)inputFile, (String)"inputFile");
        Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
        Object it = object = SpectrogramKt.readSpectrogram(inputFile);
        boolean bl = false;
        logger.info("Input Image Size: " + ((Spectrogram)it).getBufferedImage().getWidth() + " x " + ((Spectrogram)it).getBufferedImage().getHeight());
        it = SpectrogramKt.fromLogScale((Spectrogram)object);
        boolean bl2 = false;
        it = object = SpectrogramKt.resize((Spectrogram)it, MathKt.roundToInt((double)((double)((Spectrogram)it).getBufferedImage().getWidth() / (double)pixelsPerSecond * (double)samplesPerSecond + (double)bias)), imageHeight);
        boolean bl3 = false;
        logger.info("Internal Image Size: " + ((Spectrogram)it).getBufferedImage().getWidth() + " x " + ((Spectrogram)it).getBufferedImage().getHeight());
        it = object = SpectrogramKt.toWaveform(PhaseKt.generatePhaseGriffinLim(PhaseKt.generatePhaseLegacy((Spectrogram)object), 5, (Function1<? super Spectrogram, Waveform>)((Function1)GenerateV2::generate$lambda$3), (Function1<? super Waveform, Spectrogram>)((Function1)GenerateV2::generate$lambda$4)), bits, 1.0 / amplifier);
        boolean bl4 = false;
        logger.info("Output Waveform Length: " + ((Waveform)it).getDoubleArray().length + " samples");
        it = object = (Object)WavKt.toWavByteArray((Waveform)object);
        boolean bl5 = false;
        if (dumpWav) {
            void it2;
            File file;
            File file2 = file = new File(outputFile.getPath() + ".wav");
            Object object2 = it;
            boolean bl6 = false;
            MainKt.mkdirsParentOrThrow((File)it2);
            ByteArrayKt.writeTo((byte[])object2, file);
        }
        byte[] byArray = OggKt.toOggAsWav((byte[])object);
        it = object = outputFile;
        byte[] byArray2 = byArray;
        boolean bl7 = false;
        MainKt.mkdirsParentOrThrow((File)it);
        ByteArrayKt.writeTo(byArray2, (File)object);
    }

    public static /* synthetic */ void generate$default(GenerateV2 generateV2, File file, File file2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        generateV2.generate(file, file2, bl);
    }

    public final void degenerate(@NotNull File inputFile, @NotNull File outputFile) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)inputFile, (String)"inputFile");
        Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
        Object it = object = WavKt.toWaveformAsWav(OggKt.toWavAsOgg(FilesKt.readBytes((File)inputFile)));
        boolean bl = false;
        if (((Waveform)it).getDoubleArray().length > samplesPerSecond * 10) {
            throw new RuntimeException("too long: " + inputFile.getName() + " (" + (double)((Waveform)it).getDoubleArray().length / (double)samplesPerSecond + "s)");
        }
        it = object;
        boolean bl2 = false;
        logger.info("Input Waveform Length: " + ((Waveform)it).getDoubleArray().length + " samples");
        it = object = SpectrogramKt.toSpectrogram((Waveform)object, bits, 1.0 / amplifier);
        boolean bl3 = false;
        logger.info("Internal Image Size: " + ((Spectrogram)it).getBufferedImage().getWidth() + " x " + ((Spectrogram)it).getBufferedImage().getHeight());
        it = PhaseKt.removePhase((Spectrogram)object);
        boolean bl4 = false;
        it = object = SpectrogramKt.resize((Spectrogram)it, MathKt.roundToInt((double)(((double)((Spectrogram)it).getBufferedImage().getWidth() - (double)bias) / (double)samplesPerSecond * (double)pixelsPerSecond)), imageHeight);
        boolean bl5 = false;
        logger.info("Output Image Size: " + ((Spectrogram)it).getBufferedImage().getWidth() + " x " + ((Spectrogram)it).getBufferedImage().getHeight());
        Spectrogram spectrogram = SpectrogramKt.toLogScale((Spectrogram)object);
        it = object = outputFile;
        Spectrogram spectrogram2 = spectrogram;
        boolean bl6 = false;
        MainKt.mkdirsParentOrThrow((File)it);
        SpectrogramKt.writeTo(spectrogram2, (File)object);
    }

    private static final Waveform generate$lambda$3(Spectrogram it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return SpectrogramKt.toWaveform(it, bits, 1.0);
    }

    private static final Spectrogram generate$lambda$4(Waveform it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return SpectrogramKt.toSpectrogram(it, bits, 1.0);
    }
}

